/*********************************
 *
 * VB Screen Test
 * 
 *  
 *  By David Tucker
 *  Rev: 0.3, 10/24/05 
 *
 *  Test out screen wraping in affine and standard 
 *  bitmap modes for both MX and GX
 *  This is not very pretty but it works
 *
 **********************************/

//vbgcc includes
#include <types.h>
#include <video.h>
#include <joypad.h>
#include <world.h>
#include <mem.h>
#include <misc.h>
#include <object.h>

//dt includes
#include "dt_math.h"
#include "dt_affine.h"
#include "dt_mem.h"

//images
#include "focus_map.h"
#include "alphabet_char.h"

//define the display
#define screenW 384
#define screenH 224

#define LINE_START_X 9
#define LINE_START_Y 5

#define DSP_BGM 10
#define CharSegAll 0x00078000


//memory base of the param table, don't overwrite with char data!
u16* const param = (u16*)0x0003C000;
int state = 0;

//------------------------------------------------------
//Initialization helper functions
//-------------------------------

void set_char(const u8* addr, int num) {
	int i;
	u8*src;

	src = (u8*)addr+(num*16);
	
	for(i=0;i<2048;i++) 
		copymem((BYTE*)CharSegAll+(i*16), src, 16);

	//blank first character
	setmem((BYTE*)CharSeg0,0,16);

	//move image to char table
	copymem((BYTE*)CharSeg3, alphabet_char, alphabet_char_len);
}

void set_bgmap() {
	int i;
	
	//fill in all the bgmaps with numbers
	for(i=0;i<10;i++) {
		setmem_16((HWORD*)BGMap(i), 0, 0x40);
		setmem_16((HWORD*)BGMap(i)+0x40, 0x0610+i, 0x1000-0x80);
		setmem_16((HWORD*)BGMap(i)+0x1000-0x40, 0, 0x40);
	}
	for(i=10;i<14;i++) {
		setmem_16((HWORD*)BGMap(i), 0, 0x40);
		setmem_16((HWORD*)BGMap(i)+0x40, 0x0617+i, 0x1000-0x80);
		setmem_16((HWORD*)BGMap(i)+0x1000-0x40, 0, 0x40);
	}
	//draw vertical border
	for(i=0;i<64*14;i++) {
		setmem_16((HWORD*)BGMap(0)+(i*64), 0, 1);
		setmem_16((HWORD*)BGMap(0)+63+(i*64), 0, 1);
	}
	
	//set BGMap up for menu display
	setmem_16((HWORD*)BGMap(DSP_BGM), 0x0600, 0x700);
	//draw a grey box
	setmem_16((HWORD*)BGMap(DSP_BGM)+0x0700, 0x0661, 0x0700);	
}

void set_obj() {
	int i;
	char *str = "This is an object";

	for(i=0;i<17;i++)
		vbSetObject(i,OBJ_ON,20+i*8,0,20,str[i]+0x600-32);
	
	VIP_REGS[SPT3] = 16;
	VIP_REGS[SPT2] = VIP_REGS[SPT1] = VIP_REGS[SPT0] = 0;
}

void set_affine() {
	PDx_ST pdx;

	if(WA[31].head & WRLD_AFFINE) {
		//Blank Affine mode, so we can test affine wraping
		pdx.pa = 1;
		pdx.pb = 0;
		pdx.pc = 0;
		pdx.pd = 1;
		pdx.dx = WA[31].mx;
		pdx.dy = WA[31].my;
		pdx.paralax = 0;
		affine_set_all(31,&pdx);
	} else if(WA[31].head & WRLD_HBIAS) {
		setmem_16((HWORD*)((WA[31].param<<1)+0x00020000),
			       	0, 224*2);
	}
}
void draw_table() {
	int line;
	
	line = LINE_START_Y+1;
	vbTextOut(DSP_BGM, LINE_START_X+1, line++,"VB Screen Test");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++,"By David Tucker");
	line++;
	vbTextOut(DSP_BGM, LINE_START_X+1, line++," MX:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++," MY:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++," MP:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++," GX:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++," GY:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++," GP:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++,"  W:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++,"  H:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++,"SCX:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++,"SCY:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++,"OVP:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++,"OVR:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++,"MOD:");
	vbTextOut(DSP_BGM, LINE_START_X+1, line++,"BGM:");
}

//-------------------------------------------------
//menu maintenance functions
//--------------------------

void show_status() {
	int line_x = LINE_START_X+6;
	int line_y = LINE_START_Y+4;
	int mode;
	
	//Print status line
	vbTextOut(DSP_BGM, line_x,line_y++,itoa(WA[31].mx,16,4));
	vbTextOut(DSP_BGM, line_x,line_y++,itoa(WA[31].my,16,4));
	vbTextOut(DSP_BGM, line_x,line_y++,itoa(WA[31].mp,16,4));
	vbTextOut(DSP_BGM, line_x,line_y++,itoa(WA[31].gx,16,4));
	vbTextOut(DSP_BGM, line_x,line_y++,itoa(WA[31].gy,16,4));
	vbTextOut(DSP_BGM, line_x,line_y++,itoa(WA[31].gp,16,4));
	vbTextOut(DSP_BGM, line_x,line_y++,itoa(WA[31].w ,16,4));
	vbTextOut(DSP_BGM, line_x,line_y++,itoa(WA[31].h ,16,4));

	//SCX/SCY
	vbTextOut(DSP_BGM, line_x,line_y++,
			itoa((WA[31].head>>10)&3,16,1));
	vbTextOut(DSP_BGM, line_x,line_y++,
			itoa((WA[31].head>>8)&3,16,1));
	
	vbTextOut(DSP_BGM, line_x,line_y++,itoa(WA[31].ovr,16,4));
	//Ovr 
	vbTextOut(DSP_BGM, line_x,line_y++,
			itoa(0!=(WA[31].head & WRLD_OVR),16,1));
	//Affine mode
	mode = (WA[31].head>>12)&3;
	switch(mode) {
	case 0:
		vbTextOut(DSP_BGM, line_x,line_y++,"Normal");
		break;
	case 1:
		vbTextOut(DSP_BGM, line_x,line_y++,"H-Bias");
		break;
	case 2:
		vbTextOut(DSP_BGM, line_x,line_y++,"Affine");
		break;
	case 3:
		vbTextOut(DSP_BGM, line_x,line_y++,"Obj   ");
		break;
	}
	
	//BGMap Base
	vbTextOut(DSP_BGM, line_x,line_y++,
			itoa((WA[31].head & 0x000F),16,1));
}

void set_state(int nstate) {
	HWORD *b_addr;
	int i;

	//test if going past end of array, and ignore request
	if((nstate <0) || (nstate >13)) return;

	//clear old selection
	b_addr = (HWORD*)(BGMap(DSP_BGM)+(LINE_START_X*2)
			+(LINE_START_Y+4+state)*128);
	for(i=0;i<5;i++)
		b_addr[i] &=0x3FFF;

	state = nstate;

	//set new sselection
	b_addr = (HWORD*)(BGMap(DSP_BGM)+(LINE_START_X*2)
			+(LINE_START_Y+4+state)*128);

	for(i=0;i<5;i++)
		b_addr[i] |=0x4000;
}

void handle_input() {
	int inc;
	u16 stat = vbReadPad();

	if(K_PADS & stat) {
		if((K_RU|K_LU) & stat) {
			set_state(state-1);
			vbWaitFrame(5);
		} else if((K_RD|K_LD) & stat) {
			set_state(state+1);
			vbWaitFrame(5);
		} else {
			if((K_RR|K_LR) & stat)		inc = 1;
			else if((K_RL|K_LL) & stat)	inc = -1;
			
			switch(state) {
			case 0: //mx
				WA[31].mx += inc;
				set_affine();
				break;
			case 1: //my
				WA[31].my += inc;
				set_affine();
				break;
			case 2: //mp
				WA[31].mp += inc;
				break;
			case 3: //gx
				WA[31].gx += inc;
				break;
			case 4: //gy
				WA[31].gy += inc;
				break;
			case 5: //gp
				WA[31].gp += inc;
				break;
			case 6: //w
				WA[31].w  += inc;
				break;
			case 7: //h
				WA[31].h  +=inc;
				break;
			case 8: //scx
				WA[31].head = (WA[31].head&0xF3FF)| 
					((((WA[31].head>>10)+inc)&3)<<10);
				vbWaitFrame(5);
				break;
			case 9: //scy
				WA[31].head = (WA[31].head&0xFCFF)| 
					((((WA[31].head>>8)+inc)&3)<<8);
				vbWaitFrame(5);
				break;
			case 10: //overp_char
				WA[31].ovr += inc;
				vbWaitFrame(2);
				break;
			case 11: //ovr
				WA[31].head ^= WRLD_OVR;
				vbWaitFrame(5);
				break;
			case 12: //affine
				WA[31].head = (WA[31].head&0xCFFF)| 
					((((WA[31].head>>12)+inc)&3)<<12);
				set_affine();
				vbWaitFrame(5);
				break;
			case 13: //BGMap
				WA[31].head = (WA[31].head&0xFFF0)|
					((WA[31].head+inc)&0x000F);
				vbWaitFrame(5);
				break;
			default:
				state = 0;
				break;
			}

			//update display
			show_status();
		}
	}	
}

//------------------------------------------------------
//Display the focus screen and wait for keyboard input
//--------------------
void focus_screen() {
	int i;

	//initiate left focus screen
	WA[31].head = WRLD_LON;
	WA[31].gx = 0;
	WA[31].gp = 0;
	WA[31].gy = 0;
	WA[31].mx = 0;
	WA[31].mp = 0;
	WA[31].my = 0;
	WA[31].w  = screenW;
	WA[31].h  = screenH;

	//initiate right focus screen
	WA[30].head = WRLD_RON;
	WA[30].gx = 0;
	WA[30].gp = 0;
	WA[30].gy = 0;
	WA[30].mx = 0;
	WA[30].mp = 0;
	WA[30].my = screenH;
	
	WA[30].w  = screenW;
	WA[30].h  = screenH;

	//last world
	WA[29].head = WRLD_END;

	//move image to char table and bgmap
	copymem((BYTE*)CharSeg0, focus_char, focus_char_len);
	setmem_16((HWORD*)BGMap(0), 0x0400, 0x1000);
	copymem((BYTE*)BGMMBase, focus_map, focus_map_len);

	//do we need to put a delay in?

	vbFXFadeIn(1);
	while(! vbPadKeyDown()) ;
	while(! vbPadKeyUp()  ) ;
	vbFXFadeOut(1);
}

//------------------------------------------------------
//setup main program, could be cleaner
//--------------------
void initialize() {
	
	//World 31
	WA[31].head  = WRLD_ON;
	WA[31].gx    = 0;
	WA[31].gp    = 0;
	WA[31].gy    = 0;
	WA[31].mx    = 0;
	WA[31].mp    = 0;
	WA[31].my    = 0;
	WA[31].w     = screenW;
	WA[31].h     = screenH;
	WA[31].param = (u32)param;
	WA[31].ovr   = 0; 
	//World 30
	WA[30].head  = DSP_BGM | WRLD_ON;
	WA[30].gx    = LINE_START_X*8;
	WA[30].gp    = -4;
	WA[30].gy    = LINE_START_Y*8;
	WA[30].mx    = 0;
	WA[30].mp    = 0;
	WA[30].my    = 224;
	WA[30].w     = 136;
	WA[30].h     = 8*18;
	//World 29
	WA[29].head  = DSP_BGM | WRLD_ON;
	WA[29].gx    = 0;
	WA[29].gp    = -5;
	WA[29].gy    = 0;
	WA[29].mx    = 0;
	WA[29].mp    = 0;
	WA[29].my    = 0;
	WA[29].w     = screenW;
	WA[29].h     = screenH;
	//World 28
	WA[28].head  = WRLD_END;

	//fill all chars with filler character
	set_char(alphabet_char,1);
	
	set_bgmap();
	
	set_obj();

	//setup initial status line
	draw_table();
	SET_GPLT(1,0xB7);

	set_state(0);
	
	show_status();
	
	vbFXFadeIn(1);
}


int main () {
	//setup column table, looks broken, verify
	//vbSetColTable();
	
	//turn on display
	vbDisplayOn();
	vbDisplayHide();
	
	//wait for screen to stabalize
	vbWaitFrame(50*2);
	
	focus_screen();
	initialize();

	while (1) {
		//delay 3/50th of a second
		vbWaitFrame(1);
		handle_input();
	}
}
