#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char **argv) {
	unsigned int i,filesize,headsize,total;
	unsigned char *pad;
	char *str;
	FILE *fp,*fhead;

	if ((argc != 3) && (argc != 4)) {
		if ((str = strrchr(argv[0],'\\'))) str++; //filter directories
		else str = argv[0];
		printf("Usage: %s <infile> <min size> [header]\n\"min size\" is entered as a power of 2.\n  A 'min size' of 15 is 32KB, 16 is 64KB, 17 is 128KB, etc.\n\"header\" is the name of the file to append to the padded output. [optional]\n",str);
		return 1;
	}

	if (!(fp = fopen(argv[1],"a+b"))) {
		printf("Cannot open \"%s\"\n",argv[1]);
		return 1;
	}
	fseek(fp,0,SEEK_END);
	filesize = ftell(fp);

	if (argc == 4) {
		if (!(fhead = fopen(argv[3],"rb"))) {
			printf("Cannot open \"%s\"\n",argv[3]);
			return 1;
		}
		fseek(fhead,0,SEEK_END);
		headsize = ftell(fhead);
		fseek(fhead,0,SEEK_SET);
	}

	sscanf(argv[2],"%d",&total);
	if (total > 25) total = 25;
	total=1<<total;
	while (total < (filesize+headsize)) total<<=1;
	total -= filesize;

	if (!(pad = (unsigned char*)malloc(total))) {
		printf("Cannot allocate memory!\n");
		return 1;
	}
	memset(pad,0xFF,total);
	if (argc == 4) {
		fread(pad+(total-headsize),1,headsize,fhead);
		fclose(fhead);
	}
	fwrite(pad,1,total,fp);
	fclose(fp);
	printf("Completed padding to 0x%X bytes, 0x%X bytes added\n",total+filesize,total);
	return 0;
}
