#!/bin/sh
#

## Test for executables
TestEXE()
{
  TEMP=`type $1`
  if [ $? != 0 ]; then
    echo "Error: $1 not installed";
    exit 1;
  fi
}

TestEXE "make";
TestEXE "gcc";
TestEXE "flex";
TestEXE "patch";
TestEXE "tar";
TestEXE "gzip";
TestEXE "autoconf";
TestEXE "gperf";
TestEXE "bison";


## Test for files to unpack
TestFile()
{
  if [ ! -f "$1" ]; then 
    echo "Error: $1 not found";
    exit 1;
  fi
}

TestFile "binutils-2.10.tar.gz";
TestFile "binutils-2.10-v810patch1021.gz";
TestFile "gcc-2.95.2.tar.gz";
TestFile "gcc-2.95.2-v810patch0927.gz";
TestFile "newlib-1.10.0.tar.gz";
TestFile "binutils-2.10-vb_v810patch-02";
TestFile "gcc-2.95.2-vb_v810patch-01";
TestFile "newlib-1.10.0-vb_v810patch-01";


## Build Binutils
tar zxvf binutils-2.10.tar.gz
cd binutils-2.10
gzip -dc ../binutils-2.10-v810patch1021.gz | patch -p1
cat ../binutils-2.10-vb_v810patch-02 | patch -p1
cd ..
mkdir binutil_build
cd binutil_build
../binutils-2.10/configure --target=v810 --prefix=/usr/local
make all install
if [ $? != 0 ]; then
  echo "Error: building binutils";
  exit 1;
fi
cd ..

# Build a minimal GCC 
tar zxvf gcc-2.95.2.tar.gz
cd gcc-2.95.2
gzip -dc ../gcc-2.95.2-v810patch0927.gz | patch -p1
cat ../gcc-2.95.2-vb_v810patch-01 | patch -p1
cd ..
mkdir gcc_build
cd gcc_build
../gcc-2.95.2/configure --target=v810 --prefix=/usr/local \
   --enable-languages=c --without-headers --with-newlib
make all install
if [ $? != 0 ]; then
  echo "Error: building gcc";
  exit 1;
fi
cd ..

# Build Newlib
# if this fails thain dos2unix the newlib folder
tar xzvf newlib-1.10.0.tar.gz
cd newlib-1.10.0
cat ../newlib-1.10.0-vb_v810patch-01 | patch -p1
cd ..
mkdir newlib_build
cd newlib_build
../newlib-1.10.0/configure --target=v810 --prefix=/usr/local 
make all install
if [ $? != 0 ]; then
  echo "Error: building newlib";
  exit 1;
fi
cd ..

# Build GCC again with no restrictions
cd gcc_build
../gcc-2.95.2/configure --target=v810 --prefix=/usr/local \
   --enable-languages=c
make all install
if [ $? != 0 ]; then
  echo "Error: building gcc full";
  exit 1;
fi
cd ..

# Optionaly Build GDB (not fully implemented)
#tar zxvf gdb-5.0.tar.gz
#cd gdb-5.0
#gzip -dc ../gdb-5.0-v810patch1021.gz | patch -p1
#cd ..
#mkdir gdb_build
#cd gdb_build
#../gdb-5.0/configure --target=v810 --prefix=/usr/local
#make all install
#if [ $? != 0 ]; then
#  echo "Error: building gdb";
#  exit 1;
#fi
#cd ..

echo "Build completed sucsessfully run v810-gcc for more info"
