#ifdef MSS
#include <mss.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "cp_io.h"
#include "v810_opt.h" //Needed for sign_16()
#include "v810_cpu.h"
#include "v810_cpuD.h"
#include "vb_dspD.h" //Debug code
#include "vb_vbt.h"
#include "vb_vbtD.h"
#include "vb_set.h"
#include "vb_dsp.h"

#ifndef MAX_PATH
#define MAX_PATH 200
#endif

////////////////////////////////////////////////////////////////////
// Globals
int pCnt = 0;
int isDsp =0;
int CurObj=3;
int MaxBrt = 30;
PALLETE pallete;  //keep a global pall, so we dont have to clear the whole thing....
//Instead we Blit the first n Bitmaps, instead of a masked blit...
int exit_flag=0;

VB_DSPCACHE tDSPCACHE; //Array of Display Cache info...

BITMAP *world_bmp;
BITMAP *world_bmp2;
BITMAP *dsp_bmp;

//Offset into Chr ram for the given chr#
WORD ChrOff[4] = {0x00006000,0x0000E000,0x00016000,0x0001E000};


////////////////////////////////////////////////////////////////////
// Retreaves a character(Sprite) from the character table, Only used for DisplayRom()
// Now directly acesses the video ram (Scary)
void getChr(HWORD num, HWORD chr[]) {
    //Strip the first 2 bits to decode what chr table to use, use the remaning bits to index into the table...
    WORD offset =ChrOff[(num>>9)&0x03] + (CHR_SIZE * (num & 0x01FF));       
    if((offset < V810_DISPLAY_RAM.lowaddr)||(offset+CHR_SIZE > V810_DISPLAY_RAM.highaddr)) 
    offset = ChrOff[0]; //Set to a known value (Chr0)
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    ((WORD *)chr)[0] = ((WORD *)(offset))[0];
    ((WORD *)chr)[1] = ((WORD *)(offset))[1];
    ((WORD *)chr)[2] = ((WORD *)(offset))[2];
    ((WORD *)chr)[3] = ((WORD *)(offset))[3];
}

// Translates a chr to a sprite, Only used for DisplayRom()
void chr2sprite(HWORD chr[],BITMAP *sprt) {
    int i;
    for(i = 0; i < 8; i++) {// we want words not bytes
        sprt->line[i][0] = ((chr[i] >>  0) & 3)+1;
        sprt->line[i][1] = ((chr[i] >>  2) & 3)+1;
        sprt->line[i][2] = ((chr[i] >>  4) & 3)+1;
        sprt->line[i][3] = ((chr[i] >>  6) & 3)+1;
        sprt->line[i][4] = ((chr[i] >>  8) & 3)+1;
        sprt->line[i][5] = ((chr[i] >> 10) & 3)+1;
        sprt->line[i][6] = ((chr[i] >> 12) & 3)+1;
        sprt->line[i][7] = ((chr[i] >> 14) & 3)+1;
    }
}

//Replaces the two Fn's Above (Faster?)
/*VB_INLINE*/ void fchr2sprite(HWORD num,BITMAP *sprt, bool hflp, bool vflp,BYTE pal[]) {
    int i;

    //Strip the first 2 bits to decode what chr table to use, use the remaning bits to index into the table...
    WORD offset = ChrOff[(num>>9)&0x03] + (CHR_SIZE * (num & 0x01FF)) 
		+ V810_DISPLAY_RAM.off;       

    if (!hflp && !vflp){ 
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[i][0] = pal[((((HWORD *)(offset))[i] >>  0) & 3)]; //replace "<<4) & 0x3f);" with cPal[#]
            sprt->line[i][1] = pal[((((HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[i][2] = pal[((((HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[i][3] = pal[((((HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[i][4] = pal[((((HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[i][5] = pal[((((HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[i][6] = pal[((((HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[i][7] = pal[((((HWORD *)(offset))[i] >> 14) & 3)];
        }
    } else if (hflp && vflp){ 
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[7-i][7] = pal[((((HWORD *)(offset))[i] >>  0) & 3)];
            sprt->line[7-i][6] = pal[((((HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[7-i][5] = pal[((((HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[7-i][4] = pal[((((HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[7-i][3] = pal[((((HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[7-i][2] = pal[((((HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[7-i][1] = pal[((((HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[7-i][0] = pal[((((HWORD *)(offset))[i] >> 14) & 3)];
        }
    } else if(hflp) {
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[i][7] = pal[((((HWORD *)(offset))[i] >>  0) & 3)];
            sprt->line[i][6] = pal[((((HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[i][5] = pal[((((HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[i][4] = pal[((((HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[i][3] = pal[((((HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[i][2] = pal[((((HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[i][1] = pal[((((HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[i][0] = pal[((((HWORD *)(offset))[i] >> 14) & 3)];
        }
    } else if(vflp) {
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[7-i][0] = pal[((((HWORD *)(offset))[i] >>  0) & 3)];
            sprt->line[7-i][1] = pal[((((HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[7-i][2] = pal[((((HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[7-i][3] = pal[((((HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[7-i][4] = pal[((((HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[7-i][5] = pal[((((HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[7-i][6] = pal[((((HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[7-i][7] = pal[((((HWORD *)(offset))[i] >> 14) & 3)];
        }
    }
}

////////////////////////////////////////////////////////////////////////////////////////
// Jason - 
// Renders a given character number into the byte buffer provided at
// The starting X and Y locations.  Note that p_wBitmapWidth is the width of the 
// buffer into which we are rendering.
// Review-- Why do we need the Palette Pointer?
//
VB_INLINE void vRenderCharacter(HWORD p_hwCharacterNumber,// The number of the character to display
				 BYTE *p_pbSpriteData, // The raw byte buffer to render the sprite into.
				 WORD p_wStartingX,// Starting X offset within the byte buffer
				 WORD p_wStartingY,// Starting Y offset in the byte buffer
				 WORD p_wBitmapWidth, // How wide the bitmap we're rendering on is.
				 bool p_fFlipHorizontally, 
				 bool p_fFlipVertically,
				 BYTE p_rgbPalette[]) 
{
    int l_nRowCounter;

    WORD l_wDataOffset = ChrOff[(p_hwCharacterNumber>>9)&0x03] + (CHR_SIZE * (p_hwCharacterNumber & 0x01FF)) + V810_DISPLAY_RAM.off;       
	//WORD offset = ChrOff[(num>>9)&0x03] + (CHR_SIZE * (num & 0x01FF)) + V810_DISPLAY_RAM.off;       
	HWORD * l_phwLineData = ((HWORD *)(l_wDataOffset));
	HWORD l_hwCurrentData; // We use this to store the current data.

	p_pbSpriteData += ((p_wStartingX) + (p_wStartingY*p_wBitmapWidth));

	int vinc = 1;
	int hinc = 1;

	if(p_fFlipVertically) {
		vinc = -1;
		l_phwLineData+=7;
	}
	if(p_fFlipHorizontally) {
		hinc = -1; 
		p_pbSpriteData+=7;
	}

	l_nRowCounter=7;

	do {
		l_hwCurrentData = *l_phwLineData;
		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;

		if(p_fFlipHorizontally) 
			p_pbSpriteData+=16;

		p_pbSpriteData+=(p_wBitmapWidth-8); // Skip to start of next.

		l_phwLineData += vinc;
	} while (l_nRowCounter--);
}

////////////////////////////////////////////////////////////////////
// returns a BGMap Buffer VB_BGMAP BGMap_Buff[4096]
// Now directly acesses the video ram (Scary)
VB_INLINE void getBGmap(HWORD num, VB_BGMAP BGMap_Buff[]) {
    int i;
    HWORD thword;

    WORD offset = BGMAP_OFFSET + (BGMAP_SIZE*(num & 0xF));// only 14 posible bg's, this is 16 but whos counting?
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

	i = (BGMAP_SIZE>>1)-1;
	do {
        // Make shure we only grab num's from 0-4095... 
        thword = ((HWORD *)(offset))[i]; 
        BGMap_Buff[i].BCA   = thword & 0x7FF;
        BGMap_Buff[i].VFLP  = (thword >> 12) & 0x1;
        BGMap_Buff[i].HFLP  = (thword >> 13) & 0x1;
        BGMap_Buff[i].BPLTS = (thword >> 14) & 0x3;
    } while(i--);
}

// Converts a BG Map Buffer to a World Picture, With Chrs in place.
/*VB_INLINE*/ void BGMap2World(HWORD num, BITMAP *wPlane) {
    int i;
    VB_BGMAP BGMap_Buff[4096];
    HWORD thword;
    WORD offset = BGMAP_OFFSET + (BGMAP_SIZE*(num & 0xF))+V810_DISPLAY_RAM.off;// only 14 posible bg's, this is 16 but whos counting?

    //Grab the BGMap info...
	i = (BGMAP_SIZE>>1)-1;
	do {
        // Make shure we only grab num's from 0-4095... 
        thword = ((HWORD *)(offset))[i]; 
        BGMap_Buff[i].BCA   = thword & 0x7FF;
        BGMap_Buff[i].VFLP  = (thword >> 12) & 0x1;
        BGMap_Buff[i].HFLP  = (thword >> 13) & 0x1;
        BGMap_Buff[i].BPLTS = (thword >> 14) & 0x3;
    } while(i--);


    if(isDsp){ //If were in the Display and not the debug code...
        if(tDSPCACHE.BgmPALMod>0) { //If cache is invalid
			i=3;
			do {
                tDSPCACHE.BgmPAL[i][0]=((tVIPREG.GPLT[i]   )&3)+1; //First collor is transparent, offset by 1
                tDSPCACHE.BgmPAL[i][1]=((tVIPREG.GPLT[i]>>2)&3)+1; 
                tDSPCACHE.BgmPAL[i][2]=((tVIPREG.GPLT[i]>>4)&3)+1;
                tDSPCACHE.BgmPAL[i][3]=((tVIPREG.GPLT[i]>>6)&3)+1;
                tDSPCACHE.BgmPAL[i][0]=0; //Fill in the transparent char
            } while(i--);
            tDSPCACHE.BgmPALMod=0;
        }
    } else { //If in debug land (make this better!)
        for(i=0; i<4; i++) {
            tDSPCACHE.BgmPAL[i][0]=1;
            tDSPCACHE.BgmPAL[i][1]=2;
            tDSPCACHE.BgmPAL[i][2]=3;
            tDSPCACHE.BgmPAL[i][3]=4;
        }
    }

	// For each character in the map
	for(i=0;i<(BGMAP_SIZE >> 1);i++) {
        vRenderCharacter(BGMap_Buff[i].BCA, *wPlane->line, ((i&63)<<3), ((i>>6)<<3),
			wPlane->w, BGMap_Buff[i].HFLP, BGMap_Buff[i].VFLP, tDSPCACHE.BgmPAL[(BGMap_Buff[i].BPLTS&0x3)]);
    };

}

////////////////////////////////////////////////////////////////////
// returns a OBJ_buf Buffer VB_OBJ OBJ_Buff[0x400]
// Now directly acesses the video ram (Scary)
/*VB_INLINE*/ void getObj(HWORD num, VB_OBJ OBJ_Buff[]) {
    WORD tword;
    WORD offset = OBJ_OFFSET + (OBJ_SIZE*(num & 0x03FF)); // 1024 posible obj... //0x07FF?
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    OBJ_Buff[num].JX = (int)sign_16(((HWORD *)(offset))[0]);
    tword = ((HWORD *)(offset))[1];
    OBJ_Buff[num].JP = (int)sign_14(tword & 0x3FFF);
    OBJ_Buff[num].JRON = (tword >> 14) & 0x1;
    OBJ_Buff[num].JLON = (tword >> 15) & 0x1;
    OBJ_Buff[num].JY = (int)sign_16(((HWORD *)(offset))[2]);
    tword = ((HWORD *)(offset))[3];
    OBJ_Buff[num].JCA = tword & 0x7FF;
    OBJ_Buff[num].JVFLP = (tword >> 12) & 0x1;
    OBJ_Buff[num].JHFLP = (tword >> 13) & 0x1;
    OBJ_Buff[num].JPLTS = (tword >> 14) & 0x3;
}

////////////////////////////////////////////////////////////////////
// vGetAllObjects
// Returns all objects 
//
VB_INLINE void vGetAllObjects(VB_OBJ OBJ_Buff[]) {
    WORD tword;
    int num;
    WORD offset = OBJ_OFFSET + V810_DISPLAY_RAM.off;
    for(num=0; num<0x400; num++) {
        OBJ_Buff[num].JX = (int)sign_16(((HWORD *)(offset))[0]);
        tword = ((HWORD *)(offset))[1];
        OBJ_Buff[num].JP = (int)sign_14(tword & 0x3FFF);
        OBJ_Buff[num].JRON = (tword >> 14) & 0x1;
        OBJ_Buff[num].JLON = (tword >> 15) & 0x1;
        OBJ_Buff[num].JY = (int)sign_16(((HWORD *)(offset))[2]);
        tword = ((HWORD *)(offset))[3];
        OBJ_Buff[num].JCA = tword & 0x7FF;
        OBJ_Buff[num].JVFLP = (tword >> 12) & 0x1;
        OBJ_Buff[num].JHFLP = (tword >> 13) & 0x1;
        OBJ_Buff[num].JPLTS = (tword >> 14) & 0x3;
        offset+=OBJ_SIZE;//Increment the pointer
    }
}

// Converts a OBJ_buf Buffer to a World Picture, With Chrs in place.
//Pass in int spt0-3 for the world num....
//Note modified tSprt for Blits to screen, enabling Transparency.
/*VB_INLINE*/ void Obj2World(VB_OBJ OBJ_Buff[], BITMAP *wPlane,
						 int spt_num, int img_n) {
    int i;
    int end = 0;
    BITMAP* tSprt = create_bitmap(8,8);
    if(spt_num > 0) {
        if((tVIPREG.SPT[spt_num]&0x3FF) >= (tVIPREG.SPT[spt_num-1]&0x3FF)) {
            end = (tVIPREG.SPT[spt_num-1]&0x3FF);
        }
    }

    if(isDsp){ //If were in the Display and not the debug code...
        if(tDSPCACHE.ObjPALMod>0) { //If cache is invalid
			i = 3;
            do {
                tDSPCACHE.ObjPAL[i][0]=((tVIPREG.JPLT[i]   )&3)+1; //First collor is transparent, offset by 1
                tDSPCACHE.ObjPAL[i][1]=((tVIPREG.JPLT[i]>>2)&3)+1; 
                tDSPCACHE.ObjPAL[i][2]=((tVIPREG.JPLT[i]>>4)&3)+1;
                tDSPCACHE.ObjPAL[i][3]=((tVIPREG.JPLT[i]>>6)&3)+1;
                tDSPCACHE.ObjPAL[i][0]=0; //Fill in the transparent char
            } while(i--);
            tDSPCACHE.ObjPALMod=0;
        }
    } else { //If in debug land (make this better!),force a valid pallet
		i = 3;
        do {
            tDSPCACHE.ObjPAL[i][0]=1;
            tDSPCACHE.ObjPAL[i][1]=2;
            tDSPCACHE.ObjPAL[i][2]=3;
            tDSPCACHE.ObjPAL[i][3]=4;
        } while(i--);
    }

    for(i = tVIPREG.SPT[spt_num]&0x3FF; i >= end ; i--) { //No!!!
        if((img_n==0)&&(OBJ_Buff[i].JLON)) { //Default, no paralax
            fchr2sprite(OBJ_Buff[i].JCA, tSprt,OBJ_Buff[i].JHFLP,OBJ_Buff[i].JVFLP,
				tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]); //Pass in the palet...
            masked_blit(tSprt, wPlane, 0, 0, (OBJ_Buff[i].JX+7), (OBJ_Buff[i].JY+7), 8, 8);
        } else if((img_n==1)&&(OBJ_Buff[i].JLON)) { //Left Immage
            fchr2sprite(OBJ_Buff[i].JCA, tSprt,OBJ_Buff[i].JHFLP,OBJ_Buff[i].JVFLP,
				tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]); //Pass in the palet...
            masked_blit(tSprt, wPlane, 0, 0, (OBJ_Buff[i].JX+7)-OBJ_Buff[i].JP,
				(OBJ_Buff[i].JY+7), 8, 8);
        } else if((img_n==2)&&(OBJ_Buff[i].JRON)) { //Right Immage
            fchr2sprite(OBJ_Buff[i].JCA, tSprt,OBJ_Buff[i].JHFLP,OBJ_Buff[i].JVFLP,
				tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]); //Pass in the palet...
            masked_blit(tSprt, wPlane, 0, 0, (OBJ_Buff[i].JX+7)+OBJ_Buff[i].JP,
				(OBJ_Buff[i].JY+7), 8, 8);
        }
    }
    destroy_bitmap(tSprt);
}

//Display the direct screen draws
//Pass in the mem buffer (0-3) and the world bitmap to draw on
//This clears the mem, as it should keep that in mind
//0-1 left dsp, 2-3 right dsp
VB_INLINE void DSP2World(int num, BITMAP *wPlane ) {
    HWORD chr;
    int y, x;
    int chr_x = 384+7;
    int chr_y = 256+7;
    WORD toffset = 0;
    WORD offset = (0x00008000*num); //Select Bitmap 0-3
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    for(x=7; x < chr_x; x++) {
        for(y=7; y < chr_y; y+=8) {
            chr = ((HWORD *)(offset))[0];
            //Display it if not transparent
            if((chr >> 0)  & 3) wPlane->line[y+0][x] = ((chr >>  0) & 3)+1;
            if((chr >> 2)  & 3) wPlane->line[y+1][x] = ((chr >>  2) & 3)+1;
            if((chr >> 4)  & 3) wPlane->line[y+2][x] = ((chr >>  4) & 3)+1;
            if((chr >> 6)  & 3) wPlane->line[y+3][x] = ((chr >>  6) & 3)+1;
            if((chr >> 8)  & 3) wPlane->line[y+4][x] = ((chr >>  8) & 3)+1;
            if((chr >> 10) & 3) wPlane->line[y+5][x] = ((chr >> 10) & 3)+1;
            if((chr >> 12) & 3) wPlane->line[y+6][x] = ((chr >> 12) & 3)+1;
            if((chr >> 14) & 3) wPlane->line[y+7][x] = ((chr >> 14) & 3)+1;

            //Clear it, if needed
            if (tVIPREG.XPCTRL&2) 
				((HWORD *)(offset))[0] = 0;
            offset+=2;
        }
    }
}

////////////////////////////////////////////////////////////////////
// returns a WORLD_buf Buffer VB_WORLD WORLD_Buff[32]
// Now directly acesses the video ram (Scary)
/*VB_INLINE*/ void getWorld(HWORD num, VB_WORLD WORLD_Buff[]) {
    WORD tword;

    WORD offset = WORLD_OFFSET + (WORLD_SIZE*(num & 0x01F)); // only 32 posible worlds...
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    tword = ((HWORD *)(offset))[0]; 
    WORLD_Buff[num].LON = ((tword >> 15) & 0x01);
    WORLD_Buff[num].RON = ((tword >> 14) & 0x01);
    WORLD_Buff[num].BGM = ((tword >> 12) & 0x03);
    WORLD_Buff[num].SCX = ((tword >> 10) & 0x03);
    WORLD_Buff[num].SCY = ((tword >>  8) & 0x03);
    WORLD_Buff[num].OVER= ((tword >>  7) & 0x01);
    WORLD_Buff[num].END = ((tword >>  6) & 0x01);
/*
	//remove me if not nesisary
    WORLD_Buff[num].Unknown1 = ((tword >>  5) & 0x01);
    WORLD_Buff[num].Unknown2 = ((tword >>  4) & 0x01);
*/
    WORLD_Buff[num].BGMAP_BASE =  (tword & 0x0F);
    
    WORLD_Buff[num].GX = (int)sign_16(((HWORD *)(offset))[1]); 
    WORLD_Buff[num].GP = (int)sign_16(((HWORD *)(offset))[2]);
    WORLD_Buff[num].GY = (int)sign_16(((HWORD *)(offset))[3]);

    WORLD_Buff[num].MX = (int)sign_16(((HWORD *)(offset))[4]);
    WORLD_Buff[num].MP = (int)sign_16(((HWORD *)(offset))[5]);
    WORLD_Buff[num].MY = (int)sign_16(((HWORD *)(offset))[6]);

    WORLD_Buff[num].W = (((HWORD *)(offset))[7]+1);
    WORLD_Buff[num].H = (((HWORD *)(offset))[8]+1);

    WORLD_Buff[num].PARAM_BASE = (((HWORD *)(offset))[9]);
    WORLD_Buff[num].OVERP_CHR = ((HWORD *)(offset))[10];
/*
	//remove me if not nesisary
    WORLD_Buff[num].Dont_Write[0] = ((HWORD *)(offset))[11];
    WORLD_Buff[num].Dont_Write[1] = ((HWORD *)(offset))[12];
    WORLD_Buff[num].Dont_Write[2] = ((HWORD *)(offset))[13];
    WORLD_Buff[num].Dont_Write[3] = ((HWORD *)(offset))[14];
    WORLD_Buff[num].Dont_Write[4] = ((HWORD *)(offset))[15];

	//remove me
	if(WORLD_Buff[num].OVER)
		dtprintf(10,ferr,"write 0x%08lx to OVER\n",WORLD_Buff[num].OVER);
	if(WORLD_Buff[num].OVERP_CHR)
		dtprintf(10,ferr,"write 0x%08lx to OVERP_CHR\n",WORLD_Buff[num].OVERP_CHR);

	if(WORLD_Buff[num].Unknown1)
		dtprintf(10,ferr,"Unknown1 in world\n");
	if(WORLD_Buff[num].Unknown2)
		dtprintf(10,ferr,"Unknown2 in world\n");

	for(int i=0;i<5;i++)
		if(WORLD_Buff[num].Dont_Write[i])
			dtprintf(10,ferr,"write 0x%08lx to Dont_Write[%d]\n",WORLD_Buff[num].Dont_Write[i],i);
*/
}

//
VB_INLINE void getAffine(int y, int pBase, AFFINE_MAP &AFN_MP) {
    WORD offset;
    int t_int[4];

	offset = ((pBase*2)+BGMAP_OFFSET)&0xFFFFFFFE;
	offset += y<<4; //(y*16)

	//grab the afine entrys
	t_int[0]     = (int) sign_16((((HWORD *)(offset+V810_DISPLAY_RAM.off  ))[0])&0xFFFF);
	AFN_MP.prlx  = (int) sign_16((((HWORD *)(offset+V810_DISPLAY_RAM.off+2))[0])&0xFFFF);
	t_int[1]     = (int) sign_16((((HWORD *)(offset+V810_DISPLAY_RAM.off+4))[0])&0xFFFF);
	t_int[2]     = (int) sign_16((((HWORD *)(offset+V810_DISPLAY_RAM.off+6))[0])&0xFFFF);
	t_int[3]     = (int) sign_16((((HWORD *)(offset+V810_DISPLAY_RAM.off+8))[0])&0xFFFF);
	//unknown (overplain character?)
	AFN_MP.u1    = (int) sign_16((((HWORD *)(offset+V810_DISPLAY_RAM.off+10))[0])&0xFFFF);
	AFN_MP.u2    = (int) sign_16((((HWORD *)(offset+V810_DISPLAY_RAM.off+12))[0])&0xFFFF);
	AFN_MP.u3    = (int) sign_16((((HWORD *)(offset+V810_DISPLAY_RAM.off+14))[0])&0xFFFF);

	//convert to float, avoiding divide by zero errors
	AFN_MP.mx_off = (float)(t_int[0]/8.0);
	AFN_MP.my_off = (float)(t_int[1]/8.0);
	AFN_MP.scale  = (float)(t_int[2]/512.0);
	AFN_MP.y_skw  = (float)(t_int[3]/512.0);
}

#ifndef NEW_BGBLIT
////////////////////////////////////////////////////////////////////
//Blit a bgmap to the screen buffer, wraping around if we take an immage 
// past the edge of the source bmp.. Also handle Destinations in the Negative...
VB_INLINE void drawNormalBGMap(int wNum, VB_WORLD WORLD_Buff[], BITMAP *wPlane, 
							  int img_n, int bgmBase, int GPX, int MPX) {
    int src_x_mask;
    int src_y_mask;
    int tWidth;
    int tHeight;
    int startOff;
    int neg_x=0, neg_y=0;
    BITMAP *src_array[4];

	int src_x, src_y, dest_x, dest_y;

	src_x = WORLD_Buff[wNum].MX+MPX;
	src_y = WORLD_Buff[wNum].MY;
	dest_x = 7+WORLD_Buff[wNum].GX+GPX;
	dest_y = 7+WORLD_Buff[wNum].GY;


    //Handle rotations over the end of the screen, wrap to the begining. //mod by this...
    src_x_mask = ((1<<WORLD_Buff[wNum].SCX)<<9)-1;
    src_y_mask = ((1<<WORLD_Buff[wNum].SCY)<<9)-1;

	if (src_x < 0) 
		src_x = (((unsigned int)src_x & src_x_mask) | ~src_x_mask);
	else 
		src_x &= src_x_mask;

    if (src_y < 0) 
		src_y = (((unsigned int)src_y & src_y_mask) | ~src_y_mask);
    else 
		src_y &= src_y_mask;

	//if(!WORLD_Buff[wNum].OVER) {
	//	src_x &=src_x_mask;
	//	src_y &=src_y_mask;
	//} else if((src_x > src_x_mask)||(src_y > src_y_mask)) {
	//	return;
	//}

	//if ((dest_x > 512) || (dest_x < -512)) dest_x &= 0x01FF;
	if ((dest_y > 512) || (dest_y < -512)) dest_y &= 0x01FF;

	//What is the proper warp, some games need to wrap the background and some don't.
	//this breaks VFishing! there must be a second overplane bit?
	if (dest_x > 512)
		if((WORLD_Buff[wNum].GX>385)||(WORLD_Buff[wNum].MX>510)) //420
			dest_x &= 0x01FF;

	if (dest_x < -512) 
		dest_x &= 0x01FF;

	//Funky code to support negative sources!
    if (src_x < 0) {
		dest_x += (neg_x = -src_x);
		src_x = 0;
		tWidth = src_x_mask;
	}
	else tWidth = (src_x_mask-src_x);

	if (src_y < 0) {
		dest_y += (neg_y = -src_y);
		src_y = 0;
		tHeight = src_y_mask;
	}
	else tHeight = (src_y_mask-src_y);

	if (tWidth > WORLD_Buff[wNum].W) tWidth = WORLD_Buff[wNum].W;
	if (tHeight > WORLD_Buff[wNum].H) tHeight = WORLD_Buff[wNum].H;

    startOff = (src_x>>9)+((src_y>>9)<<WORLD_Buff[wNum].SCX)+bgmBase;
    src_array[0] = tDSPCACHE.BGCacheBMP[startOff];
    src_array[1] = tDSPCACHE.BGCacheBMP[startOff];//Next right or wrap to first
    src_array[2] = tDSPCACHE.BGCacheBMP[startOff];//Next down or wrap to top
    src_array[3] = tDSPCACHE.BGCacheBMP[startOff];//next right and down, or wrap to top


    masked_blit(src_array[0], wPlane, src_x&511, src_y&511, dest_x, dest_y, tWidth, tHeight);

//TODO: Add support for overplane
// [character(s) drawn outside of BGMap if overplane is enabled, else wrap BGMap around world]
	if (neg_x)
		masked_blit(src_array[1], wPlane, 512-neg_x, 0, dest_x-neg_x, dest_y, neg_x, tHeight);
	if (neg_y)
		masked_blit(src_array[2], wPlane, 0, 512-neg_y, dest_x, 7, tWidth, neg_y);
    if ((neg_x) && (neg_y))
		masked_blit(src_array[3], wPlane, 512-neg_x, 512-neg_y, dest_x-neg_x, 7, neg_x, neg_y);

    if((src_x+WORLD_Buff[wNum].W) > src_x_mask)
      masked_blit(src_array[1], wPlane, 0, src_y&511, dest_x+tWidth, dest_y, (WORLD_Buff[wNum].W - tWidth), tHeight);
    if((src_y+WORLD_Buff[wNum].H) > src_y_mask)
      masked_blit(src_array[2], wPlane, src_x&511, 0, dest_x, (dest_y+tHeight), tWidth, (WORLD_Buff[wNum].H - tHeight));
    if(((src_x+WORLD_Buff[wNum].W) > src_x_mask) && ((src_y+WORLD_Buff[wNum].H) > src_y_mask))
      masked_blit(src_array[3], wPlane, 0, 0, dest_x+tWidth, (dest_y+tHeight), (WORLD_Buff[wNum].W - tWidth), (WORLD_Buff[wNum].H - tHeight));

//	int offset;
//    if((dest_x+WORLD_Buff[wNum].W) > 384) {
//		offset = (dest_x+WORLD_Buff[wNum].W)-384;
//		masked_blit(src_array[1], wPlane, src_x+(384-offset)&511, src_y&511, 0, dest_y, WORLD_Buff[wNum].W-(384-offset), tHeight);
//	}
}

#else

////////////////////////////////////////////////////////////////////
//Blit a bgmap to the screen buffer, wraping around if we take an immage 
// past the edge of the source bmp.. Also handle Destinations in the Negative...
VB_INLINE void drawNormalBGMap(int wNum, VB_WORLD WORLD_Buff[], BITMAP *wPlane, 
							  int img_n, int bgmBase, int GPX, int MPX) {
    int x,y, tPix;
	int src_x, src_y, dest_x, dest_y;
	int src_x_mask, src_y_mask;
	int bgmXoff, bgmYoff;

	//mask to handle x & y values off the end of the bgmap
	src_x_mask = ((1<<WORLD_Buff[wNum].SCX)<<9)-1; //(1*Num_BGM_X)*512
	src_y_mask = ((1<<WORLD_Buff[wNum].SCY)<<9)-1; //(1*Num_BGM_Y)*512

	//for each column
    for(y=0;y<WORLD_Buff[wNum].H;y++) {

		//calc destinatin y index
		dest_y = y+(WORLD_Buff[wNum].GY+7);
		if ((dest_y > 512) || (dest_y < -512)) 
			dest_y &= 0x01FF;
		//dont draw past end of screen
		if(dest_y > 223+7) 
			continue;

		//for each row
		for(x=0;x<WORLD_Buff[wNum].W;x++) {

			//calc source x index
			src_x = WORLD_Buff[wNum].MX+MPX+x;
			if(src_x<0) continue;
			
			//Wrap BGMap
			if(!WORLD_Buff[wNum].OVER)
				src_x &=src_x_mask;
			else if(src_x > src_x_mask)
				continue;

			//calculate bgmap x index
			bgmXoff = src_x >> 9; //src_x/512
			if(bgmXoff>0) 
				src_x = (src_x-(512*bgmXoff));

			//calc destinatin x index
			dest_x = x+(WORLD_Buff[wNum].GX+7)+GPX;
			//What is the proper warp, some games need to wrap the background and some don't.
			//this breaks VFishing! there must be a second overplane bit?
			if (dest_x > 512)
				if((WORLD_Buff[wNum].GX>385)||(WORLD_Buff[wNum].MX>510)) //420
					dest_x &= 0x01FF;
			if(dest_x < -512)
				dest_x &= 0x01FF;

			//don't draw past edge of screen
			if(dest_x >383+7) 
				continue;

			//calc source y index
			src_y = WORLD_Buff[wNum].MY+y;
			if(src_y<0) continue;
			
			//Wrap BGMap
			if(!WORLD_Buff[wNum].OVER)
				src_y &=src_y_mask;
			else if(src_y > src_y_mask) 
				continue;

			//calculate bgmap y index
			bgmYoff = (src_y>>9)*(WORLD_Buff[wNum].SCX+1); //(src_y/512)*WORLD_Buff[wNum].SCX
			if(bgmYoff>0) 
				src_y = (src_y-(512*bgmYoff));

			//grab pixle
			tPix = getpixel(tDSPCACHE.BGCacheBMP[bgmBase+bgmXoff+bgmYoff],src_x,src_y);
			
			//dont draw if transparnet
			if(!tPix) continue;
			
			//and place on dest bitmap
			//add tAFN_MP.prlx & GPX
			putpixel(wPlane, dest_x, dest_y, tPix);
		}
    }
}
#endif

////////////////////////////////////////////////////////////////////
// Draws a Affin immage to the display buffer
// What a mess!, clean this up and implement anti-aliasing
VB_INLINE void drawAffinBGMap(int wNum, VB_WORLD WORLD_Buff[], BITMAP *wPlane, 
							  int img_n, int bgmBase, int GPX, int MPX) {
    int x,y, tPix;
	int src_x, src_y, dest_x, dest_y;
	AFFINE_MAP tAFN_MP;
	int src_x_mask, src_y_mask;
	int bgmXoff, bgmYoff;

	//mask to handle x & y values off the end of the bgmap
	src_x_mask = ((1<<WORLD_Buff[wNum].SCX)<<9)-1; //(1*Num_BGM_X)*512
	src_y_mask = ((1<<WORLD_Buff[wNum].SCY)<<9)-1; //(1*Num_BGM_Y)*512

	//for each column
    for(y=0;y<WORLD_Buff[wNum].H;y++) {

		//grab the afine entry
		getAffine(y, WORLD_Buff[wNum].PARAM_BASE, tAFN_MP);
		
		//if no scale, do nothing.
		if(!tAFN_MP.scale) 
			continue;

		//fix parallax for right screen
		if (img_n == 2) tAFN_MP.prlx = -tAFN_MP.prlx; 

		//calc destinatin y index
		dest_y = y+(WORLD_Buff[wNum].GY+7);
		if ((dest_y > 512) || (dest_y < -512)) 
			dest_y &= 0x01FF;
		//dont draw past end of screen
		if(dest_y > 223+7) 
			continue;

		//for each row
		for(x=0;x<WORLD_Buff[wNum].W;x++) {

			//calc source x index
			src_x = (int)(tAFN_MP.mx_off+(x*tAFN_MP.scale));
			if(src_x<0) continue;

			//Wrap BGMap
			if(!WORLD_Buff[wNum].OVER)
				src_x &=src_x_mask;
			else if(src_x > src_x_mask)
				continue;

			//calculate bgmap x index
			bgmXoff = src_x >> 9; //src_x/512
			if(bgmXoff>0) 
				src_x = (src_x-(512*bgmXoff));

			//calc destinatin x index
			dest_x = x+(WORLD_Buff[wNum].GX+7);
			//is this nesisary???
			if ((dest_x > 512) || (dest_x < -512)) dest_x &= 0x01FF;
			//don't draw past edge of screen
			if(dest_x >383+7) 
				continue;

			//calc source y index
			src_y = (int)(tAFN_MP.my_off+x*tAFN_MP.y_skw);//+(y*tAFN_MP.scale));
			if(src_y<0) continue;
			
			//Wrap BGMap
			if(!WORLD_Buff[wNum].OVER)
				src_y &=src_y_mask;
			else if(src_y > src_y_mask) 
				continue;

			//calculate bgmap y index
			bgmYoff = (src_y>>9)*(WORLD_Buff[wNum].SCX+1); //(src_y/512)*WORLD_Buff[wNum].SCX
			if(bgmYoff>0) 
				src_y = (src_y-(512*bgmYoff));

			//grab pixle
			tPix = getpixel(tDSPCACHE.BGCacheBMP[bgmBase+bgmXoff+bgmYoff],src_x,src_y);
			
			//dont draw if transparnet
			if(!tPix) continue;
			
			//and place on dest bitmap
			//add tAFN_MP.prlx & GPX
			putpixel(wPlane, dest_x, dest_y, tPix);
		}
    }
}

////////////////////////////////////////////////////////////////////
// Draws a HBias immage to the display buffer
VB_INLINE void drawHBiasBGMap(int wNum, VB_WORLD WORLD_Buff[], BITMAP *wPlane, int img_n, int bgmBase, int GPX, int MPX) {
    int t;
    WORD offset;

    offset = (WORLD_Buff[wNum].PARAM_BASE*2)+BGMAP_OFFSET + V810_DISPLAY_RAM.off;
    if(img_n==2) offset += 2; // Shift by 2 if right screen 
							  //(Read the right offset table, instead of left)

    for(t=0;t<WORLD_Buff[wNum].H;t++) { //Factor in the Shift Index....
        masked_blit(tDSPCACHE.BGCacheBMP[bgmBase], wPlane,
                 WORLD_Buff[wNum].MX+MPX+(((short *)(offset))[(t<<1)]),
				 WORLD_Buff[wNum].MY+t,
                 7+WORLD_Buff[wNum].GX+GPX,
				 7+WORLD_Buff[wNum].GY+t,
                 WORLD_Buff[wNum].W, 1);
    }
}

////////////////////////////////////////////////////////////////////
// Render a Display Screen on a Screen Bitmap, pass in an array
//  of type World Obj.
//bool World2Display(VB_WORLD WORLD_Buff[], BITMAP *sPlane, int DispLR) {

/*VB_INLINE*/ void World2Display(int wNum, VB_WORLD WORLD_Buff[], BITMAP *wPlane, int img_n) {
    int bgm;
    int curscr;
    int ty, tx, ny, nx;
    int GPX = 0;//Global Paralax setings...
    int MPX = 0;

    //Kill it if were trying to display the wrong screen type...
    if(((!img_n)||(img_n==1))&&(!WORLD_Buff[wNum].LON)) return;
    if((img_n==2)&&(!WORLD_Buff[wNum].RON)) return;

    if(img_n==1) {
        GPX = -WORLD_Buff[wNum].GP;//Global Paralax setings...
        MPX = -WORLD_Buff[wNum].MP;
    }else if(img_n==2) {
        GPX = WORLD_Buff[wNum].GP ;//Global Paralax setings...
        MPX = WORLD_Buff[wNum].MP ;
    }

    if(WORLD_Buff[wNum].BGM==3) {  //Obj
        if(tDSPCACHE.ObjDataCacheInvalid==1) { //Cash the Obj Info...
            vGetAllObjects(tDSPCACHE.ObjDataCache); 
            tDSPCACHE.ObjDataCacheInvalid=0;
        }
        //Dont mess around with sub bitmaps, just blast it to the world plane
        Obj2World(tDSPCACHE.ObjDataCache, wPlane,CurObj,img_n);
        CurObj = (CurObj-1)&3; //(CurObj-1)%4;
    } else {
        //Grab the BGMaps, we can have several so grab them all...
        bgm = WORLD_Buff[wNum].BGMAP_BASE;
        nx = (1<<WORLD_Buff[wNum].SCX);
        ny = (1<<WORLD_Buff[wNum].SCY);
        for(ty = 0; ty<ny; ty++) { // 1,2,4,8 bgmaps in the y dir
            for(tx = 0; tx<nx; tx++) { //1,2,4,8 bgmaps in the x dir
                curscr = tx+(ty*nx);
                if(tDSPCACHE.BGCacheInvalid[bgm+curscr]==1) {
                    BGMap2World(bgm+curscr, tDSPCACHE.BGCacheBMP[bgm+curscr]);
                    tDSPCACHE.BGCacheInvalid[bgm+curscr]=0;
                }
            }
        }

        if(WORLD_Buff[wNum].BGM==2) {  //Affin BGMap
            drawAffinBGMap( wNum, WORLD_Buff, wPlane, img_n, bgm, GPX, MPX);
        } else if(WORLD_Buff[wNum].BGM==1) {  //H-Biased BGMap
            drawHBiasBGMap( wNum, WORLD_Buff, wPlane, img_n, bgm, GPX, MPX);
        } else {  //Normal BGMap
            drawNormalBGMap( wNum, WORLD_Buff, wPlane, img_n, bgm, GPX, MPX);
        }
    }
}

void vbClose() {
	exit_flag = 1;
}

////////////////////////////////////////////////////////////////////
//Initialize the display, and get the video mode (from wherever)
bool V810_DSP_Init() {
    int i;
    //RGB temp;
    int done = 0;

	//call our platform dependant init code.
	if(!init_graphics()) {
		V810_DSP_Quit();
		return false;
	}

	set_window_title(VB_VER_STR_1);
	set_window_close_hook(vbClose);

    //Clear our pallet, to a default collor...
    for(i=0;i<256;i++) {
        pallete[i].r = 0; 
        pallete[i].g = 0;
        pallete[i].b = 0;
    }
    //Add the display Color (Text Color)
    pallete[255].r = 63; 
    pallete[255].g = 63;
    pallete[255].b = 63;


    // fill our pallete with a gradually altering sequence of colors 
    V810_SetPal(21,42,63);

    for(i=0;i<14;i++) {
        tDSPCACHE.BGCacheBMP[i] = create_bitmap(512,512); //Creat our temp Bitmap...
    }
    world_bmp = create_bitmap(512+8,512+8); //Make them a bit bigger for the Obj's
    world_bmp2 = create_bitmap(512+8,512+8);
    dsp_bmp = create_bitmap(384*2,224*2);
    for(i=0;i<4;i++) {
        tDSPCACHE.ObjCacheBMP[i] = create_bitmap(512,512); //Creat our temp Bitmap...
    }

    clear_to_color(world_bmp,(tVIPREG.BKCOL&0x3)+1);                    // zero the memory bitmap
    clear_to_color(world_bmp2,(tVIPREG.BKCOL&0x3)+1);                   // zero the memory bitmap
    clear_to_color(dsp_bmp,(tVIPREG.BKCOL&0x3)+1);                      // zero the memory bitmap

    //End Alegro Code

    return true;
}

VB_INLINE void V810_SetPal(int BRTA, int BRTB, int BRTC) {
    int i,j;
    int tPal[] = {0, 0, 21, 42, 63};

	tPal[2] = BRTA;
	tPal[3] = BRTB;
	tPal[4] = BRTC;

	if(tPal[4]>63)
		tPal[4]=63;
	if(tPal[3]>63)
		tPal[3]=63;
	if(tPal[2]>63)
		tPal[2]=63;

    //Normal Pallet
    if (tVBOpt.DSPMODE == dm_RedBlue) {//Red/Blue Pallet...
        for(i=0;i<4;i++) {
            for(j=0;j<4;j++) {
                pallete[i+(j*4)+8].r = tPal[i+1];//tpal goes from 0-4, with 0 and 1 being black (What a Cluge)
                if(tVBOpt.PALMODE == pal_RG) { //Red_Green Pallet
                    pallete[i+(j*4)+8].g = tPal[j+1];
                    pallete[i+(j*4)+8].b = 0; //tPal[j+1];
                } else if(tVBOpt.PALMODE == pal_RBG) { //Red_BlueGreen Pallet
                    pallete[i+(j*4)+8].g = tPal[j+1];
                    pallete[i+(j*4)+8].b = tPal[j+1];
                } else { //Red_Blue Pallet
                    pallete[i+(j*4)+8].g = 0; //tPal[j+1];
                    pallete[i+(j*4)+8].b = tPal[j+1];
                }
            }
        }
    } else { // standard palette
        if(tVBOpt.PALMODE == pal_RED) { //Red Pallet
            for(i=0;i<5;i++) {
                pallete[i].r = tPal[i];
                pallete[i].g = 0;
                pallete[i].b = 0;
            }
        } else { //Standard Pallet
            for(i=0;i<5;i++) {
                pallete[i].r = tPal[i];
                pallete[i].g = tPal[i];
                pallete[i].b = tPal[i];
            }
        }
    }// end Standard palette
    set_pallete(pallete);
}


void V810_DSP_Quit() {
    int i=0;
    for(i=0;i<14;i++) {
        destroy_bitmap(tDSPCACHE.BGCacheBMP[i]);
    }
    destroy_bitmap(world_bmp);
    destroy_bitmap(world_bmp2);
    destroy_bitmap(dsp_bmp);
    for(i=0;i<4;i++) {
        destroy_bitmap(tDSPCACHE.ObjCacheBMP[i]);
    }

	close_graphics();
} 

//Collect all the display init code together...
void V810_DSP() {
    if(!V810_DSP_Init()) return;

    if(!tVBOpt.DEBUG) {
        V810_Dsp_Go();
    } else {
        V810_Dsp_Debug();
    }    

    //Uninstall Alegro!
    V810_DSP_Quit();
}

#define FPS_SLICE 2

//Run the CPU and display (Start the real emu...
void V810_Dsp_Go() {
    int qwe, err=0;
    static int Left = 0;
    int skip = 0;
	int frm_cnt = 0;

	clock_t o_time=0, n_time=0;
	int t_interval = CLOCKS_PER_SEC/(25/FPS_SLICE);
    exit_flag=0;

    clearCache();
    while(1) {
		if (!err) {
			for(qwe=0;qwe<=tVBOpt.FRMSKIP;qwe++) {
				//Trace
				err = v810_trc();
				frm_cnt++;

				// Display a frame, only after the right number of 'skips'
				if((tVIPREG.FRMCYC & 0x00FF) < skip) {
					skip = 0;

					//remove me, get curent frame from VIP flags, 
					//  disabled for now, breakes Space Invaders
					//if(Left==0)
					//	Left = 1;
					//else 
					//	Left = 0;
				}

				// Increment skip
				skip+=1;
			}
			// Display
			if (tVIPREG.DPCTRL & 0x0002) {
				V810_Dsp_Frame(Left); //Temporary...
			}
			else clear_to_color(screen,0);
		}

		if (key[KEY_ESC]) {
			while (key[KEY_ESC]); //Silly hack, so you can hold the esc key down...
			exit_flag=1;
			clear_keybuf(); // Make sure were not killing the returning prog!
		}
		if (exit_flag) {
			clearCache();
			clear_to_color(screen,0); //
			break; //Enough already!
		}

		if(frm_cnt>FPS_SLICE) {
			frm_cnt = 0;
			while(((n_time = clock())-o_time)<t_interval) {
				yield_timeslice();
			}
			//printf("fps %d\n",25*(clock()-o_time)/CLOCKS_PER_SEC);
			o_time = n_time;
		}
	}
}

//Display one frame of graphics...
void V810_Dsp_Frame(int dNum) {
    BITMAP *tmp_bmp = NULL;
    VB_WORLD WORLD_Buff[32];
    int i, j;
    int T_X, T_Y;
    char buffer [MAX_PATH];
	char tpath[MAX_PATH];
    PALETTE pal;
    int tObj=0;
	FILE * fptr;

    T_X = tVBOpt.SCR_X;
    T_Y = tVBOpt.SCR_Y;
    if (T_X > 384) T_X = 384;
    if (T_Y > 224) T_Y = 224;
    isDsp=1; //Secret flag...
    CurObj=3;

    //Normalize the Pallete, Is this to slow??? (tVIPREG.BRTA*64)/MaxBrt
    if(tDSPCACHE.BrtPALMod>0) { //If pallet changed
        // If we want a fixed pallet (no brightness adjustment...)
        //V810_SetPal(tVIPREG.BRTA, tVIPREG.BRTB, tVIPREG.BRTA+tVIPREG.BRTB+tVIPREG.BRTC);
		
		//from red_dragon, does this work?
        V810_SetPal((tVIPREG.BRTA&0xFF)/2, (tVIPREG.BRTB&0xFF)/2, 
			((tVIPREG.BRTA&0xFF)+(tVIPREG.BRTB&0xFF)+(tVIPREG.BRTC&0xFF))/2);

        tDSPCACHE.BrtPALMod=0;
    }

    if(tVBOpt.DSPMODE == dm_NORMAL) {  //Normal
        clear_to_color(world_bmp,(tVIPREG.BKCOL&0x3)+1); // zero the memory bitmap

        for(i = 31; i>=0; i--) {
            getWorld(i,WORLD_Buff);
            if(WORLD_Buff[i].END) break; //hear? or farther down...
            World2Display(i, WORLD_Buff, world_bmp,0);
        }

        DSP2World(dNum,world_bmp);

        tmp_bmp = create_sub_bitmap(world_bmp, 7, 7, 384, 224);
        blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y);
    } else { // 3D Mode...
        clear_to_color(world_bmp,(tVIPREG.BKCOL&0x3)+1);                      // zero the memory bitmap
        clear_to_color(world_bmp2,(tVIPREG.BKCOL&0x3)+1);                      // zero the memory bitmap

        for(i = 31; i>=0; i--) {
            getWorld(i,WORLD_Buff);
            if(WORLD_Buff[i].END) break; //hear? or farther down...
            tObj = CurObj; // Save Curent Obj
            World2Display(i, WORLD_Buff, world_bmp,1+tVBOpt.DSPSWAP);
            CurObj = tObj; //Reset it..
            World2Display(i, WORLD_Buff, world_bmp2,2-tVBOpt.DSPSWAP);
        }

        DSP2World((dNum&1),world_bmp);
        DSP2World((dNum&1)+2,world_bmp2);

        if(tVBOpt.DSPMODE == dm_INTERLACED) {  //Interlaced
            for(i=0;i<=224;i++) {
                blit(world_bmp, dsp_bmp, 7, i+7, 0, (i*2), 384, 1);
                blit(world_bmp2, dsp_bmp, 7, i+7, 0, (i*2)+1, 384, 1);
            }
            tmp_bmp = create_sub_bitmap(dsp_bmp, 0, 0, 384, 224*2);
            blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y*2);
        } else if(tVBOpt.DSPMODE == dm_OVRUNDR) { // Over/Under
            blit(world_bmp, dsp_bmp, 7, 7, 0, 0, 384, 224);
            blit(world_bmp2, dsp_bmp, 7, 7, 0, 224, 384, 224);
            tmp_bmp = create_sub_bitmap(dsp_bmp, 0, 0, 384, 224*2);
            blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y*2);
        } else if(tVBOpt.DSPMODE == dm_RedBlue) {
            for(i=0;i<225;i++){
                for(j=0;j<385;j++) {
                    if(world_bmp->line[i+7][j+7] >0) world_bmp->line[i+7][j+7] -= 1;   //Normalize the display
                    if(world_bmp2->line[i+7][j+7] >0) world_bmp2->line[i+7][j+7] -= 1;
                    dsp_bmp->line[i][j] =  (world_bmp->line[i+7][j+7] + (world_bmp2->line[i+7][j+7]*4))+8;
                }
            }
            tmp_bmp = create_sub_bitmap(dsp_bmp, 0, 0, 384, 224);
            blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y);
        } else if(tVBOpt.DSPMODE == dm_SIDESIDE) { // Side-by-Side
            blit(world_bmp, dsp_bmp, 7, 7, 0, 0, 384, 224);
            blit(world_bmp2, dsp_bmp, 7, 7, 384, 0, 384, 224);
            tmp_bmp = create_sub_bitmap(dsp_bmp, 0, 0, 384*2, 224);
            blit(tmp_bmp, screen, 0, 0, 0, 0, T_X*2, T_Y);
        } else if(tVBOpt.DSPMODE == dm_CYBERSCOPE) { // CyberScope (Fix Me)
            blit(world_bmp, dsp_bmp, 7, 7, 0, 0, 384, 224);
            blit(world_bmp2, dsp_bmp, 7, 7, 0, 224, 384, 224);
            tmp_bmp = create_sub_bitmap(dsp_bmp, 0, 0, 384, 224*2);
            blit(tmp_bmp, screen, 0, 0, 0, 0, T_X, T_Y*2);
        }      
    }

    if(key[VBK_DATA[VBK_PRN]])  {
        get_palette(pal);
		strcpy(tpath,tVBOpt.ROM_NAME);
        sprintf(buffer, "dsp%d.bmp",pCnt);
		replace_filename(tpath, tpath,  buffer, MAX_PATH);


		while(fptr = fopen(tpath,"r")) {
			fclose(fptr);
			pCnt++;
	        sprintf(buffer, "dsp%d.bmp",pCnt); 
			replace_filename(tpath, tpath,  buffer, MAX_PATH);
		}

        save_bmp(tpath,tmp_bmp,pal);
        pCnt +=1;
        while(key[KEY_P]); //Wait till they release the key!
    }

    destroy_bitmap(tmp_bmp);
    isDsp=0; //Secret flag...
}

void clearCache() {
      int i;
	tDSPCACHE.BgmPALMod=1;			//World Pallet Changed
	tDSPCACHE.ObjPALMod=1;			//Obj Pallet Changed
	tDSPCACHE.BrtPALMod=1;			//Britness for Pallet Changed
	tDSPCACHE.ObjDataCacheInvalid=1;	//Object Cache Is invalid
	tDSPCACHE.ObjCacheInvalid=1;		//Object Cache Is invalid
	for(i=0;i<14;i++) tDSPCACHE.BGCacheInvalid[i]=1;//Object Cache Is invalid
}

