/*********************************
* cp_io.h
*
* Cross Platform I/O wrapper for keyboard/joystick/mouse,
* Sound, and video interfaces
*
**********************************/

#include <allegro.h>

#ifndef WORD
#define WORD  unsigned long    //Full 32bit
#define BYTE  unsigned char    //8bit
#endif

#ifndef HWORD
#define HWORD unsigned short   //16bit
#endif

#ifndef INT64
#define INT64 long long int //64 bit int
#define INT64U long long unsigned int //64 bit Unsigned
#endif

#define VB_INLINE inline

//64 bit constants are not cross platform compatible
#define sign_32(num) (((num) & 0x80000000) ? (INT64)((num)|0xFFFFFFFF00000000LL) : (num))

int init_graphics();
int close_graphics();
	
////////////////////////////////////////////////////////////////////
// Keybd Fn's     had to put it somewhere!

#define VBK_FSD 16
#define VBK_FSU 17
#define VBK_SWP 18
#define VBK_PRN 19

#define VBK_vBATT 0
//		VBK_vCID  1
#define VBK_vA    2
#define VBK_vB    3
#define VBK_vR    4
#define VBK_vL    5
#define VBK_vRR   6
#define VBK_vRU   7
#define VBK_vLR   8
#define VBK_vLL   9
#define VBK_vLD   10
#define VBK_vLU   11
#define VBK_vSTR  12
#define VBK_VSEL  13
#define VBK_RL    14
#define VBK_RD    15

//keyboard map
extern int VBK_DATA[20];

void kbd_init(int map);

//Read the Controller
HWORD V810_RControll(void);
