////////////////////////////////////////////////////////////////
// Defines for the VB Core
#ifndef V810_VBT_H_
#define V810_VBT_H_

//Memory Structure for the VIP Reg 
//packed so we can acess it as an array of HWORDS
struct V810_VIPREGDAT {
        VB_HWORD INTPND;
        VB_HWORD INTENB;
		VB_HWORD PAD_1[13];//padding for array access
        VB_HWORD INTCLR;
        VB_HWORD DPSTTS;
        VB_HWORD DPCTRL;
        VB_HWORD BRTA;
        VB_HWORD BRTB;
        VB_HWORD BRTC;
        VB_HWORD REST;
		VB_HWORD PAD_2;	//padding for array access
        VB_HWORD FRMCYC;
        VB_HWORD CTA;
		VB_HWORD PAD_3[7];	//padding for array access
        VB_HWORD XPSTTS;
        VB_HWORD XPCTRL;
        VB_HWORD VER;
		VB_HWORD PAD_4;	//padding for array access
        VB_HWORD SPT[4];
		VB_HWORD PAD_5[8];	//padding for array access
        VB_HWORD GPLT[4];
        VB_HWORD JPLT[4];
        VB_HWORD BKCOL;
        VB_HWORD tFrame;	//not publicly visible
};

struct V810_HREGDAT {
        VB_BYTE SCR;       //Serial Controll Reg,  0x02000028
        VB_BYTE WCR;       //Wait Controll Reg,    0x02000024
        VB_BYTE TCR;       //Timer Controll Reg,   0x02000020
        VB_BYTE THB;       //Timer Higher Byte,    0x0200001C
        VB_BYTE TLB;       //Timer Lower Byte,     0x02000018
        VB_HWORD tTHW;		//Timer TempHWord,      not publicly visible
        VB_WORD tTRC;      //Timer TempResolutionCount, not publicly visible
        VB_HWORD tCount;   //Timer Counter register, not publicly visible
        VB_BYTE tReset;    //Timer Reset register, not publicly visible
        VB_BYTE SHB;       //Serial Higher Byte,   0x02000014  //Read Only
        VB_BYTE SLB;       //Serial Lower Byte,    0x02000010  //Read Only
        VB_BYTE CDRR;      //Com Recv Data Reg,    0x0200000C  //Read Only
        VB_BYTE CDTR;      //Com Trans Data Reg,   0x02000008
        VB_BYTE CCSR;      //Com Cnt Stat Reg,     0x02000004
        VB_BYTE CCR;       //Com Controll Reg,     0x02000000
};

//Export some data structs...

//defined in v810_cpu.h
struct V810_MEMORYFETCH;
struct V810_REGFETCH;

extern V810_MEMORYFETCH V810_ROM1; // US Games
extern V810_MEMORYFETCH V810_DISPLAY_RAM;
extern V810_MEMORYFETCH V810_SOUND_RAM;
extern V810_MEMORYFETCH V810_VB_RAM; 
extern V810_MEMORYFETCH V810_GAME_RAM; 
extern V810_VIPREGDAT   tVIPREG;
extern V810_HREGDAT     tHReg;
extern V810_REGFETCH    V810_VIPCREG; 


// Memory read functions
VB_BYTE  mem_rbyte(VB_WORD addr);
VB_HWORD mem_rhword(VB_WORD addr);
VB_WORD  mem_rword(VB_WORD addr);

//Memory Write Func
void mem_wbyte(VB_WORD addr, VB_BYTE data);
void mem_whword(VB_WORD addr, VB_HWORD data);
void mem_wword(VB_WORD addr, VB_WORD data);

// Port read functions
VB_BYTE  port_rbyte(VB_WORD addr);
VB_HWORD port_rhword(VB_WORD addr);
VB_WORD  port_rword(VB_WORD addr);

//Port Write Func
void port_wbyte(VB_WORD addr, VB_BYTE data);
void port_whword(VB_WORD addr, VB_HWORD data);
void port_wword(VB_WORD addr, VB_WORD data);

// Register I/O Func...
VB_BYTE vipcreg_rbyte(VB_WORD addr);
void vipcreg_wbyte(VB_WORD addr, VB_BYTE data);
VB_HWORD vipcreg_rhword(VB_WORD addr);
void vipcreg_whword(VB_WORD addr, VB_HWORD data);
VB_WORD vipcreg_rword(VB_WORD addr);
void vipcreg_wword(VB_WORD addr, VB_WORD data);

// Opens up a VB rom (pased in) and initializes the rom
// space, some day it will initialize ram as well
int v810_init(char * rom_name);
int v810_shutdown();

void save_sram(void);

#endif
