#ifndef VB_SET_H_
#define VB_SET_H_

#define VB_VER_STR_1 "Reality Boy emu v0.84 (12/09/2008),  By the VB-98 Team"
#define VB_VER_STR_2 "Copyright (C) 1997-2008 David Tucker\n  all rights reserved"

#define dm_NORMAL		0
#define dm_AFFINE		1 //Red/Blue glasses
#define dm_INTERLACED	2
#define dm_OVRUNDR		3
#define dm_SIDESIDE		4
#define dm_CYBERSCOPE	5

#define pal_NORMAL	0
#define pal_RED		1
#define pal_RB		2
#define pal_RG		3
#define pal_RC		4
#define pal_YB		5
#define pal_MG		6
#define pal_BG		7

//Global Options list
struct VB_OPT {
        int     FRMSKIP;  //Frame Skip of cource
        int     SCLSCR;   //Screen scaling (1x-6x)
		int		HSTRETCH; //Double the width of the display
        int     DSPMODE;  //Normal, 3D, etc
        int     DSPSWAP;  //Swap 3D Efect, 0 normal, 1 swap
        int     PALMODE;  //Select A Palette Type:0-normal, 1-red,etc...
        int     DEBUG;    //Releas vs Debug
        int     STDOUT;   //File vs Screen (debug)
        float   BFACTOR;  //User adjustible brightness
        float   R_BAL;	  //Balance brightness of left/right screen
        float   G_BAL;	  
        float   B_BAL;	  
        int     SCR_X;    //Physical Display Dimentions
        int     SCR_Y;
		int     VB_X;     //virtual display dimentions
		int     VB_Y;
        int     LTIMMER;  //Force a 1ms timmer.
        int     VFHACK;	  //force a display interupt.
        int     DISASM;   //Interactive dissasembly of all executed instructions...
        int     FULLSCR;  //0-frame, 1-320x200, 2-640x480
        char   *ROM_NAME; //Path\Name of game to open
        char   *PROG_NAME;//Path\Name of program
		int     KBD_MAP;  //keyboard mapping
		int     NO_THRTL; //turn off speed throttling
		int     STATUS;   //turn on status line (fps, etc)
		int     PPORT;    //turns on paralel port controller
		int     JOY_MAP;  //joystick mapping
		int     NOSOUND;  //disable sound
		int     NETWORK;  //enable network
		char   *IP_ADDR;  //IP Address to connect to, or "host" to host game
		int		MORE_RAM; //increase avalible ram
};

int setOptions(int argc, char *argv[]);

void dump_settings();

extern VB_OPT         tVBOpt;

#endif

