#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "vb_io.h"
#include "vb_set.h"

#define CL_DISP			"-display"
#define CL_DISP_FRAME	  "frame"

#define CL_DSPMODE		"-dspmode"
#define CL_DSPMODE_NORM	  "normal"
#define CL_DSPMODE_AFFINE "affine"
#define CL_DSPMODE_INT	  "interlace"
#define CL_DSPMODE_OV	  "over_under"
#define CL_DSPMODE_SS	  "side"
#define CL_DSPMODE_CSCOPE "cscope"

#define CL_FRMSKP		"-frmskp" 

#define CL_PALETTE		"-palette"
#define CL_PALETTE_NORM	  "normal"	//Gray
#define CL_PALETTE_RED	  "red"		//Red
#define CL_PALETTE_RB	  "rb"		//Red/Blue
#define CL_PALETTE_RG	  "rg"		//Red/Green
#define CL_PALETTE_RC	  "rc"		//Red/Cyan
#define CL_PALETTE_YB	  "yb"		//Yellow/Blue
#define CL_PALETTE_MG	  "mg"		//Magenta/Green
#define CL_PALETTE_BG	  "bg"		//Blue/Green

#define CL_BRTNES		"-brite"
#define CL_BALANCE		"-balance"
#define CL_FLIP			"-flip"
#define CL_LTIMMER		"-ltimmer"
#define CL_VFHACK		"-vfhack"

#define CL_DEBUG		"-debug"
#define CL_STDOUT		"-stdout"
#define CL_DISASM		"-disasm"

#define CL_ALTKBD		"-altkbd" 
#define CL_NOTHRTL		"-nothrtl" 
#define CL_STATUS		"-status" 
#define CL_PPORT		"-pport"
#define CL_JOY			"-joy"

#define CL_NOSOUND		"-nosound"

#define CL_NETWORK		"-network"

#define CL_SCLSCR		"-sclscr"
#define CL_HSTRETCH		"-hstretch"

#define CL_MORE_RAM		"-more_ram"

#define CL_HELP1		"-?"
#define CL_HELP2		"-help"

VB_OPT					tVBOpt;

int print_usage() {
      vb_printf(" Usage: reality_boy <rom_name.vb> [-options]\n");
      vb_printf(" Options: \n");
      vb_printf("  -display (frame, WxH) \n");
      vb_printf("  -dspmode (normal, affine, interlace, over_under, side, cscope)\n");
      vb_printf("  -frmskp (0-9)\n");
      vb_printf("  -palette (normal, red, rb, rg, rc, yb, mg, bg)\n");
      vb_printf("  -brite (0-127)\n");
      vb_printf("  -balance [r g b] (0.1-3.0)\n");
      vb_printf("  -flip\n");
      vb_printf("  -ltimmer\n");
      vb_printf("  -vfhack\n");
      vb_printf("  -altkbd\n");
	  vb_printf("  -nothrtl\n");
	  vb_printf("  -status\n");
	  vb_printf("  -pport (0-2)\n");
	  vb_printf("  -joy\n");
	  vb_printf("  -nosound\n");
	  vb_printf("  -network (<IP_ADDR>|host)\n");
	  vb_printf("  -sclscr (0-4)\n");
	  vb_printf("  -hstretch\n");
	  vb_printf("  -more_ram\n");
	  vb_printf("  -help\n");
	  vb_printf("  -?\n");

#ifdef VB_DEBUGGER
      vb_printf("  -debug\n");
      vb_printf("    -stdout\n");
      vb_printf("    -disasm\n");
#endif
      return 0; //fail, quit program
}

int setOptions(int argc, char *argv[]) {
   int tmp=-1;
   int done = 0;
   int vIndex = 2;
   char *pstr;
   
   //Set up the Defaults
   tVBOpt.FRMSKIP  = 0;
   tVBOpt.SCLSCR   = 0;
   tVBOpt.HSTRETCH = 1;
   tVBOpt.DSPMODE  = dm_NORMAL;
   tVBOpt.DSPSWAP  = 0;
   tVBOpt.PALMODE  = pal_NORMAL;
   tVBOpt.DEBUG    = 0;
   tVBOpt.STDOUT   = 0;
   tVBOpt.BFACTOR  = 1.0;
   tVBOpt.R_BAL    = 1.0;
   tVBOpt.G_BAL    = 1.0;
   tVBOpt.B_BAL    = 1.0;
   tVBOpt.SCR_X    = 640;
   tVBOpt.SCR_Y    = 480;
   tVBOpt.VB_X     = 384;
   tVBOpt.VB_Y     = 224;
   tVBOpt.FULLSCR  = 0;
   tVBOpt.LTIMMER  = 0;
   tVBOpt.VFHACK   = 0;
   tVBOpt.DISASM   = 0;
   tVBOpt.KBD_MAP  = 0;
   tVBOpt.NO_THRTL = 0;
   tVBOpt.STATUS   = 0;
   tVBOpt.JOY_MAP  = 0;
   tVBOpt.NOSOUND  = 0;
   tVBOpt.NETWORK  = 0;
   tVBOpt.PPORT    = 0;
   tVBOpt.MORE_RAM = 0;

   if ((argc < 2)||(strcmp(argv[1], CL_HELP1) == 0)||(strcmp(argv[1], CL_HELP2) == 0)) 
	   return print_usage();

   tVBOpt.PROG_NAME = argv[0];
   tVBOpt.ROM_NAME  = argv[1];

   //Break if we have no optional params...
   //***FixMe, insert tolower() so we are not case sensitive
   if(argc <= 2) done = 1;

   while(!done) {

      if (strcmp(argv[vIndex], CL_DISP) == 0) {
         if (strcmp(argv[vIndex+1], CL_DISP_FRAME) == 0) {
            tVBOpt.FULLSCR = 0;
			//place holder, desktop resolution is set in init_graphics()
            tVBOpt.SCR_X   = 640;      
            tVBOpt.SCR_Y   = 480;
         } else {
            tVBOpt.FULLSCR = 1;
			pstr = argv[vIndex+1];
		    tVBOpt.SCR_X   = strtol(pstr, &pstr, 10);
			pstr++;
		    tVBOpt.SCR_Y   = strtol(pstr, &pstr, 10);
         }
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_DSPMODE) == 0){
         if (strcmp(argv[vIndex+1], CL_DSPMODE_NORM) == 0) {
            tVBOpt.DSPMODE = dm_NORMAL;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_AFFINE) == 0) {
            tVBOpt.DSPMODE = dm_AFFINE;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_INT) == 0) {
            tVBOpt.DSPMODE = dm_INTERLACED;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_OV) == 0) {
            tVBOpt.DSPMODE = dm_OVRUNDR;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_SS) == 0) {
            tVBOpt.DSPMODE = dm_SIDESIDE;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_CSCOPE) == 0) {
            tVBOpt.DSPMODE = dm_CYBERSCOPE;
         }
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_PALETTE) == 0){
         if (strcmp(argv[vIndex+1], CL_PALETTE_NORM) == 0) {
            tVBOpt.PALMODE = pal_NORMAL;
         } else if (strcmp(argv[vIndex+1], CL_PALETTE_RED) == 0) {
            tVBOpt.PALMODE = pal_RED;
         } else if (strcmp(argv[vIndex+1], CL_PALETTE_RB) == 0) {
            tVBOpt.PALMODE = pal_RB;
         } else if (strcmp(argv[vIndex+1], CL_PALETTE_RG) == 0) {
            tVBOpt.PALMODE = pal_RG;
         } else if (strcmp(argv[vIndex+1], CL_PALETTE_RC) == 0) {
            tVBOpt.PALMODE = pal_RC;
         } else if (strcmp(argv[vIndex+1], CL_PALETTE_YB) == 0) {
            tVBOpt.PALMODE = pal_YB;
         } else if (strcmp(argv[vIndex+1], CL_PALETTE_MG) == 0) {
            tVBOpt.PALMODE = pal_MG;
         } else if (strcmp(argv[vIndex+1], CL_PALETTE_BG) == 0) {
            tVBOpt.PALMODE = pal_BG;
         }
         vIndex+=2;

      }else if (strcmp(argv[vIndex], CL_FRMSKP) == 0){
         tmp=atoi(argv[vIndex+1]);
	     if((tmp>=0)&&(tmp<=9)) 
			 tVBOpt.FRMSKIP = tmp;
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_SCLSCR) == 0){
         tmp=atoi(argv[vIndex+1]);
         if((tmp>=0)&&(tmp<=6)) 
			 tVBOpt.SCLSCR = tmp;
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_BRTNES) == 0){
         tVBOpt.BFACTOR=(float)atof(argv[vIndex+1]);
	     if((tVBOpt.BFACTOR<=0.1)||(tVBOpt.BFACTOR>3.0)) 
			 tVBOpt.BFACTOR = 1.0;
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_BALANCE) == 0){
         tVBOpt.R_BAL = (float)atof(argv[vIndex+1]);
         tVBOpt.G_BAL = (float)atof(argv[vIndex+2]);
         tVBOpt.B_BAL = (float)atof(argv[vIndex+3]);
	     if((tVBOpt.R_BAL<=0.1)||(tVBOpt.R_BAL>3.0)) tVBOpt.R_BAL = 1.0;
	     if((tVBOpt.G_BAL<=0.1)||(tVBOpt.G_BAL>3.0)) tVBOpt.G_BAL = 1.0;
	     if((tVBOpt.B_BAL<=0.1)||(tVBOpt.B_BAL>3.0)) tVBOpt.B_BAL = 1.0;
         vIndex+=4;

      }else if (strcmp(argv[vIndex], CL_HSTRETCH) == 0){
         tVBOpt.HSTRETCH = 2;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_MORE_RAM) == 0){
         tVBOpt.MORE_RAM = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_FLIP) == 0){
         tVBOpt.DSPSWAP = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_LTIMMER) == 0){ 
         tVBOpt.LTIMMER = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_VFHACK) == 0){ 
         tVBOpt.VFHACK = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_ALTKBD) == 0){
         tVBOpt.KBD_MAP = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_NOTHRTL) == 0){
         tVBOpt.NO_THRTL = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_STATUS) == 0){
         tVBOpt.STATUS = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_PPORT) == 0){
         tmp=atoi(argv[vIndex+1]);
         if((tmp>=0)&&(tmp<=4)) 
			 tVBOpt.PPORT = tmp;
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_JOY) == 0){
         tVBOpt.JOY_MAP = 1;
         vIndex++;
	  }else if (strcmp(argv[vIndex], CL_NOSOUND) == 0){
         tVBOpt.NOSOUND = 1;
         vIndex++;
	  }else if (strcmp(argv[vIndex], CL_NETWORK) == 0){
         tVBOpt.NETWORK = 1;
         tVBOpt.IP_ADDR = argv[vIndex+1];
         vIndex+=2;
#ifdef VB_DEBUGGER
      }else if (strcmp(argv[vIndex], CL_DISASM) == 0){ 
         tVBOpt.DISASM = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_DEBUG) == 0){
         tVBOpt.DEBUG = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_STDOUT) == 0){
         tVBOpt.STDOUT = 1;
         vIndex++;
#endif
      } else {
	     //Oops we got an invalid argument!
         vb_printf("error: invalid argument: %s\n",argv[vIndex]);
	     return print_usage();
         vIndex++;
      }
      if(vIndex >= argc) done = 1;
   }

	//set virtual screen resolution
	switch(tVBOpt.DSPMODE) {
	case dm_NORMAL:
	case dm_AFFINE:
		tVBOpt.VB_X   = 384;
		tVBOpt.VB_Y   = 224;
		break;
	case dm_INTERLACED:
	case dm_OVRUNDR:
		tVBOpt.VB_X   = 384;
		tVBOpt.VB_Y   = 448;
		break;

	case dm_SIDESIDE:
		tVBOpt.VB_X   = 768;
		tVBOpt.VB_Y   = 224;
		break;

	case dm_CYBERSCOPE:
		tVBOpt.VB_X   = 448;
		tVBOpt.VB_Y   = 384;
		break;
	default:
		break;
	};

   return 1;
}

void dump_settings() {
	vb_log_msg(10,"FRMSKIP: %d\n", tVBOpt.FRMSKIP);
	vb_log_msg(10,"SCLSCR: %d\n", tVBOpt.SCLSCR);
	vb_log_msg(10,"HSTRETCH: %d\n", tVBOpt.HSTRETCH);
	vb_log_msg(10,"DSPMODE: %d\n", tVBOpt.DSPMODE);
	vb_log_msg(10,"DSPSWAP: %d\n", tVBOpt.DSPSWAP);
	vb_log_msg(10,"PALMODE: %d\n", tVBOpt.PALMODE);
	vb_log_msg(10,"DEBUG: %d\n", tVBOpt.DEBUG);
	vb_log_msg(10,"STDOUT: %d\n", tVBOpt.STDOUT);
	vb_log_msg(10,"BFACTOR: %f\n", tVBOpt.BFACTOR);
	vb_log_msg(10,"R_BAL: %f\n", tVBOpt.R_BAL);
	vb_log_msg(10,"G_BAL: %f\n", tVBOpt.G_BAL);
	vb_log_msg(10,"B_BAL: %f\n", tVBOpt.B_BAL);
	vb_log_msg(10,"SCR_X: %d\n", tVBOpt.SCR_X);
	vb_log_msg(10,"SCR_Y: %d\n", tVBOpt.SCR_Y);
	vb_log_msg(10,"VB_X: %d\n", tVBOpt.VB_X);
	vb_log_msg(10,"VB_Y: %d\n", tVBOpt.VB_Y);
	vb_log_msg(10,"LTIMMER: %d\n", tVBOpt.LTIMMER);
	vb_log_msg(10,"VFHACK: %d\n", tVBOpt.VFHACK);
	vb_log_msg(10,"DISASM: %d\n", tVBOpt.DISASM);
	vb_log_msg(10,"FULLSCR: %d\n", tVBOpt.FULLSCR);
	vb_log_msg(10,"ROM_NAME: %s\n", tVBOpt.ROM_NAME);
	vb_log_msg(10,"PROG_NAME: %s\n", tVBOpt.PROG_NAME);
	vb_log_msg(10,"KBD_MAP: %d\n", tVBOpt.KBD_MAP);
	vb_log_msg(10,"NO_THRTL: %d\n", tVBOpt.NO_THRTL);
	vb_log_msg(10,"STATUS: %d\n", tVBOpt.STATUS);
	vb_log_msg(10,"PPORT: %d\n", tVBOpt.PPORT);
	vb_log_msg(10,"JOY_MAP: %d\n", tVBOpt.JOY_MAP);
	vb_log_msg(10,"NOSOUND: %d\n", tVBOpt.NOSOUND);
}
