////////////////////////////////////////////////////////////////////
//Display Deug code, not needed for the ports...

#include <stdlib.h>
#include <ctype.h>

#include "vb_io.h"
#include "v810_cpu.h"
#include "vb_vbt.h"
#include "vb_vbtD.h"
#include "vb_dsp.h"
#include "vb_set.h"
#include "vb_dspD.h" //Debug code

//struct BITMAP;
#define MAX_INPUT_LEN 100

////////////////////////////////////////////////////////////////////
void V810_DSP_DBG() {
    if(!V810_DSP_Init()) return;

    V810_Dsp_Debug();

    V810_DSP_Quit();
}

void V810_DSP_img(BITMAP *bmp) {
    BITMAP *tmp_bmp; // a off screen buffer for writes to the screen
    int T_X, T_Y;

	if(NULL == bmp) return;

    T_X = tVBOpt.SCR_X;
    T_Y = tVBOpt.SCR_Y;
    if (T_X > 512) T_X = 512;
    if (T_Y > 512) T_Y = 512;

    //tmp_bmp = bmp_clip(bmp, 7, 7, T_X+7, T_Y+7);
    tmp_bmp = bmp_clip(bmp, 0, 0, T_X, T_Y);

    bmp_display(tmp_bmp);
    bmp_free(tmp_bmp);
}


void V810_Dsp_Debug() {
    char a;

	//reset palette if not set
    V810_SetPal(21,42,63);

    while(1) {
        clearCache(); //Clear out the cache
        bmp_clear(dsp_bmp,0);                    // zero the memory bitmap
        bmp_printf(dsp_bmp, 10, 10, "Please chose:");
        bmp_printf(dsp_bmp, 10, 20, " (C)har, (O)bj, (B)G Obj, (R)om (W)orld");
        bmp_printf(dsp_bmp, 10, 30, " R(a)m, (P)rint Buff, (D)isplay, 'S' Scale Info");
        bmp_printf(dsp_bmp, 10, 40, " <ESC> exits, 'P' saves a Picture");
        V810_DSP_img(dsp_bmp);


	    a = wait_key();
		a = toupper(a);

        if (a == 'C') V810_DSP_Chr();
        else if (a == 'O') V810_DSP_Obj();
        else if (a == 'B') V810_DSP_BGMap();
        else if (a == 'R') V810_DSP_Rom();
        else if (a == 'A') V810_DSP_Ram();
        else if (a == 'W') V810_DSP_World();
        else if (a == 'P') V810_PRNBUFF();
        else if (a == 'D') {V810_DspD_Go(); V810_SetPal(21,42,63);} //reset palette when we are done
        else if (a == 'S') VB_PRN_AFFIN();
        else if ((a == 'Q')||(a == 27)) break;
    }
}

void V810_DspD_Go() {
    char a;

    clearCache(); //Reset the Cache
    bmp_clear(dsp_bmp,0);                    // zero the memory bitmap
    bmp_printf(dsp_bmp, 10, 10, "Select display mode:");
    bmp_printf(dsp_bmp, 10, 20, " 0) Normal 1) Red/Blue 2)Interlaced");
    bmp_printf(dsp_bmp, 10, 30, " 3) Over/Under 4) Side-by-Side 5) CyberScope");
    V810_DSP_img(dsp_bmp);

    a = wait_key();
	a -=48; //convert to number
    if((a <0)|| (a>5)) tVBOpt.DSPMODE = dm_NORMAL;
    else tVBOpt.DSPMODE = a;

    V810_Dsp_Go();
}

// Need to scroll and generaly handle changes in screen res better!
// Display the rom graphicaly...
void V810_DSP_Rom() {
    unsigned long romStrt = 0x07000000;
    int j;
    VB_HWORD chr[8];
    BITMAP *tSprt;
    int a;
    int y, x, i;
    int done = 0;
    VB_WORD offset = romStrt; // only 14 posible bg's, this is 16 but whos counting?
    int chr_x = 512/8;
    int chr_y = 512/8;
	char inputstr[MAX_INPUT_LEN], *inputend;


    while(!done) {

        bmp_clear(dsp_bmp,0); // zero the memory bitmap
        for(y = 0; y < chr_y; y++) {
            for(x=0; x < chr_x;x++) {
                // Grab a chr from chr ram
                for(j=0; j<8;j++) {
                    chr[j] = mem_rhword(((y*chr_x + x) * 16) + offset+ (j <<1));
                }

                //Now convert the chr to a sprite a put it on the world plane...
                //First grab a sub bitmap off of the world Bitmap
                tSprt = bmp_clip(dsp_bmp, (x<<3), (y<<3), 8, 8); //(i/64)*8)
                //Then copy the chr to the sub bitmap, this should copy it to the world bitmap by default (Very Nice)
                chr2sprite(chr, tSprt);
                bmp_free(tSprt);
            }
        }

        bmp_display(dsp_bmp);

        while(1) {
            a = wait_key();

            //save a Picture of the screen.... (In the current screen resolution)
            if (toupper(a)=='P') {
                bmp_save(dsp_bmp,"rom");
                //Print Help....
            } else if (toupper(a)=='H') {
                bmp_clear(dsp_bmp,0); // zero the memory bitmap
                bmp_printf(dsp_bmp, 5, 10, "Please chose:");
                bmp_printf(dsp_bmp, 5, 20, "save a (P)ic, (H)elp, (Q)uit or <ESC>");
                bmp_printf(dsp_bmp, 5, 30, "(u)p/(d)own 1 line, (U)p/(D)own 1 page");
                bmp_printf(dsp_bmp, 5, 40, "(<)/(>)L/R 1 Block, (+)/(-)move 1 byte");
                bmp_printf(dsp_bmp, 5, 50, "(1)/(2)shrink/expand the colums");
                bmp_display(dsp_bmp);
                                
                a = wait_key();
                break;
            // Move 1 Page (Screen)....
            } else if (a == 'D') {
                offset += chr_x*chr_y*16;
                break;
            } else if (a == 'U') {
                offset -= chr_x*chr_y*16;
                if (offset < romStrt) offset = romStrt;
                break;
                // Move 1 line....
            } else if (a == 'd') {
                offset += chr_x*16;
                break;
            } else if (a == 'u') {
                offset -= chr_x*16;
                if (offset < romStrt) offset = romStrt;
                break;
                // Move 1 picture....
            } else if ((a == '<')||(a == ',')) {
                offset += 16;
                break;
            } else if ((a == '>')||(a == '.')) {
                offset -= 16;
                if (offset < romStrt) offset = romStrt;
                break;
            //Adjust by 1 byte, usfull when the immages arent aligned on evin boundrys...
            } else if ((a == '+')||(a=='=')) {
                offset++;
                break;
            } else if ((a == '-')||(a == '_')) {
                offset--;
                if (offset < romStrt) offset = romStrt;
                break;
            //Shrink\grow the columbs, good to get tiles to align... (So Im wierd....)
            } else if ((a == '1')||(a=='!')) {
                chr_x--;
                if (chr_x < 0) chr_x=0;
                break;
            } else if ((a == '2')||(a == '@')) {
                chr_x++;
                if (chr_x > (512/8)) chr_x = (512/8);
                break;
			} else if ((a == 'a')||(a == 'A')) {
				i=0;
				clear_key();
				read_line(inputstr, MAX_INPUT_LEN);
				offset=strtoul(inputstr,&inputend,16);
				break;

            //Quit of cource (Duh...)
            } else if ((a==27)||(toupper(a)=='Q')) {
                done = 1;
                break;
            }
        }
    }
}

void V810_DSP_Ram() {
    unsigned long ramStrt = 0x00000000;
    VB_HWORD chr;
    int a;
    int y, x, i;
    int done = 0;
    VB_WORD offset = ramStrt;// only 14 posible bg's, this is 16 but whos counting?
    int chr_x = 512;
    int chr_y = 256;
	char inputstr[MAX_INPUT_LEN], *inputend;
    BITMAP *world_bmp = bmp_create(chr_x,chr_y);

    while(!done) {
        bmp_clear(world_bmp,0); // zero the memory bitmap
        for(x=0; x < chr_x; x++) {
            for(y=0; y < chr_y; y+=8) {
                chr = mem_rhword((x*(chr_y/4)+(y/4)) + offset);
                world_bmp->line[y+0][x] = ((chr >>  0) & 3)+1;
                world_bmp->line[y+1][x] = ((chr >>  2) & 3)+1;
                world_bmp->line[y+2][x] = ((chr >>  4) & 3)+1;
                world_bmp->line[y+3][x] = ((chr >>  6) & 3)+1;
                world_bmp->line[y+4][x] = ((chr >>  8) & 3)+1;
                world_bmp->line[y+5][x] = ((chr >> 10) & 3)+1;
                world_bmp->line[y+6][x] = ((chr >> 12) & 3)+1;
                world_bmp->line[y+7][x] = ((chr >> 14) & 3)+1;
            }
        }

        bmp_display(world_bmp);

        while(1) {
            a = wait_key();

            //save a Picture of the screen.... (In the current screen resolution)
            if (toupper(a)=='P') {
                bmp_save(world_bmp,"ram");
                //Print Help....
            } else if (toupper(a)=='H') {
                bmp_clear(world_bmp,0); // zero the memory bitmap
                bmp_printf(world_bmp, 5, 10, "Please chose:");
                bmp_printf(world_bmp, 5, 20, "save a (P)ic, (H)elp, (Q)uit or <ESC>");
                bmp_printf(world_bmp, 5, 30, "(u)p/(d)own 1 line, (U)p/(D)own 1 page");
                bmp_printf(world_bmp, 5, 40, "(<)/(>)L/R 1 Block, (+)/(-)move 1 byte");
                bmp_printf(world_bmp, 5, 50, "(1)/(2)shrink/expand the colums");
                bmp_display(world_bmp);
                                
                a = wait_key();
                break;
            // Move 1 Page (Screen)....
            } else if (a == 'D') {
                offset += (chr_y/4)*chr_x;
                break;
            } else if (a == 'U') {
                offset -= (chr_y/4)*chr_x;
                if (offset < ramStrt) offset = ramStrt;
                break;
                // Move 1 line....
            } else if (a == 'd') {
                offset += (chr_y/4);
                break;
            } else if (a == 'u') {
                offset -= (chr_y/4);
                if (offset < ramStrt) offset = ramStrt;
                break;
                // Move 1 picture....
            } else if ((a == '<')||(a == ',')) {
                offset += 2;
                break;
            } else if ((a == '>')||(a == '.')) {
                offset -= 2;
                if (offset < ramStrt) offset = ramStrt;
                break;
            //Adjust by 1 byte, usfull when the immages arent aligned on evin boundrys...
            } else if ((a == '+')||(a=='=')) {
                offset++;
                break;
            } else if ((a == '-')||(a == '_')) {
                offset--;
                if (offset < ramStrt) offset = ramStrt;
                break;
            //Shrink\grow the columbs, good to get tiles to align... (So Im wierd....)
            } else if ((a == '1')||(a=='!')) {
                chr_x--;
                if (chr_x < 0) chr_x=0;
                break;
            } else if ((a == '2')||(a == '@')) {
                chr_x++;
                if (chr_x > 384) chr_x = 384;
                break;
			} else if ((a == 'a')||(a == 'A')) {
				i=0;
				clear_key();
				read_line(inputstr, MAX_INPUT_LEN);
				offset=strtoul(inputstr,&inputend,16);
				break;
            //Quit of cource (Duh...)
            } else if ((a==27)||(toupper(a)=='Q')) {
                done = 1;
                break;
            }
        }
    }

    bmp_free(world_bmp);
}


// Need to scroll and generaly handle changes in screen res better!
// Display a table of chr's
void V810_DSP_Chr() {
    char a;
    BITMAP *world_bmp = bmp_create(512,512);
    int i;
    //VB_HWORD chr[8];
    BITMAP *tSprt;
    VB_BYTE tPal[4]={1,2,3,4};

    bmp_clear(world_bmp,0); // zero the memory bitmap

    for(i = 0; i < 2048; i++) {
        //First grab a sub bitmap off of the world Bitmap
        tSprt = bmp_clip(world_bmp, ((i&63)<<3), ((i>>6)<<3), 8, 8); //(i/64)*8)
        //Then copy the chr to the sub bitmap, this should copy it to the world bitmap by default (Very Nice)
        fchr2sprite(i, tSprt,0,0,tPal);
        bmp_free(tSprt);
    }

    V810_DSP_img(world_bmp);

    while(1) {
	    a = wait_key();
		a = toupper(a);

        if (a == 'P') {
            bmp_save(world_bmp,"chr");
        }
        if ((a == 27)||(a == 'Q')) break;
    }

    bmp_free(world_bmp);
}

// Display all the Obj files, need to look for SPTx registers...
void V810_DSP_Obj(){
    char a;
    BITMAP *world_bmp = bmp_create(512,512);
    VB_OBJ OBJ_Buff[0x400];
    int p = 0;
    int done = 0;


    for (p = 0; p < 0x400; p++) {
        getObj(p,OBJ_Buff); 
    }
    for(p = 3;p>=0;p--) {
        bmp_clear(world_bmp,0);                      // zero the memory bitmap
        Obj2World(OBJ_Buff, world_bmp,p,0);

        bmp_printf(world_bmp, 2, 2, "%d",p);
		V810_DSP_img(world_bmp);

        while(1) {
          done = 0;
		  a = wait_key();
		  a = toupper(a);

          if (a == 'P') {
            bmp_save(world_bmp,"obj");
          } else if ((a == 27)||(a == 'Q')) {
            done = 1;
            break;
          } else {
			done = 0;
			break;
		  }
        }
        if(done) break;
    }

    bmp_free(world_bmp);
}

// Display all the BG maps
void V810_DSP_BGMap(){
    char a;
    int i;
    BITMAP *world_bmp = bmp_create(512,512);
    int done = 0;
    char buffer[200];
    int p;

    for(i=0;i<14;i++) {
        tDSPCACHE.BGCacheInvalid[i]=1;
    }

    for (p = 0; p < 14; p++) {
        bmp_clear(world_bmp,0);                      // zero the memory bitmap
        BGMap2World(p, world_bmp);

        bmp_printf(world_bmp, 2, 2, "%d",p);
        V810_DSP_img(world_bmp);
        
        while(1) {
            done = 0;
 	        a = wait_key();
		    a = toupper(a);

            if (a == 'P') {
                sprintf(buffer, "bg_map%d_",p); 
                bmp_save(world_bmp,buffer);
            } else if ((a == 27)||(a == 'Q')) {
                done = 1;
                break;
            } else {
                done = 0;
                break;
            }
        }
        if(done) break;
    }

    bmp_free(world_bmp);
}

void V810_DSP_World(){
    VB_WORLD WORLD_Buff[32];
    BITMAP *world_bmp = bmp_create(512,512);
    char a;
    char buffer [200];
    int p;
    int done = 0;

    for(p =31; p>=0; p--) {
        bmp_clear(world_bmp,0);                      // zero the memory bitmap
        getWorld(p,WORLD_Buff);
        World2Display(p, WORLD_Buff, world_bmp,-1);

        bmp_printf(world_bmp, 2, 2, "%d",p);
        V810_DSP_img(world_bmp);
        
        while(1) {
            done = 0;
            a = wait_key();
            a = toupper(a);

            if (a == 'P') {
                sprintf(buffer, "world%d_",p); 
                bmp_save(world_bmp,buffer);
            } else if ((a == 27)||(a == 'Q')) {
                done = 1;
                break;
            } else {
                done = 0;
                break;
            }
        }
        if(done) break;
    }
    bmp_free(world_bmp);
}

void V810_PRNBUFF() {
    int i = 0;
    //VB_OBJ OB[1024];
    VB_WORLD WB[32];
    //VB_BGMAP BG[4096];
 
    //for (i = 0; i < 14; i++) {
    //    getBGmap(i,BG); 
    //    vb_log_msg(10,"\nBGBuff BPLTS %d",BG[0].BPLTS);
    //}

    //for (i = 0; i < 0x400; i++) {
    //    getObj(i,OB); 
    //}
    for(i = 0; i<32; i++) {
        getWorld(i,WB);
    }
    for(i=0; i<32; i++) {
        vb_log_msg(10,"\nWorld Buff %d",i);
        vb_log_msg(10,"\n Lon: %d Ron: %d BGM: %d SCX: %d SCY: %d OVER: %d End: %d BGMBase %d, U %d, %d",WB[i].LON,WB[i].RON,WB[i].BGM,WB[i].SCX,WB[i].SCY,WB[i].OVER,WB[i].END,WB[i].BGMAP_BASE, WB[i].Unknown1, WB[i].Unknown2);
        vb_log_msg(10,"\n GX: %d GP: %d GY: %d",WB[i].GX,WB[i].GP,WB[i].GY);
        vb_log_msg(10,"\n MX: %d MP: %d MY: %d",WB[i].MX,WB[i].MP,WB[i].MY);
        vb_log_msg(10,"\n W: %d H: %d ",WB[i].W,WB[i].H);
        vb_log_msg(10,"\n PARAM_BASE: %d OVERPLANE_CHARACTER: %d ",WB[i].PARAM_BASE,WB[i].OVERP_CHR);
        vb_log_msg(10,"\n U0: %d U1: %d U2: %d U3: %d U4: %d",
			WB[i].Dont_Write[0],WB[i].Dont_Write[1],WB[i].Dont_Write[2],WB[i].Dont_Write[3],WB[i].Dont_Write[4]);

    }

    //for(i=0; i<0x400; i++) {
    //  vb_log_msg(10,"\nObjBuff Buff %d",i);
    //  vb_log_msg(10,"\n JLon: %d JRon: %d JP: %d JX: %d JY:",OB[i].JLON,OB[i].JRON,OB[i].JP,OB[i].JX,OB[i].JY);
    //  vb_log_msg(10,"\n JPLTS: %d JHFLP: %d JVFLP: %d JCA: %d",OB[i].JPLTS,OB[i].JHFLP,OB[i].JVFLP,OB[i].JCA);
    //}

    vb_log_msg(10,"\nBRTA %02x",tVIPREG.BRTA);
    vb_log_msg(10,"\nBRTB %02x",tVIPREG.BRTB);
    vb_log_msg(10,"\nBRTC %02x",tVIPREG.BRTC);

    vb_log_msg(10,"\nGPLT[0] %02x",tVIPREG.GPLT[0]);
    vb_log_msg(10,"\nGPLT[1] %02x",tVIPREG.GPLT[1]);
    vb_log_msg(10,"\nGPLT[2] %02x",tVIPREG.GPLT[2]);
    vb_log_msg(10,"\nGPLT[3] %02x",tVIPREG.GPLT[3]);

    vb_log_msg(10,"\nJPLT[0] %02x",tVIPREG.JPLT[0]);
    vb_log_msg(10,"\nJPLT[1] %02x",tVIPREG.JPLT[1]);
    vb_log_msg(10,"\nJPLT[2] %02x",tVIPREG.JPLT[2]);
    vb_log_msg(10,"\nJPLT[3] %02x",tVIPREG.JPLT[3]);

    vb_log_msg(10,"\nBKCOL %02x",tVIPREG.BKCOL);

    fflush(log_file);
}

void VB_PRN_AFFIN() {
    int i;
    long PBaseOffset = 0;
    long OvPlaneOffset = 0;
    VB_WORLD WB[32];
 
    for(i = 0; i<32; i++) {
        getWorld(i,WB);
    }
    for(i=0; i<32; i++) {
        if(WB[i].BGM==2) {
            vb_log_msg(10,"\n\n//-------------------------------------");
            vb_log_msg(10,"\nWorld Buff %d",i);
            vb_log_msg(10,"\n Lon: %d Ron: %d BGM: %d SCX: %d SCY: %d OVER: %d End: %d BGMBase %d",WB[i].LON,WB[i].RON,WB[i].BGM,WB[i].SCX,WB[i].SCY,WB[i].OVER,WB[i].END,WB[i].BGMAP_BASE);
            vb_log_msg(10,"\n GX: %d GP: %d GY: %d",WB[i].GX,WB[i].GP,WB[i].GY);
            vb_log_msg(10,"\n MX: %d MP: %d MY: %d",WB[i].MX,WB[i].MP,WB[i].MY);
            vb_log_msg(10,"\n W: %d H: %d ",WB[i].W,WB[i].H);
            vb_log_msg(10,"\n PARAM_BASE: %d OVERPLANE_CHARACTER: %d ",WB[i].PARAM_BASE,WB[i].OVERP_CHR);

            PBaseOffset = (WB[i].PARAM_BASE*2)+0x00020000;
            vb_log_msg(10,"\n\n PARAM_Offset: %ld ",PBaseOffset);
            v810_dumpD(PBaseOffset,WB[i].H-1);
        }
    }
    fflush(log_file);
}

void v810_dumpD(long tPC, int num) {
    short t1, t2, t3, t4, t5, t6, t7, t8;
    int i = 0;
    
    for(i = 0; i< num; i++) {
        vb_log_msg(10,"\n%08lx:",tPC);
		t1 = mem_rhword(tPC);
		t2 = mem_rhword(tPC+2);
		t3 = mem_rhword(tPC+4);
		t4 = mem_rhword(tPC+6);
		t5 = mem_rhword(tPC+8);
		t6 = mem_rhword(tPC+10);
		t7 = mem_rhword(tPC+12);
		t8 = mem_rhword(tPC+14);

		vb_log_msg(10,"  %1.3f, %d, %1.3f, %1.3f %1.3f %d %d %d", 
			t1/8.0f,		//pb_y
			t2,				//paralax
			t3/8.0f,		//pd_y
			t4/512.0f,		//pa   
			t5/512.0f,		//pc    
			t6, t7, t8);	//unknown

        tPC +=16;
    }
}

