//#include <stdlib.h>
//#include <stdio.h>
//#include <ctype.h>
#include <time.h>

#include "vb_io.h"
#include "v810_opt.h" //Needed for sign_16()
#include "v810_cpu.h"
#include "vb_vbt.h"
#include "vb_set.h"
#include "vb_dsp.h"
#include "vb_sound.h"

#ifdef VB_DEBUGGER
#include "v810_cpuD.h"
#include "vb_dspD.h" //Debug code
#endif

//struct BITMAP;
////////////////////////////////////////////////////////////////////
// Globals
int isDsp =0;
int CurObj=3;
int MaxBrt = 30;
int exit_flag=0;

float fps = 50;


VB_DSPCACHE tDSPCACHE; //Array of Display Cache info...

BITMAP *world_bmp;
BITMAP *world_bmp2;
BITMAP *dsp_bmp;

//Offset into Chr ram for the given chr#
VB_WORD ChrOff[4] = {0x00006000,0x0000E000,0x00016000,0x0001E000};


////////////////////////////////////////////////////////////////////
// Retreaves a character(Sprite) from the character table, Only used for DisplayRom()
// Now directly acesses the video ram (Scary)
void getChr(VB_HWORD num, VB_HWORD chr[]) {
    //Strip the first 2 bits to decode what chr table to use, use the remaning bits to index into the table...
    VB_WORD offset =ChrOff[(num>>9)&0x03] + (CHR_SIZE * (num & 0x01FF));       
    if((offset < V810_DISPLAY_RAM.lowaddr)||(offset+CHR_SIZE > V810_DISPLAY_RAM.highaddr)) 
    offset = ChrOff[0]; //Set to a known value (Chr0)
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    ((VB_WORD *)chr)[0] = ((VB_WORD *)(offset))[0];
    ((VB_WORD *)chr)[1] = ((VB_WORD *)(offset))[1];
    ((VB_WORD *)chr)[2] = ((VB_WORD *)(offset))[2];
    ((VB_WORD *)chr)[3] = ((VB_WORD *)(offset))[3];
}

// Translates a chr to a sprite, Only used for DisplayRom()
void chr2sprite(VB_HWORD chr[],BITMAP *sprt) {
    int i;
    for(i = 0; i < 8; i++) {// we want words not bytes
        sprt->line[i][0] = ((chr[i] >>  0) & 3)+1;
        sprt->line[i][1] = ((chr[i] >>  2) & 3)+1;
        sprt->line[i][2] = ((chr[i] >>  4) & 3)+1;
        sprt->line[i][3] = ((chr[i] >>  6) & 3)+1;
        sprt->line[i][4] = ((chr[i] >>  8) & 3)+1;
        sprt->line[i][5] = ((chr[i] >> 10) & 3)+1;
        sprt->line[i][6] = ((chr[i] >> 12) & 3)+1;
        sprt->line[i][7] = ((chr[i] >> 14) & 3)+1;
    }
}

//Replaces the two Fn's Above (Faster?)
void fchr2sprite(VB_HWORD num,BITMAP *sprt, bool hflp, bool vflp,VB_BYTE pal[]) {
    int i;

    //Strip the first 2 bits to decode what chr table to use, use the remaning bits to index into the table...
    VB_WORD offset = ChrOff[(num>>9)&0x03] + (CHR_SIZE * (num & 0x01FF)) 
		+ V810_DISPLAY_RAM.off;       

    if (!hflp && !vflp){ 
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[i][0] = pal[((((VB_HWORD *)(offset))[i] >>  0) & 3)]; //replace "<<4) & 0x3f);" with cPal[#]
            sprt->line[i][1] = pal[((((VB_HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[i][2] = pal[((((VB_HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[i][3] = pal[((((VB_HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[i][4] = pal[((((VB_HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[i][5] = pal[((((VB_HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[i][6] = pal[((((VB_HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[i][7] = pal[((((VB_HWORD *)(offset))[i] >> 14) & 3)];
        }
    } else if (hflp && vflp){ 
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[7-i][7] = pal[((((VB_HWORD *)(offset))[i] >>  0) & 3)];
            sprt->line[7-i][6] = pal[((((VB_HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[7-i][5] = pal[((((VB_HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[7-i][4] = pal[((((VB_HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[7-i][3] = pal[((((VB_HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[7-i][2] = pal[((((VB_HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[7-i][1] = pal[((((VB_HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[7-i][0] = pal[((((VB_HWORD *)(offset))[i] >> 14) & 3)];
        }
    } else if(hflp) {
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[i][7] = pal[((((VB_HWORD *)(offset))[i] >>  0) & 3)];
            sprt->line[i][6] = pal[((((VB_HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[i][5] = pal[((((VB_HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[i][4] = pal[((((VB_HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[i][3] = pal[((((VB_HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[i][2] = pal[((((VB_HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[i][1] = pal[((((VB_HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[i][0] = pal[((((VB_HWORD *)(offset))[i] >> 14) & 3)];
        }
    } else if(vflp) {
        for(i = 0; i < 8; i++) {// we want words not bytes
            sprt->line[7-i][0] = pal[((((VB_HWORD *)(offset))[i] >>  0) & 3)];
            sprt->line[7-i][1] = pal[((((VB_HWORD *)(offset))[i] >>  2) & 3)];
            sprt->line[7-i][2] = pal[((((VB_HWORD *)(offset))[i] >>  4) & 3)];
            sprt->line[7-i][3] = pal[((((VB_HWORD *)(offset))[i] >>  6) & 3)];
            sprt->line[7-i][4] = pal[((((VB_HWORD *)(offset))[i] >>  8) & 3)];
            sprt->line[7-i][5] = pal[((((VB_HWORD *)(offset))[i] >> 10) & 3)];
            sprt->line[7-i][6] = pal[((((VB_HWORD *)(offset))[i] >> 12) & 3)];
            sprt->line[7-i][7] = pal[((((VB_HWORD *)(offset))[i] >> 14) & 3)];
        }
    }
}

////////////////////////////////////////////////////////////////////////////////////////
// Jason - 
// Renders a given character number into the byte buffer provided at
// The starting X and Y locations.  Note that p_wBitmapWidth is the width of the 
// buffer into which we are rendering.
// Review-- Why do we need the Palette Pointer?
//
void vRenderCharacter(VB_HWORD p_hwCharacterNumber,// The number of the character to display
				 VB_BYTE *p_pbSpriteData, // The raw byte buffer to render the sprite into.
				 VB_WORD p_wStartingX,// Starting X offset within the byte buffer
				 VB_WORD p_wStartingY,// Starting Y offset in the byte buffer
				 VB_WORD p_wBitmapWidth, // How wide the bitmap we're rendering on is.
				 bool p_fFlipHorizontally, 
				 bool p_fFlipVertically,
				 VB_BYTE p_rgbPalette[]) 
{
    int l_nRowCounter;

    VB_WORD l_wDataOffset = ChrOff[(p_hwCharacterNumber>>9)&0x03] + (CHR_SIZE * (p_hwCharacterNumber & 0x01FF)) + V810_DISPLAY_RAM.off;       
	//VB_WORD offset = ChrOff[(num>>9)&0x03] + (CHR_SIZE * (num & 0x01FF)) + V810_DISPLAY_RAM.off;       
	VB_HWORD * l_phwLineData = ((VB_HWORD *)(l_wDataOffset));
	VB_HWORD l_hwCurrentData; // We use this to store the current data.

	p_pbSpriteData += ((p_wStartingX) + (p_wStartingY*p_wBitmapWidth));

	int vinc = 1;
	int hinc = 1;

	if(p_fFlipVertically) {
		vinc = -1;
		l_phwLineData+=7;
	}
	if(p_fFlipHorizontally) {
		hinc = -1; 
		p_pbSpriteData+=7;
	}

	l_nRowCounter=7;

	do {
		l_hwCurrentData = *l_phwLineData;
		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;
		l_hwCurrentData>>=2;

		*p_pbSpriteData= p_rgbPalette[(l_hwCurrentData & 3)];
		p_pbSpriteData+=hinc;

		if(p_fFlipHorizontally) 
			p_pbSpriteData+=16;

		p_pbSpriteData+=(p_wBitmapWidth-8); // Skip to start of next.

		l_phwLineData += vinc;
	} while (l_nRowCounter--);
}

////////////////////////////////////////////////////////////////////
// returns a BGMap Buffer VB_BGMAP BGMap_Buff[4096]
// Now directly acesses the video ram (Scary)
void getBGmap(VB_HWORD num, VB_BGMAP BGMap_Buff[]) {
    int i;
    VB_HWORD thword;

    VB_WORD offset = BGMAP_OFFSET + (BGMAP_SIZE*(num & 0xF));// only 14 posible bg's, this is 16 but whos counting?
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

	i = (BGMAP_SIZE>>1)-1;
	do {
        // Make shure we only grab num's from 0-4095... 
        thword = ((VB_HWORD *)(offset))[i]; 
        BGMap_Buff[i].BCA   = thword & 0x7FF;
        BGMap_Buff[i].VFLP  = (thword >> 12) & 0x1;
        BGMap_Buff[i].HFLP  = (thword >> 13) & 0x1;
        BGMap_Buff[i].BPLTS = (thword >> 14) & 0x3;
        BGMap_Buff[i].UNDEF = (thword >> 11) & 0x1;
    } while(i--);
}

void updateBGMPalette() {
	int i;
    if(isDsp){ //If were in the Display and not the debug code...
        if(tDSPCACHE.BgmPALMod) { //If cache is invalid
			i=3;
			do {
                tDSPCACHE.BgmPAL[i][0]=((tVIPREG.GPLT[i]   )&3)+1; //First collor is transparent, offset by 1
                tDSPCACHE.BgmPAL[i][1]=((tVIPREG.GPLT[i]>>2)&3)+1; 
                tDSPCACHE.BgmPAL[i][2]=((tVIPREG.GPLT[i]>>4)&3)+1;
                tDSPCACHE.BgmPAL[i][3]=((tVIPREG.GPLT[i]>>6)&3)+1;
                tDSPCACHE.BgmPAL[i][0]=0; //Fill in the transparent char
            } while(i--);
            tDSPCACHE.BgmPALMod=0;
        }
    } else { //If in debug land (make this better!)
        for(i=0; i<4; i++) {
            tDSPCACHE.BgmPAL[i][0]=1;
            tDSPCACHE.BgmPAL[i][1]=2;
            tDSPCACHE.BgmPAL[i][2]=3;
            tDSPCACHE.BgmPAL[i][3]=4;
        }
    }

}

// Converts a BG Map Buffer to a World Picture, With Chrs in place.
void BGMap2World(VB_HWORD num, BITMAP *wPlane) {
    int i;
    VB_BGMAP BGMap_Buff[4096];
    VB_HWORD thword;

	//setup palette
	updateBGMPalette();
	
	// only 14 posible bg's, this is 16 but whos counting?
	VB_WORD offset = BGMAP_OFFSET + (BGMAP_SIZE*(num & 0xF))+V810_DISPLAY_RAM.off;

    //Grab the BGMap info...
	i = (BGMAP_SIZE>>1)-1;
	do {
        // Make shure we only grab num's from 0-4095... 
        thword = ((VB_HWORD *)(offset))[i]; 
        BGMap_Buff[i].BCA   = thword & 0x7FF;
        BGMap_Buff[i].VFLP  = (thword >> 12) & 0x1;
        BGMap_Buff[i].HFLP  = (thword >> 13) & 0x1;
        BGMap_Buff[i].BPLTS = (thword >> 14) & 0x3;
    } while(i--);

	// For each character in the map
	for(i=0;i<(BGMAP_SIZE >> 1);i++) {
        vRenderCharacter(BGMap_Buff[i].BCA, *wPlane->line, ((i&63)<<3), ((i>>6)<<3),
			wPlane->w, BGMap_Buff[i].HFLP, BGMap_Buff[i].VFLP, tDSPCACHE.BgmPAL[(BGMap_Buff[i].BPLTS&0x3)]);
    };

}

////////////////////////////////////////////////////////////////////
// returns a OBJ_buf Buffer VB_OBJ OBJ_Buff[0x400]
// Now directly acesses the video ram (Scary)
void getObj(VB_HWORD num, VB_OBJ OBJ_Buff[]) {
    VB_WORD tword;
    VB_WORD offset = OBJ_OFFSET + (OBJ_SIZE*(num & 0x03FF)); // 1024 posible obj... //0x07FF?
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    OBJ_Buff[num].JX = (int)sign_16(((VB_HWORD *)(offset))[0]);
    tword = ((VB_HWORD *)(offset))[1];
    OBJ_Buff[num].JP = (int)sign_14(tword & 0x3FFF);
    OBJ_Buff[num].JRON = (tword >> 14) & 0x1;
    OBJ_Buff[num].JLON = (tword >> 15) & 0x1;
    OBJ_Buff[num].JY = (int)sign_16(((VB_HWORD *)(offset))[2]);
    tword = ((VB_HWORD *)(offset))[3];
    OBJ_Buff[num].JCA = tword & 0x7FF;
    OBJ_Buff[num].JVFLP = (tword >> 12) & 0x1;
    OBJ_Buff[num].JHFLP = (tword >> 13) & 0x1;
    OBJ_Buff[num].JPLTS = (tword >> 14) & 0x3;
}

////////////////////////////////////////////////////////////////////
// vGetAllObjects
// Returns all objects 
//
void vGetAllObjects(VB_OBJ OBJ_Buff[]) {
    VB_WORD tword;
    int num;
    VB_WORD offset = OBJ_OFFSET + V810_DISPLAY_RAM.off;
    for(num=0; num<0x400; num++) {
        OBJ_Buff[num].JX = (int)sign_16(((VB_HWORD *)(offset))[0]);
        tword = ((VB_HWORD *)(offset))[1];
        OBJ_Buff[num].JP = (int)sign_14(tword & 0x3FFF);
        OBJ_Buff[num].JRON = (tword >> 14) & 0x1;
        OBJ_Buff[num].JLON = (tword >> 15) & 0x1;
        OBJ_Buff[num].JY = (int)sign_16(((VB_HWORD *)(offset))[2]);
        tword = ((VB_HWORD *)(offset))[3];
        OBJ_Buff[num].JCA = tword & 0x7FF;
        OBJ_Buff[num].JVFLP = (tword >> 12) & 0x1;
        OBJ_Buff[num].JHFLP = (tword >> 13) & 0x1;
        OBJ_Buff[num].JPLTS = (tword >> 14) & 0x3;
        OBJ_Buff[num].UNDEF = (tword >> 11) & 0x1;
        offset+=OBJ_SIZE;//Increment the pointer
    }
}

// Converts a OBJ_buf Buffer to a World Picture, With Chrs in place.
//Pass in int spt0-3 for the world num....
//Note modified tSprt for Blits to screen, enabling Transparency.
void Obj2World(VB_OBJ OBJ_Buff[], BITMAP *wPlane,
						 int spt_num, int img_n) {
    int i;
    int end = 0;
    BITMAP* tSprt = bmp_create(8,8);
    if(spt_num > 0) {
        if((tVIPREG.SPT[spt_num]&0x3FF) >= (tVIPREG.SPT[spt_num-1]&0x3FF)) {
            end = (tVIPREG.SPT[spt_num-1]&0x3FF);
        }
    }

    if(isDsp){ //If were in the Display and not the debug code...
        if(tDSPCACHE.ObjPALMod) { //If cache is invalid
			i = 3;
            do {
                tDSPCACHE.ObjPAL[i][0]=((tVIPREG.JPLT[i]   )&3)+1; //First collor is transparent, offset by 1
                tDSPCACHE.ObjPAL[i][1]=((tVIPREG.JPLT[i]>>2)&3)+1; 
                tDSPCACHE.ObjPAL[i][2]=((tVIPREG.JPLT[i]>>4)&3)+1;
                tDSPCACHE.ObjPAL[i][3]=((tVIPREG.JPLT[i]>>6)&3)+1;
                tDSPCACHE.ObjPAL[i][0]=0; //Fill in the transparent char
            } while(i--);
            tDSPCACHE.ObjPALMod=0;
        }
    } else { //If in debug land (make this better!),force a valid palette
		i = 3;
        do {
            tDSPCACHE.ObjPAL[i][0]=1;
            tDSPCACHE.ObjPAL[i][1]=2;
            tDSPCACHE.ObjPAL[i][2]=3;
            tDSPCACHE.ObjPAL[i][3]=4;
        } while(i--);
    }

    for(i = tVIPREG.SPT[spt_num]&0x3FF; i >= end ; i--) { //No!!!
        if(((img_n==0)&&(OBJ_Buff[i].JLON))||(img_n==-1)) { //Default, no paralax
            fchr2sprite(OBJ_Buff[i].JCA, tSprt,OBJ_Buff[i].JHFLP,OBJ_Buff[i].JVFLP,
				tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]); //Pass in the palet...
            bmp_copy(tSprt, wPlane, 0, 0, (OBJ_Buff[i].JX+7), (OBJ_Buff[i].JY+7), 8, 8);
        } else if((img_n==1)&&(OBJ_Buff[i].JLON)) { //Left Immage
            fchr2sprite(OBJ_Buff[i].JCA, tSprt,OBJ_Buff[i].JHFLP,OBJ_Buff[i].JVFLP,
				tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]); //Pass in the palet...
            bmp_copy(tSprt, wPlane, 0, 0, (OBJ_Buff[i].JX+7)-OBJ_Buff[i].JP,
				(OBJ_Buff[i].JY+7), 8, 8);
        } else if((img_n==2)&&(OBJ_Buff[i].JRON)) { //Right Immage
            fchr2sprite(OBJ_Buff[i].JCA, tSprt,OBJ_Buff[i].JHFLP,OBJ_Buff[i].JVFLP,
				tDSPCACHE.ObjPAL[(OBJ_Buff[i].JPLTS&0x3)]); //Pass in the palet...
            bmp_copy(tSprt, wPlane, 0, 0, (OBJ_Buff[i].JX+7)+OBJ_Buff[i].JP,
				(OBJ_Buff[i].JY+7), 8, 8);
        }
    }
    bmp_free(tSprt);
}

//Display the direct screen draws
//Pass in the mem buffer (0-3) and the world bitmap to draw on
//This clears the mem, as it should keep that in mind
//0-1 left dsp, 2-3 right dsp
void DSP2World(int num, BITMAP *wPlane ) {
    VB_HWORD chr;
    int y, x;
    int chr_x = 384+7;
    int chr_y = 256+7;
    VB_WORD toffset = 0;
    VB_WORD offset = (0x00008000*num); //Select Bitmap 0-3
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    for(x=7; x < chr_x; x++) {
        for(y=7; y < chr_y; y+=8) {
            chr = ((VB_HWORD *)(offset))[0];
            //Display it if not transparent
            if((chr >> 0)  & 3) wPlane->line[y+0][x] = ((chr >>  0) & 3)+1;
            if((chr >> 2)  & 3) wPlane->line[y+1][x] = ((chr >>  2) & 3)+1;
            if((chr >> 4)  & 3) wPlane->line[y+2][x] = ((chr >>  4) & 3)+1;
            if((chr >> 6)  & 3) wPlane->line[y+3][x] = ((chr >>  6) & 3)+1;
            if((chr >> 8)  & 3) wPlane->line[y+4][x] = ((chr >>  8) & 3)+1;
            if((chr >> 10) & 3) wPlane->line[y+5][x] = ((chr >> 10) & 3)+1;
            if((chr >> 12) & 3) wPlane->line[y+6][x] = ((chr >> 12) & 3)+1;
            if((chr >> 14) & 3) wPlane->line[y+7][x] = ((chr >> 14) & 3)+1;

            //Clear it, if needed
            //if (tVIPREG.XPCTRL&2) 
				//((VB_HWORD *)(offset))[0] = 0;
            offset+=2;
        }
    }
}

////////////////////////////////////////////////////////////////////
// returns a WORLD_buf Buffer VB_WORLD WORLD_Buff[32]
// Now directly acesses the video ram (Scary)
void getWorld(VB_HWORD num, VB_WORLD WORLD_Buff[]) {
    VB_WORD tword;

    VB_WORD offset = WORLD_OFFSET + (WORLD_SIZE*(num & 0x01F)); // only 32 posible worlds...
    offset += V810_DISPLAY_RAM.off; //Offset in Phisical Ram

    tword = ((VB_HWORD *)(offset))[0]; 
    WORLD_Buff[num].LON = ((tword >> 15) & 0x01);
    WORLD_Buff[num].RON = ((tword >> 14) & 0x01);
    WORLD_Buff[num].BGM = ((tword >> 12) & 0x03);
    WORLD_Buff[num].SCX = ((tword >> 10) & 0x03);
    WORLD_Buff[num].SCY = ((tword >>  8) & 0x03);
    WORLD_Buff[num].OVER= ((tword >>  7) & 0x01);
    WORLD_Buff[num].END = ((tword >>  6) & 0x01);

    WORLD_Buff[num].Unknown1 = ((tword >>  5) & 0x01);
    WORLD_Buff[num].Unknown2 = ((tword >>  4) & 0x01);

    WORLD_Buff[num].BGMAP_BASE =  (tword & 0x0F);
    
    WORLD_Buff[num].GX = (int)sign_16(((VB_HWORD *)(offset))[1]); 
    WORLD_Buff[num].GP = (int)sign_16(((VB_HWORD *)(offset))[2]);
    WORLD_Buff[num].GY = (int)sign_16(((VB_HWORD *)(offset))[3]);

    WORLD_Buff[num].MX = (int)sign_16(((VB_HWORD *)(offset))[4]);
    WORLD_Buff[num].MP = (int)sign_16(((VB_HWORD *)(offset))[5]);
    WORLD_Buff[num].MY = (int)sign_16(((VB_HWORD *)(offset))[6]);

    WORLD_Buff[num].W  = (int)sign_16(((VB_HWORD *)(offset))[7]);
    WORLD_Buff[num].H  = (int)sign_16(((VB_HWORD *)(offset))[8]);

    WORLD_Buff[num].PARAM_BASE = (((VB_HWORD *)(offset))[9]);
    WORLD_Buff[num].OVERP_CHR = ((VB_HWORD *)(offset))[10];

    WORLD_Buff[num].Dont_Write[0] = ((VB_HWORD *)(offset))[11];
    WORLD_Buff[num].Dont_Write[1] = ((VB_HWORD *)(offset))[12];
    WORLD_Buff[num].Dont_Write[2] = ((VB_HWORD *)(offset))[13];
    WORLD_Buff[num].Dont_Write[3] = ((VB_HWORD *)(offset))[14];
    WORLD_Buff[num].Dont_Write[4] = ((VB_HWORD *)(offset))[15];
}


void getAffine(int y, int pBase, AFFINE_MAP &AFN_MP) {
    VB_WORD offset;
    int t_int[4];

	offset = ((pBase*2)+BGMAP_OFFSET)&0xFFFFFFFE;
	offset += y<<4; //(y*16)

	//grab the afine entrys
	t_int[0]     = (int) sign_16((((VB_HWORD *)(offset+V810_DISPLAY_RAM.off  ))[0])&0xFFFF);
	AFN_MP.paralax  = (int) sign_16((((VB_HWORD *)(offset+V810_DISPLAY_RAM.off+2))[0])&0xFFFF);
	t_int[1]     = (int) sign_16((((VB_HWORD *)(offset+V810_DISPLAY_RAM.off+4))[0])&0xFFFF);
	t_int[2]     = (int) sign_16((((VB_HWORD *)(offset+V810_DISPLAY_RAM.off+6))[0])&0xFFFF);
	t_int[3]     = (int) sign_16((((VB_HWORD *)(offset+V810_DISPLAY_RAM.off+8))[0])&0xFFFF);
	//unknown (overplain character?)
	AFN_MP.u1    = (int) sign_16((((VB_HWORD *)(offset+V810_DISPLAY_RAM.off+10))[0])&0xFFFF);
	AFN_MP.u2    = (int) sign_16((((VB_HWORD *)(offset+V810_DISPLAY_RAM.off+12))[0])&0xFFFF);
	AFN_MP.u3    = (int) sign_16((((VB_HWORD *)(offset+V810_DISPLAY_RAM.off+14))[0])&0xFFFF);
	//convert to float, avoiding divide by zero errors
	//*****Fixme, convert this to fixed point math
	AFN_MP.pb_y  = (float)(t_int[0]/8.0);
	AFN_MP.pd_y  = (float)(t_int[1]/8.0);
	AFN_MP.pa    = (float)(t_int[2]/512.0);
	AFN_MP.pc    = (float)(t_int[3]/512.0);
}

//Return H-Bias offset for current line
int getHBiasOffset(int line, int base, int dsp) {
    VB_WORD offset;
	if(line<0) return 0;

    offset = (base*2)+BGMAP_OFFSET+V810_DISPLAY_RAM.off;
    if(dsp==2) offset += 2; // Shift by 2 if right screen 

	return (((short *)(offset))[(line<<1)]);
}

// Grab the overplane char from the defined BGMap buffers
void getOverChar(int index, BITMAP *wPlane) {
    VB_BGMAP BGMap_Buff;
    VB_HWORD thword;

	//setup palette
	updateBGMPalette();

	VB_WORD offset = BGMAP_OFFSET+(index<<1)+V810_DISPLAY_RAM.off;

	//grab bgmap entry at offset
    thword = ((VB_HWORD *)(offset))[0]; 
    BGMap_Buff.BCA   = thword & 0x7FF;
    BGMap_Buff.VFLP  = (thword >> 12) & 0x1;
    BGMap_Buff.HFLP  = (thword >> 13) & 0x1;
    BGMap_Buff.BPLTS = (thword >> 14) & 0x3;

	//grab our character
    vRenderCharacter(BGMap_Buff.BCA, *wPlane->line,0,0,
			wPlane->w, BGMap_Buff.HFLP, BGMap_Buff.VFLP, tDSPCACHE.BgmPAL[(BGMap_Buff.BPLTS&0x3)]);

}

#define ROUND_F(x) ((x)>=0?(int)((x)+0.5):(int)((x)-0.5))

void drawNormalBGMap(VB_WORLD *WBuff, BITMAP *wPlane, 
							  int img_n, int GPX, int MPX) {
	int scr_x, scr_y;
	int w,h;
	int bgc_x, bgc_y;
	int bgm_x, bgm_y;
    int bgm, bgm_base;
    int curscr,max;
    int ny, nx;
	int tPix;
	int h_off = 0;
	AFFINE_MAP tAFN_MP;
	BITMAP *ovrChr = NULL;

    bgm_base = WBuff->BGMAP_BASE;

    nx = (1<<WBuff->SCX);
    ny = (1<<WBuff->SCY);
	
	//only 8 bgmaps at a time.
	if((nx*ny)>8)
		nx =8/ny;

	//force bgm_base to align properly
	bgm_base &=~(nx*ny-1);

	//refresh any invalidated bgmaps
	max = nx*ny+bgm_base;
	//only 14 bgmaps avalible
	if(max>14) max = 14;

    //Grab the BGMaps, we can have several so grab them all...
    for(curscr = bgm_base; curscr<max; curscr++) {
        if(tDSPCACHE.BGCacheInvalid[curscr]==1) {
            BGMap2World(curscr, tDSPCACHE.BGCacheBMP[curscr]);
            tDSPCACHE.BGCacheInvalid[curscr]=0;
        }
    }

	//grab our overplane char if needed
	if(WBuff->OVER) {
		ovrChr = bmp_create(8,8);
		getOverChar(WBuff->OVERP_CHR, ovrChr);
	}

	//height is fixed to a minimum of 8 pixles and maximum of 1024
	h = WBuff->H;
	if(h<7) h=7;
	if(h>1024) h=1024;

	//widths in the negative direction grow in increments of 8
	//clip to +/- 1024 pixles
	w = WBuff->W;
	if(w<0) w &=~7;
	if(w<-1024) w=-1024;
	if(w>1023)  w=1023;

	//for every pixle on the display
	for(scr_y=0;scr_y<224;scr_y++) {

		//Handle GY
		//GY does not wrap in the positive
		if(scr_y < WBuff->GY) continue;
		bgc_y = (scr_y - WBuff->GY)&0x03FF;

		//don't draw outside of the box
		if(bgc_y>h) continue;

		if(WBuff->BGM==1) {  //H-Bias
			h_off = getHBiasOffset(bgc_y,WBuff->PARAM_BASE,img_n);
		} else if(WBuff->BGM==2) {  //Affine mode, grab affine struct
			//grab the afine entry
			getAffine(bgc_y, WBuff->PARAM_BASE, tAFN_MP);
			
			//if no scale, do nothing.
			if(!tAFN_MP.pa) 
				continue;

			//take care of paralax
			//MPX = 0;
			if(img_n==2)
				MPX = tAFN_MP.paralax;
			else //if(img_n==1) //-Pat (fixes alignment when running 2D)
				MPX = -tAFN_MP.paralax;
		}

		for(scr_x=0;scr_x<384;scr_x++) {
			
			//Handle GX
			//mask to 1024 pixles
			bgc_x = (scr_x - (WBuff->GX+GPX)) & 0x3FF; //tAFN_MP.paralax

			//handle negative widths
			if(w<0) {
				if(bgc_x<(w & 0x03FF)) continue;
			} else {
				if(bgc_x>w) continue;
			}
		
			if(WBuff->BGM==2) {  //Affine mode
				//*****FixMe, convert this to fixed point math
				//bgm_x  = ROUND_F(tAFN_MP.pb_y+((bgc_x+MPX)*tAFN_MP.pa));
				//bgm_y  = ROUND_F(tAFN_MP.pd_y+((bgc_x+MPX)*tAFN_MP.pc));
				//-Pat (Affine MP Parallax handled funny - Dev Manual 27.2)
				if (MPX>=0)
				{
					bgm_x  = ROUND_F(tAFN_MP.pb_y+((bgc_x+MPX)*tAFN_MP.pa));
					bgm_y  = ROUND_F(tAFN_MP.pd_y+((bgc_x+MPX)*tAFN_MP.pc));
				}
				else
				{
					bgm_x  = ROUND_F(tAFN_MP.pb_y+((bgc_x)*tAFN_MP.pa));
					bgm_y  = ROUND_F(tAFN_MP.pd_y+((bgc_x)*tAFN_MP.pc));
				}
			} else {
				//Handle MX/MY
				bgm_x = WBuff->MX + bgc_x + MPX + h_off;
				bgm_y = WBuff->MY + bgc_y;
			}

			//time for over_plane char?
			if(WBuff->OVER && ((bgm_x & ~((nx<<9)-1))||(bgm_y & ~((ny<<9)-1)))) {
				bgm_x &= 7;
				bgm_y &= 7;

				tPix = ovrChr->line[bgm_y][bgm_x];
			} else {
				//mask x and y
				bgm_x &= ((nx<<9)-1);
				bgm_y &= ((ny<<9)-1);

				//find BGMap to cut out of
				bgm = bgm_base+(bgm_x>>9)+(bgm_y>>9)*nx;

				//if past last BGMap, drop it.
				if(bgm>=14) continue;

				bgm_x &=511;
				bgm_y &=511;

				//draw our pixle
				tPix = tDSPCACHE.BGCacheBMP[bgm]->line[bgm_y][bgm_x];
			}
		
			//dont draw if transparnet
			if(!tPix) continue;
		
			//and place on dest bitmap
			wPlane->line[scr_y+7][scr_x+7] = tPix;
		}
	}

	if(ovrChr)
		bmp_free(ovrChr);
}

////////////////////////////////////////////////////////////////////
// Render a Display Screen on a Screen Bitmap, pass in an array
//  of type World Obj.
//bool World2Display(VB_WORLD WORLD_Buff[], BITMAP *sPlane, int DispLR) {
//img_n =-1   - left and right display no paralax, for debugging
//img_n = 0   - left display, no paralax
//img_n = 1,2 - left or right displays with paralax
void World2Display(int wNum, VB_WORLD WORLD_Buff[], BITMAP *wPlane, int img_n) {
//    int bgm;
//    int curscr,max;
//    int ny, nx;
    int GPX = 0;//Global Paralax setings...
    int MPX = 0;

    //Kill it if were trying to display the wrong screen type...
    if(((!img_n)||(img_n==1))&&(!WORLD_Buff[wNum].LON)) return;
    if((img_n==2)&&(!WORLD_Buff[wNum].RON)) return;

    if(img_n==2) {
        GPX = WORLD_Buff[wNum].GP;//Global Paralax setings...
        MPX = WORLD_Buff[wNum].MP;
    }else {//if(img_n==1) { -Pat (2D mode should still have Parallax on eye shown, right?)
        GPX = -WORLD_Buff[wNum].GP;//Global Paralax setings...
        MPX = -WORLD_Buff[wNum].MP;
    }

    if(WORLD_Buff[wNum].BGM==3) {  //Obj
        if(tDSPCACHE.ObjDataCacheInvalid==1) { //Cash the Obj Info...
            vGetAllObjects(tDSPCACHE.ObjDataCache); 
            tDSPCACHE.ObjDataCacheInvalid=0;
        }
        //Dont mess around with sub bitmaps, just blast it to the world plane
        Obj2World(tDSPCACHE.ObjDataCache, wPlane,CurObj,img_n);
        CurObj = (CurObj-1)&3; //(CurObj-1)%4;
    } else {
        drawNormalBGMap( &WORLD_Buff[wNum], wPlane, img_n, GPX, MPX);
    }
}


////////////////////////////////////////////////////////////////////
//Initialize the display, and get the video mode (from wherever)
bool V810_DSP_Init() {
    int i,tmp_x,tmp_y;
    int done = 0;

	//call our platform dependant init code.
	if(!init_graphics()) {
		V810_DSP_Quit();
		return false;
	}

	bmp_clear_palette();

    // fill our palette with a gradually altering sequence of colors 
    V810_SetPal(21,42,63);

    for(i=0;i<14;i++) {
        tDSPCACHE.BGCacheBMP[i] = bmp_create(512,512); //Creat our temp Bitmap...
    }
    world_bmp = bmp_create(512+8,512+8); //Make them a bit bigger for the Obj's
    world_bmp2 = bmp_create(512+8,512+8);

	//create a buffer large enough to hold a 512x512 image and the display
	tmp_x = tVBOpt.VB_X*2;
	if(tmp_x<tVBOpt.SCR_X) tmp_x = tVBOpt.SCR_X;
	tmp_y = tVBOpt.VB_Y*2;
	if(tmp_y<tVBOpt.SCR_Y) tmp_y = tVBOpt.SCR_Y;
    dsp_bmp = bmp_create(tmp_x,tmp_y);

    for(i=0;i<4;i++) {
        tDSPCACHE.ObjCacheBMP[i] = bmp_create(512,512); //Creat our temp Bitmap...
    }

    bmp_clear(world_bmp,(tVIPREG.BKCOL&0x3)+1);                    // zero the memory bitmap
    bmp_clear(world_bmp2,(tVIPREG.BKCOL&0x3)+1);                   // zero the memory bitmap
    bmp_clear(dsp_bmp,(tVIPREG.BKCOL&0x3)+1);                      // zero the memory bitmap

    //End Alegro Code

    return true;
}

void V810_SetPal(int BRTA, int BRTB, int BRTC) {
	int brtA = (int)(BRTA*tVBOpt.BFACTOR);
	int brtB = (int)(BRTB*tVBOpt.BFACTOR);
	int brtC = (int)(BRTC*tVBOpt.BFACTOR);

	bmp_set_palette(tVBOpt, brtA, brtB, brtC);
}


void V810_DSP_Quit() {
    int i=0;
    for(i=0;i<14;i++) {
        bmp_free(tDSPCACHE.BGCacheBMP[i]);
    }
    bmp_free(world_bmp);
    bmp_free(world_bmp2);
    bmp_free(dsp_bmp);
    for(i=0;i<4;i++) {
        bmp_free(tDSPCACHE.ObjCacheBMP[i]);
    }

	close_graphics();
} 

//Collect all the display init code together...
//has counterpart V810_DSP_DBG that launches a debug version of the display routines
void V810_DSP() {
    if(!V810_DSP_Init()) return;

    V810_Dsp_Go();

    //Uninstall Alegro!
    V810_DSP_Quit();
}

//frame skip stuff
#define INTERVALS 10
#define MAX_FPS 50
#define CLOCK_TICKS (CLOCKS_PER_SEC/INTERVALS)

//Run the CPU and display (Start the real emu...
void V810_Dsp_Go() {
    int qwe, err=0;
    /*static*/ int Left = 0;
    //int skip = 0;

	//reset exit_flag in case this is the second time through... (darn globals)
	exit_flag = 0;

	//frame skip stuff
	int frm_cnt = 0, tCount = 0;
	int start_time, tClock;

    clearCache();

	//frame skip stuff
	start_time = clock();
	tClock = start_time;

    for(;;) {
		if (!err) {
			//pump cpu untill time for a display
			for(qwe=0;qwe<=tVBOpt.FRMSKIP;qwe++) {
				//Trace
				err = v810_trc(0);
				frm_cnt++;

				/*
				// Display a frame, only after the right number of 'skips'as set up by the VB
				if((tVIPREG.FRMCYC & 0x00FF) < skip) {
					skip = 0;

					//remove me, get curent frame from VIP flags, 
					//  disabled for now, breakes Space Invaders
					//if(Left==0)
					//	Left = 1;
					//else 
					//	Left = 0;
				}

				// Increment skip
				skip+=1;
				*/
			}
			// Display, if display is turned on.
			if (tVIPREG.DPCTRL & 0x0002) {
				V810_Dsp_Frame(Left); //Temporary...
			}
			else scr_clear(); //***RemoveMe ????
		}


		if (test_key(VBK_ESC)) {
			while (test_key(VBK_ESC)) ; //Silly hack, so you can hold the esc key down...
			exit_flag=1;
			clear_key(); // Make sure were not killing the returning prog!
		}

		if (test_key(VBK_PAUSE)) {
			while (test_key(VBK_PAUSE)) ;

			//mute while paused
			sound_enable(false);

			while (!(test_key(VBK_PAUSE)))
			{
				if (test_key(VBK_ESC)) {
					while (test_key(VBK_ESC)) ; //Silly hack, so you can hold the esc key down...
					exit_flag=1;
					clear_key(); // Make sure were not killing the returning prog!
					break;
				}
				vb_yield(); //keep from hogging CPU time
			}
			while (test_key(VBK_PAUSE)) ;
			sound_enable(true);
		}
//****FixMe
#ifdef VB_DEBUGGER
		if (test_key(VBK_CACHE)) { //output cache statistics
			while (test_key(VBK_CACHE));
			vb_printf("\nCache Hits: %llu",cache_hit_cnt);
			vb_printf("\nCache Misses: %llu",cache_miss_cnt);
			if (cache_miss_cnt!=0) //prevent div by 0
				vb_printf("\nHit to Miss ratio: %llu:1",(cache_hit_cnt/cache_miss_cnt));
			vb_printf("\nPercentage of instructions cached: %llu%%",((100*(cache_hit_cnt+cache_miss_cnt))/total_inst));
		}
		if (test_key(VBK_CLR_STAT)) { //output cache statistics
			while (test_key(VBK_CLR_STAT));
			cache_hit_cnt=0;
			cache_miss_cnt=0;
			total_inst=0;
		}
#endif

		if (exit_flag) {
			clearCache();
			scr_clear();
			break; //Enough already!
		}

		//frame skip stuff
		if((frm_cnt > (MAX_FPS/INTERVALS))) {
			if(!tVBOpt.NO_THRTL) //only throttle if nessisary
				while(clock() < (start_time+CLOCK_TICKS))
					vb_yield();

			start_time = clock();
			frm_cnt = 0;

			if(++tCount == INTERVALS) {
				fps = MAX_FPS/(((float)(clock()-tClock))/(float)CLOCKS_PER_SEC);
				tCount = 0;
				tClock = start_time;
			}
		}
	}
}

//Display one frame of graphics...
void V810_Dsp_Frame(int dNum) {
    BITMAP *tmp_bmp = NULL;
    VB_WORLD WORLD_Buff[32];
    int i, j;
    int T_X=384, T_Y=224;
	char tstr[32];
    int tObj=0;

    isDsp=1; //Secret flag...
    CurObj=3;

    //Normalize the Palette, Is this to slow??? (tVIPREG.BRTA*64)/MaxBrt
    if(tDSPCACHE.BrtPALMod) { //If palette changed
        // If we want a fixed palette (no brightness adjustment...)
        //V810_SetPal(tVIPREG.BRTA, tVIPREG.BRTB, tVIPREG.BRTA+tVIPREG.BRTB+tVIPREG.BRTC);
		
		//from red_dragon, does this work?
        V810_SetPal( (tVIPREG.BRTA&0xFF)/2, (tVIPREG.BRTB&0xFF)/2, 
			((tVIPREG.BRTA&0xFF)+(tVIPREG.BRTB&0xFF)+(tVIPREG.BRTC&0xFF))/2);

        tDSPCACHE.BrtPALMod=0;
    }

    if(tVBOpt.DSPMODE == dm_NORMAL) {  //Normal
        bmp_clear(world_bmp,(tVIPREG.BKCOL&0x3)+1); // zero the memory bitmap

        for(i = 31; i>=0; i--) {
            getWorld(i,WORLD_Buff);
            if(WORLD_Buff[i].END) break; //hear? or farther down...
            World2Display(i, WORLD_Buff, world_bmp,0);
        }

        //DSP2World(dNum,world_bmp);
		DSP2World((tVIPREG.tFrame-1)^1,world_bmp); //display buffer not being edited
		T_X = 384;
		T_Y = 224;
		tmp_bmp = bmp_clip(world_bmp, 7, 7, T_X, T_Y);
    } else { // 3D Mode...
        bmp_clear(world_bmp,(tVIPREG.BKCOL&0x3)+1);                      // zero the memory bitmap
        bmp_clear(world_bmp2,(tVIPREG.BKCOL&0x3)+1);                      // zero the memory bitmap

        for(i = 31; i>=0; i--) {
            getWorld(i,WORLD_Buff);
            if(WORLD_Buff[i].END) break; //hear? or farther down...
            tObj = CurObj; // Save Curent Obj
            World2Display(i, WORLD_Buff, world_bmp,1+tVBOpt.DSPSWAP);
            CurObj = tObj; //Reset it..
            World2Display(i, WORLD_Buff, world_bmp2,2-tVBOpt.DSPSWAP);
        }

        //DSP2World((dNum&1),world_bmp);
        //DSP2World((dNum&1)+2,world_bmp2);
		if (!tVBOpt.DSPSWAP)
		{
			DSP2World((tVIPREG.tFrame-1)^1,world_bmp); //display buffer not being edited
			DSP2World(((tVIPREG.tFrame-1)^1)+2,world_bmp2); //display buffer not being edited
		}
		else
		{
			DSP2World((tVIPREG.tFrame-1)^1,world_bmp2); //display buffer not being edited
			DSP2World(((tVIPREG.tFrame-1)^1)+2,world_bmp); //display buffer not being edited
		}

        if(tVBOpt.DSPMODE == dm_INTERLACED) {  //Interlaced
            for(i=0;i<=224;i++) {
                bmp_copy(world_bmp, dsp_bmp, 7, i+7, 0, (i*2), 384, 1);
                bmp_copy(world_bmp2, dsp_bmp, 7, i+7, 0, (i*2)+1, 384, 1);
            }
			T_X = 384;
			T_Y = 224*2;
        } else if(tVBOpt.DSPMODE == dm_OVRUNDR) { // Over/Under
            bmp_copy(world_bmp, dsp_bmp, 7, 7, 0, 0, 384, 224);
            bmp_copy(world_bmp2, dsp_bmp, 7, 7, 0, 224, 384, 224);
			T_X = 384;
			T_Y = 224*2;
        } else if(tVBOpt.DSPMODE == dm_AFFINE) {
            for(i=0;i<225;i++){
                for(j=0;j<385;j++) {
                    if(world_bmp->line[i+7][j+7] >0) world_bmp->line[i+7][j+7] -= 1;   //Normalize the display
                    if(world_bmp2->line[i+7][j+7] >0) world_bmp2->line[i+7][j+7] -= 1;
                    dsp_bmp->line[i][j] =  (world_bmp->line[i+7][j+7] + (world_bmp2->line[i+7][j+7]*4))+8;
                }
            }
			T_X = 384;
			T_Y = 224;
        } else if(tVBOpt.DSPMODE == dm_SIDESIDE) { // Side-by-Side
            bmp_copy(world_bmp, dsp_bmp, 7, 7, 0, 0, 384, 224);
            bmp_copy(world_bmp2, dsp_bmp, 7, 7, 384, 0, 384, 224);
			T_X = 384*2;
			T_Y = 224;
        } else if(tVBOpt.DSPMODE == dm_CYBERSCOPE) { // CyberScope
            tmp_bmp = bmp_clip(world_bmp, 7, 7, 384, 224);
			bmp_rotate(dsp_bmp,tmp_bmp, 0,384,0,0, 64*3);
			bmp_free(tmp_bmp);

            tmp_bmp = bmp_clip(world_bmp2, 7, 7, 384, 224);
			bmp_rotate(dsp_bmp, tmp_bmp, 224, 0, 0, 224, 64);
			bmp_free(tmp_bmp);

			T_X = 224*2;
			T_Y = 384;
        }      
 		tmp_bmp = bmp_clip(dsp_bmp, 0, 0, T_X, T_Y);
    }

    if(test_key(VBK_PRN))  {
		bmp_save(tmp_bmp,"dsp");
        while(test_key(VBK_PRN)) ; //Wait till they release the key!
    }

	//print FPS if turned on
	if(tVBOpt.STATUS) {
		sprintf(tstr,"%1.0f",fps);
		bmp_printf(tmp_bmp, 5, 5, tstr);
	}

	//Blit finished screen to display
	bmp_display(tmp_bmp);
    bmp_free(tmp_bmp);

    isDsp=0; //Secret flag...
}

void clearCache() {
      int i;
	tDSPCACHE.BgmPALMod=1;			//World Palette Changed
	tDSPCACHE.ObjPALMod=1;			//Obj Palette Changed
	tDSPCACHE.BrtPALMod=1;			//Britness for Palette Changed
	tDSPCACHE.ObjDataCacheInvalid=1;	//Object Cache Is invalid
	tDSPCACHE.ObjCacheInvalid=1;		//Object Cache Is invalid
	for(i=0;i<14;i++) tDSPCACHE.BGCacheInvalid[i]=1;//Object Cache Is invalid
}

