////////////////////////////////////////////////////////////////
// Defines for the V810 CPU debug

#ifndef V810_CPU_D_H_
#define V810_CPU_D_H_

#include <stdio.h>
#include "vb_io.h"
#include "v810_opt.h"

//Add an element into our linked list
void v810_addDasm(VB_WORD tPC);

//write out our linked list to a file
void v810_writeDasm();

//clear our linked list of data
void v810_clearDasm();

// Dissasemble num lines of code  starting at tPC (If tPC == -1 start at PC)
long v810_dis(long tPC, int num, FILE* fout);

// Print the P_REG out
void v810_preg();

// Dump num lines
void v810_dump(long tPC, int num);

// Keep a running dump of last 100 instructions executed
void v810_add_queue(VB_WORD num);
void v810_dump_queue();

#endif

