////////////////////////////////////////////////////////////////
// Defines for the V810 CPU

#ifndef V810_CPU_H_
#define V810_CPU_H_

#include "vb_io.h"


//System Register Defines (these are the only valid system registers!)
#define EIPC     0       //Exeption/Interupt PC
#define EIPSW    1       //Exeption/Interupt PSW

#define FEPC     2       //Fatal Error PC
#define FEPSW    3       //Fatal Error PSW

#define ECR      4       //Exception Cause Register
#define PSW      5       //Program Status Word
#define PIR      6       //Processor ID Register
#define TKCW     7       //Task Controll Word
#define CHCW     24      //Cashe Controll Word
#define ADDTRE   25      //ADDTRE

//PSW Specifics
#define PSW_IA  0xF0000 // All Interupt bits...
#define PSW_I3  0x80000
#define PSW_I2  0x40000
#define PSW_I1  0x20000
#define PSW_I0  0x10000

#define PSW_NP  0x08000
#define PSW_EP  0x04000

#define PSW_ID  0x01000
#define PSW_DP  0x00800
#define PSW_SAT 0x00400

#define PSW_CY  0x00008
#define PSW_OV  0x00004
#define PSW_S   0x00002
#define PSW_Z   0x00001

//condition codes
#define COND_V  0
#define COND_C  1
#define COND_Z  2
#define COND_NH 3
#define COND_S  4
#define COND_T  5
#define COND_LT 6
#define COND_LE 7
#define COND_NV 8
#define COND_NC 9
#define COND_NZ 10
#define COND_H  11
#define COND_NS 12
#define COND_F  13
#define COND_GE 14
#define COND_GT 15

///////////////////////////////////////////////////////////////////
// Defines for memory and IO acces
// Grabed From StarScream Source

struct V810_MEMORYFETCH {
        VB_WORD lowaddr;  // Start of ram
        VB_WORD highaddr; // end of ram
        VB_WORD off;              // Displacement... (off+addr = pmempry...)
        VB_BYTE *pmemory; // Pointer to memory
};

struct V810_REGFETCH {
        VB_WORD lowaddr;  // Start of ram
        VB_WORD highaddr; // end of ram
        VB_BYTE  (*rfuncb)(VB_WORD);  // Pointer to the Register Read func
        void  (*wfuncb)(VB_WORD, VB_BYTE);    // Pointer to the Register Write func
        VB_HWORD (*rfunch)(VB_WORD);  // Pointer to the Register Read func
        void  (*wfunch)(VB_WORD, VB_HWORD);   // Pointer to the Register Write func
        VB_WORD  (*rfuncw)(VB_WORD);  // Pointer to the Register Read func
        void  (*wfuncw)(VB_WORD, VB_WORD);    // Pointer to the Register Write func
};


///////////////////////////////////////////////////////////////////
// Define CPU Globals


extern VB_WORD P_REG[32];  // Program registers pr0-pr31
extern VB_WORD S_REG[32];  // System registers sr0-sr31
extern VB_WORD PC;         // Program Counter
extern const VB_BYTE opcycle[0x50]; //clock cycles

extern /*VB_INT64U*/ VB_WORD cache_hit_cnt;
extern /*VB_INT64U*/ VB_WORD cache_miss_cnt;
extern /*VB_INT64U*/ VB_WORD total_inst;

extern unsigned int play_breakpnt_en;
extern unsigned int play_breakpnt;
extern unsigned int mem_watchpnt_en;
extern unsigned int mem_watchpnt;

//////////////////////////////////////////////////////////////////////////
// Define CPU Functions

// Reset the registers
void v810_reset();  

// Trace num instructions
int v810_trc(int dbg_trc);

// Generate Interupt #n
void v810_int(VB_WORD iNum);

// Generate Exception #n
void v810_exp(VB_WORD iNum, VB_WORD eCode);

void serviceInt(unsigned int cycles);
int serviceDisplayInt(unsigned int cycles);

int bstr_subop(int sub_op, int arg1, unsigned int *clocks);

int fpu_subop(int sub_op, int arg1, int arg2, unsigned int *clocks);


#endif

