// Defines the allegro platform specific I/O routines: keyboard, joystick, sound, etc.

#ifndef CPIO_H
#define CPIO_H

#ifdef _WIN32
// Exclude rarely-used stuff from Windows headers
#define WIN32_LEAN_AND_MEAN

#ifdef VB_DEBUGGER
#define _CONSOLE
#define ALLEGRO_USE_CONSOLE
#define ALLEGRO_NO_MAGIC_MAIN
#endif
#endif //_WIN32

#include <allegro.h>
#ifdef _WIN32
#include <winalleg.h>
#endif //_WIN32

// ====== Global defines ======

typedef unsigned long VB_WORD;            //Full 32bit
typedef unsigned char VB_BYTE;            //8bit
typedef unsigned short VB_HWORD;          //16bit
typedef long long int VB_INT64;           //64 bit int
typedef long long unsigned int VB_INT64U; //64 bit Unsigned

//64 bit constants are not cross platform compatible
#define sign_32(num) (((num) & 0x80000000) ? (VB_INT64)((num)|0xFFFFFFFF00000000LL) : (num))

#endif //#define CPIO_H
