#include <stdlib.h>
#include <ctype.h>

#include "vb_io.h"
#include "v810_cpu.h"
#include "v810_cpuD.h"
#include "vb_dsp.h"
#include "vb_dspD.h"
#include "vb_set.h"
#include "vb_vbt.h"

#include "vb_vbtD.h"

//////////////////////////////////////////////////////////

void vb_goDbg() {
    char inputstr[80];
    char *cmd, *args, *argsend;
    unsigned long tmppc, tmpmem, debugPC;
    FILE *nvramf;
    VB_WORD j;

    debugPC = PC;
    v810_dis(PC, 1,stdout);

    vb_printf("\n Beginning emulation, type ? for help\n");
    // Controll Loop stolen form StarScream CPU Core
    for(;;){
        vb_printf("\nV810-");

		//get input, abort if nothing returned
        if(NULL == fgets(inputstr,sizeof(inputstr),stdin))
			continue;

        cmd=inputstr;
        while((tolower(*cmd)<'a')&&(tolower(*cmd)>'z')){
            if(*cmd==0)break;
            cmd++;
        }
        if(!(*cmd))continue;
        *cmd=tolower(*cmd);
        args=cmd+1;
        while(((*args)!=0)&&((*args)<32))args++;
        switch(*cmd){
        case '?': //Help
            vb_printf(
            "b [address]    Run continuously, break at PC=[address]\n"
			"p [address]    Play (Video mode), break at PC=[address]\n"
			"w [address]    Watch memory location\n"
			"h [address]    Break at memory access\n"
            "d [address]    Dump memory, starting at [address] (16-Bit Little Endian)\n"
            "i [number]     Generate hardware interrupt [number]\n"
            "j [address]    Jump directly to [address]\n"
            "q              Quit\n"
            "r              Show register dump and next instruction\n"
            "t [hex number] Trace through [hex number] instructions\n"
            "u [address]    Unassemble code, starting at [address]\n"
			"s              Show last 100 instructions executed\n"
            "v              goto Video mode\n"
            "m              write memory to a file(For debug only)\n"
            "l [level]      set the debug level\n"
			"a              start interactive dissasembler\n"
            );
            break;
        case 'b':          //Break at addres
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,16);
                if(argsend!=args){
                    while(PC !=tmppc){
                        //if(kbhit())
                            //if(getch() == 27) break; //Fix with allegro!
                        v810_trc(1);
                    }
                    v810_preg();
                    v810_dis(PC, 1,stdout);
                    debugPC = PC;
                }else{
                    vb_printf("Invalid address\n");
                }
            }else{
                vb_printf("Need an address\n");
            }
            break;
		case 'p':          //play until break at address
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,16);
                if(argsend!=args){
					play_breakpnt_en^=1;
					play_breakpnt=tmppc;
                    V810_DSP_DBG();
                }else{
                    vb_printf("Invalid address\n");
                }
            }else{
                vb_printf("Need an address\n");
            }
            break;
		case 'w':          //watch memory
            if((*args)!=0){
                tmpmem=strtoul(args,&argsend,16);
                if(argsend!=args){
                    mem_watchpnt_en^=1;
					mem_watchpnt=tmpmem;
                }else{
                    vb_printf("Invalid address\n");
                }
            }else{
                vb_printf("Need an address\n");
            }
            break;
		case 'h':          //break at memory access
            if((*args)!=0){
                tmpmem=strtoul(args,&argsend,16);
                if(argsend!=args){
                    mem_watchpnt_en^=2;
					mem_watchpnt=tmpmem;
                }else{
                    vb_printf("Invalid address\n");
                }
            }else{
                vb_printf("Need an address\n");
            }
            break;
        case 'd': //Dump memory
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,16);
                if(argsend!=args)debugPC=tmppc;
                if (tmppc == -1) debugPC = PC; //Hack, Ignore the sign/unsgn prob...
            }
            v810_dump(debugPC, 16);
            debugPC += 16*16;
            break;
        case 'i': //Generate Interupt #
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,10);
                if(argsend!=args){
                    vb_printf("Interrupt %ld generated\n",tmppc);
                    v810_int(tmppc);
                    //v810_trc();
                    v810_preg();
                    v810_dis(PC, 1,stdout);
                    debugPC = PC;
                }else{
                    vb_printf("Invalid interrupt number\n");
                }
            }else{
                vb_printf("Need an interrupt number\n");
            }
            break;
        case 'j': //Jump directly to address
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,16);
                if(argsend!=args){
                    PC=tmppc;
                    vb_printf("PC set to %08lx\n",PC);
                    //v810_trc();
                    v810_preg();
                    v810_dis(PC, 1,stdout);
                    debugPC = PC;
                }else{
                    vb_printf("Invalid address\n");
                }
            }else{
                vb_printf("Need an address\n");
            }
            break;
        case 'm':  //Dump Memory
            vb_printf("\nWriting memory to file...");
            // save out the VIP Display ram
            if((nvramf = fopen("ram_vip.bin", "wb")) == NULL) {
                vb_printf("\nError opening ram_vip.bin");
            }
			else
			{
				for(j=V810_DISPLAY_RAM.lowaddr; j <= V810_DISPLAY_RAM.highaddr; j++) {
					fputc((char)mem_rbyte(j), nvramf);
				}
				fclose(nvramf);
			}
            // save out the Sound ram
            if((nvramf = fopen("ram_sound.bin", "wb")) == NULL) {
                vb_printf("\nError opening ram_sound.bin");
            }
            else
			{
				for(j=V810_SOUND_RAM.lowaddr; j <= V810_SOUND_RAM.highaddr; j++) {
					fputc((char)mem_rbyte(j), nvramf);
				}
				fclose(nvramf);
			}
            // save out the system ram
            if((nvramf = fopen("ram_sys.bin", "wb")) == NULL) {
                vb_printf("\nError opening ram_sys.bin");
            }
            else
			{
				for(j=V810_VB_RAM.lowaddr; j <= V810_VB_RAM.highaddr; j++) {
					fputc((char)mem_rbyte(j), nvramf);
				}
				fclose(nvramf);
			}
            // save out the sram ram
            if((nvramf = fopen("ram_sram.bin", "wb")) == NULL) {
                vb_printf("\nError opening ram_sram.bin");
            }
            else
			{
				for(j=V810_GAME_RAM.lowaddr; j <= V810_GAME_RAM.highaddr; j++) {
					fputc((char)mem_rbyte(j), nvramf);
				}
				fclose(nvramf);
			}
            break;  
        case 'q':  //Quit
		return;
        case 'r':
            v810_preg();
            v810_dis(PC, 1,stdout);
            break;
        case 't': //Trace through n lines of code
            tmppc=1;
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,16);
                if(argsend==args)tmppc=1;
            }
            if(tmppc>0){
                v810_trc(1);
                v810_preg();
                v810_dis(PC, 1,stdout);
                debugPC = PC;
            }
            break;
        case 'u': //Unassemble
            if((*args)!=0){ 
                tmppc=strtoul(args,&argsend,16);
                if(argsend!=args)debugPC=tmppc;
                if (tmppc == -1) debugPC = PC; //Hack, ignore the Signed/unsigned prob
            }
            debugPC = v810_dis(debugPC, 16,stdout);
            //debugPC +=16;
            break;
		case 's': //dump CPU queue
            v810_dump_queue();
            break;
        case 'v': //got Video Mode
            V810_DSP_DBG();
            break;
        case 'l': //debug level
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,10);
                if(argsend!=args){
                    vb_printf("Debug level %ld set\n",tmppc);
                    vb_log_msgLVL = tmppc;
                }else{
                    vb_printf("Invalid debug level\n");
                }
            }else{
                vb_printf("Need an debug level\n");
            }
            break;
		case 'a':
			if(tVBOpt.DISASM) {
				tVBOpt.DISASM = 0;
				vb_printf("dissasembler is off\n");
			} else {
				tVBOpt.DISASM = 1;
				vb_printf("dissasembler is on\n");
			}
			break;
        default:
            break;
        }
    }
}
