#include "vb_io.h"
#include "v810_cpu.h"
#include "vb_dsp.h"
#include "vb_set.h"
#include "vb_vbt.h"
#include "unzip.h"
#include "vb_sound.h"
#include "vb_link.h"

#ifdef VB_DEBUGGER
#include "v810_cpuD.h"
#include "vb_vbtD.h"
#endif

int vb_main(int argc, char *argv[]) {
    vb_printf("\n%s\n", VB_VER_STR_1);
    vb_printf("\n  %s\n\n", VB_VER_STR_2);

    //Load our options from the command line. ***FixMe, add in .ini file support
    if(!setOptions(argc,argv)) {
		return 0;
	}

	//***RemoveMe, debug code
	//dump_settings();

	vbio_init();
	sound_init();
	link_init();

    v810_init(tVBOpt.ROM_NAME);
    v810_reset();
   
#ifdef VB_DEBUGGER
	//If not Debug
    if(!tVBOpt.DEBUG) { 
#endif
        V810_DSP();
#ifdef VB_DEBUGGER
    } else { //Debug
        vb_goDbg();
    } //End Debug...
#endif

	save_sram();
	v810_shutdown();

	link_close();
	sound_close();
	vbio_close();

	return 0;
}

