#include "vb_set.h"
#include "vb_dsp.h"
#include "vb_vbt.h"
#include "vb_link.h"

#ifdef _WIN32
#include <winsock2.h>
#include <ws2tcpip.h>

//8269 is VBOY on a phone keypad (could make a command line arg if anyone cares)
#define VB_LINK_PORT "8269" 

SOCKET ConnectSocket = INVALID_SOCKET;
#endif

bool link_init() {
#ifdef _WIN32
	SOCKET ListenSocket  = INVALID_SOCKET;
	WSADATA wsaData;    
	struct addrinfo *result = NULL;
	struct addrinfo *ptr    = NULL;
	struct addrinfo  hints;
	int iResult;

	if (!tVBOpt.NETWORK)
		return false;

	// Initialize Winsock
	iResult = WSAStartup(MAKEWORD(2,2), &wsaData);
	if (iResult != 0) {
		vb_log_msg(10,"WSAStartup failed: %d\n", iResult);
		return false;
	}
	ZeroMemory(&hints, sizeof(hints));
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_protocol = IPPROTO_TCP;
	char *ipAddr = NULL;

	if (!strcmp(tVBOpt.IP_ADDR,"host")) {
		hints.ai_family = AF_INET;
		hints.ai_flags = AI_PASSIVE;
	} else {
		hints.ai_family = AF_UNSPEC;
		ipAddr = tVBOpt.IP_ADDR;
	}

	// Resolve the address and port
	iResult = getaddrinfo(ipAddr, VB_LINK_PORT, &hints, &result);
	if ( iResult != 0 ) {
		vb_log_msg(10,"getaddrinfo failed: %d\n", iResult);
		WSACleanup();
		return false;
	}

	//to clean up, this could move to a seperate function
	if (!strcmp(tVBOpt.IP_ADDR,"host")) {

		// Create a SOCKET for connecting to server
		ListenSocket = socket(result->ai_family, result->ai_socktype, result->ai_protocol);
		if (ListenSocket == INVALID_SOCKET) {
			vb_log_msg(10,"socket failed: %ld\n", WSAGetLastError());
			freeaddrinfo(result);
			WSACleanup();
			return false;
		}

		// Setup the TCP listening socket
		iResult = bind( ListenSocket, result->ai_addr, (int)result->ai_addrlen);
		if (iResult == SOCKET_ERROR) {
			vb_log_msg(10,"bind failed: %d\n", WSAGetLastError());
			freeaddrinfo(result);
			closesocket(ListenSocket);
			WSACleanup();
			return false;
		}
		freeaddrinfo(result);

		iResult = listen(ListenSocket, SOMAXCONN);
		if (iResult == SOCKET_ERROR) {
			vb_log_msg(10,"listen failed: %d\n", WSAGetLastError());
			closesocket(ListenSocket);
			WSACleanup();
			return false;
		}

		vb_log_msg(10,"Waiting for remote system...");

		// Accept a client socket
		ConnectSocket = accept(ListenSocket, NULL, NULL);
		if (ConnectSocket == INVALID_SOCKET) {
			vb_log_msg(10,"accept failed: %d\n", WSAGetLastError());
			closesocket(ListenSocket);
			WSACleanup();
			return false;
		}

		vb_log_msg(10," Connected!\n");

		// No longer need server socket
		closesocket(ListenSocket);
	} else {
		// Attempt to connect to an address until one succeeds
		for(ptr=result; ptr != NULL ;ptr=ptr->ai_next) {

			// Create a SOCKET for connecting to server
			ConnectSocket = socket(ptr->ai_family, ptr->ai_socktype, 
				ptr->ai_protocol);
			if (ConnectSocket == INVALID_SOCKET) {
				vb_log_msg(10,"Error at socket(): %ld\n", WSAGetLastError());
				freeaddrinfo(result);
				WSACleanup();
				return false;
			}

			// Connect to server.
			iResult = connect( ConnectSocket, ptr->ai_addr, (int)ptr->ai_addrlen);
			if (iResult == SOCKET_ERROR) {
				closesocket(ConnectSocket);
				ConnectSocket = INVALID_SOCKET;
				continue;
			}
			break;
		}
		freeaddrinfo(result);

		if (ConnectSocket == INVALID_SOCKET) {
			vb_log_msg(10,"Unable to connect to server!\n");
			WSACleanup();
			return false;
		}

		vb_log_msg(10,"Connected!\n");
	}
#endif
	return true;
}

//packet format:
//[T|C|U|U|U|M|M/S|D7] [T|D6-D0]
//T:1=COMCNT,0=Data
//C:COMCNT bit
//M:More data (part of data transmission, M/S and D7 are included in this byte)
//M/S: 1=Master, 0=Slave, if master, data is actually "clocked"
//U:Unused
void link_update(int reg) {
#ifdef _WIN32

	//static state variables
    static int remote_comcnt=1;
    static int last_comcnt=1; 
    static int rem_clocked=0;
    static int rcvd_byte=0;
    static int data_rcvd=0;

	unsigned char sendbuf[2]; //up to 2 bytes will be written
    unsigned char recvbuf[2]; //2 bytes received at a time
	int recvnum; //number of bytes received
	
	//for non-blocking read
	fd_set fd = {0};
	//FD_ZERO(&fd);
	timeval tv = {0, 0};

	if (!tVBOpt.NETWORK) 
		return;

	FD_SET(ConnectSocket, &fd);
	select(1, &fd, NULL, NULL, &tv);
	//if data available, and no data waiting to be "collected"
	if ((FD_ISSET(ConnectSocket, &fd))&&(!data_rcvd)&&(!exit_flag)) {
		//should put some safety here
		recvnum = recv(ConnectSocket, (char*)recvbuf, 2, 0); 
		if (recvnum<=0) {
			//remote connection closed
			exit_flag=1; 
		} else {
			//COMCNT packet or first byte of data packet... 
			//this may cause problems if slow link causes only 
			//one of two bytes to arrive
			if (recvbuf[0]&0x80) {
				remote_comcnt=((recvbuf[0]>>6)&0x01);
				//data to follow
				if (recvbuf[0]&0x04) {
					rcvd_byte=(recvbuf[0]<<7)&0xFF;
					rem_clocked=((recvbuf[0]>>1)&0x01);
					rcvd_byte|=recvbuf[1];
					data_rcvd=1;
				}
			}
		}
	}

	//start comm
	if((reg==0)&&(tHReg.CCR&0x04)) {
		tHReg.CCR|=0x02; //set stat flag
		tHReg.CCR&=~0x04; //unset start flag
		//if master, send data
		if (!((tHReg.CCR>>4)&0x01)) {
			//can't receive data before master sends data 
			//(yet, a good way to reduce lag would be to allow slave 
			//to send before receiving master, but would need to 
			//handle data more carefully)
			data_rcvd=0; 
			//COMCNT and master data
			sendbuf[0]=(0x80|((tHReg.CCSR<<5)&0x40)|0x04|0x02|(tHReg.CDTR>>7))&0xFF; 
			sendbuf[1]=(tHReg.CDTR&0x7F)&0xFF; //rest of data
			//send the 2 bytes
			send(ConnectSocket, (char*)&sendbuf[0], 2, 0); 
			//COMCNT sent, so update last sent
			last_comcnt=((tHReg.CCSR>>1)&1); 
		}
	}

	//send new COMCNT value
	if ((reg==1)&&(((tHReg.CCSR>>1)&1)!=last_comcnt)) {
		//COMCNT
		sendbuf[0]=0x80|((tHReg.CCSR<<5)&0x40); 
		sendbuf[1]=0; //no data
		send(ConnectSocket, (char*)sendbuf, 2, 0); //send the COMCNT value
		last_comcnt=((tHReg.CCSR>>1)&1); //COMCNT sent, so update last sent
	}

	//comm in progress and data was received
	if((tHReg.CCR&0x02)&&(data_rcvd)) {
		//send data back
		if (rem_clocked) {
			sendbuf[0]=(0x80|((tHReg.CCSR<<5)&0x40)|0x04|(tHReg.CDTR>>7))&0xFF; //COMCNT and slave data
			//rest of data
			sendbuf[1]=(tHReg.CDTR&0x7F)&0xFF; 
			//send the 2 bytes
			send(ConnectSocket, (char*)&sendbuf[0], 2, 0); 
			//COMCNT sent, so update last sent
			last_comcnt=((tHReg.CCSR>>1)&1); 
			rem_clocked=0;
		}
		tHReg.CDRR=rcvd_byte;
		tHReg.CCR&=~0x02;//unset stat flag
		data_rcvd=0;
	}

	//COMCNT is open drain
	tHReg.CCSR=(tHReg.CCSR&~1)|(((tHReg.CCSR>>1)&1)&(remote_comcnt)); 
#endif
}

void link_close() {
#ifdef _WIN32
	if (!tVBOpt.NETWORK)
		return;

	shutdown(ConnectSocket, SD_BOTH);
	closesocket(ConnectSocket);
	WSACleanup();
#endif
}
