// Defines the platform specific I/O routines, keyboard, joystick, sound, etc.
#include <stdio.h>

#ifndef VBIO_H
#define VBIO_H

// include system specific declerations
#include "cp_io.h"

//defined in vb_set.h
struct VB_OPT;

// ====== I/O Initialization ======

void vb_printf(const char *_format, ...);

//Debug log, Can be turnd on and off by seting the debug log level to 10
extern int vb_log_msgLVL;
extern FILE* log_file;

#ifdef VB_DEBUGGER
void vb_log_msg(int level, const char *_format, ...);
#else
#define vb_log_msg //
#endif

void vbio_init();
void vbio_close();

int init_graphics();
int close_graphics();
	
void scr_clear();
void bmp_clear_palette();
void bmp_set_palette(VB_OPT &tVBOpt, int brtA, int brtB, int brtC);

void vb_yield();

// ====== Bitmap routines ======

// defined elseware to mach your local system
struct BITMAP;

void bmp_display(BITMAP * bmp);
void bmp_clear(BITMAP *bmp, int index);
void bmp_save(BITMAP *bmp, const char *name);
void bmp_copy(BITMAP *src, BITMAP *dest, int src_x, int src_y,
			  int dest_x, int dest_y, int width, int height);
void bmp_free(BITMAP *bmp);
BITMAP* bmp_create(int width, int height);
BITMAP* bmp_clip(BITMAP* bmp, int src_x, int src_y, int width, int height);
void bmp_rotate(BITMAP *src, BITMAP *dest, int src_x, int src_y,
			  int cx, int cy, int angle);
void bmp_printf(BITMAP *bmp, int x, int y, const char *format, ...);

// ====== Keybd Fn's ======

#define MAX_KEY   33

#define VBK_vBATT  0
//		VBK_vCID   1
#define VBK_vA     2
#define VBK_vB     3
#define VBK_vR     4
#define VBK_vL     5
#define VBK_vRR    6
#define VBK_vRU    7
#define VBK_vLR    8
#define VBK_vLL    9
#define VBK_vLD   10
#define VBK_vLU   11
#define VBK_vSTR  12
#define VBK_VSEL  13
#define VBK_RL    14
#define VBK_RD    15

#define VBK_FSD   16
#define VBK_FSU   17
#define VBK_SWP   18
#define VBK_PRN   19
#define VBK_STS   20
#define VBK_ESC   21

#define VBK_BRTU  22
#define VBK_BRTD  23
#define VBK_RBALU 24
#define VBK_RBALD 25
#define VBK_GBALU 26
#define VBK_GBALD 27
#define VBK_BBALU 28
#define VBK_BBALD 29
#define VBK_CACHE 30
#define VBK_CLR_STAT 31
#define VBK_PAUSE 32

//keyboard map
extern int VBK_DATA[MAX_KEY];

//Read the Controller
VB_HWORD handle_input();

char wait_key();
bool test_key(int key_code);
void read_line(char *buf, int buflen);
void clear_key();

#endif

