#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <stdarg.h> //Needed for the vb_printf() fn

#include "cp_io.h"
#include "vb_io.h"
#include "vb_set.h"
#include "vb_dsp.h"

//====== Local Declerations ======

// defines from allegro.h
//BITMAP * screen;
//struct RGB;
//typedef RGB PALETTE[256];

#ifndef MAX_PATH
#define MAX_PATH 512
#endif

//keep a global pall, so we dont have to clear the whole thing....
PALETTE palette;  

int VBK_DATA[MAX_KEY];

FILE *log_file  = stdout;
int vb_log_msgLVL = 10;

//====== Local helper fn's ======

void kbd_init(int key_map);
void kbd_close();
VB_HWORD kbd_read();

bool pport_init();
void pport_close();
int  pport_inport(int base);
void pport_outport(int base, int data);
VB_HWORD pport_read();

void joy_init(int joy_map);
VB_HWORD joy_read();
void joy_close();

void lib_init();
void lib_close();

extern volatile int input_read;

//================================

void vb_printf(const char *_format, ...) {
	va_list argp;
	va_start(argp,_format);
	vprintf(_format,argp);
	va_end(argp);
    //fflush(stdout);fflush(stderr);
    fflush(stdout);
}

#ifdef VB_DEBUGGER
void vb_log_msg(int level, const char *_format, ...) {
	va_list argp;
	if(level>=vb_log_msgLVL) {
		va_start(argp,_format);
		vfprintf(log_file,_format,argp);
		va_end(argp);
	}
}
#endif

void vbio_init() {
#ifdef VB_DEBUGGER
    if(!tVBOpt.STDOUT) {
        if((log_file = fopen("v810_err.txt", "wt")) == NULL) {
            vb_printf("could not open error log file...\n");
            log_file = stdout;
        }
        vb_log_msg(10,"\n%s\n", VB_VER_STR_1);
        vb_log_msg(10,"\n  %s\n\n",VB_VER_STR_2);
    }
#endif

	lib_init();
	//initialize cpio libs, (keyboard mappings, etc)
	kbd_init(tVBOpt.KBD_MAP);

	//disable parallel port if driver failed to load
	if(!pport_init()) {
		tVBOpt.PPORT = -1;
		vb_log_msg(10,"\nfailed to load paralel port driver");
	}

	joy_init(tVBOpt.JOY_MAP);
}

void vbio_close() {
	kbd_close();
	pport_close();
	joy_close();
	lib_close();

#ifdef VB_DEBUGGER
    fclose(log_file);
#endif
}

VB_HWORD handle_input() {
	static VB_HWORD ret = 0;

	//only read 60 times a second...
	if(!input_read)
		return ret;

	ret  = kbd_read();
	if(0<tVBOpt.JOY_MAP)
		ret |= joy_read();
	if(0<tVBOpt.PPORT)
		ret |= pport_read()&0xFFFE;

	input_read = 0;
	return ret;
}

/*
//frame skip stuff
if((frm_cnt > (MAX_FPS/INTERVALS))) {
	if(!tVBOpt.NO_THRTL) //only throttle if nessisary
		while(clock() < (start_time+CLOCK_TICKS))
			vb_yield();

	start_time = clock();
	frm_cnt = 0;

	if(++tCount == INTERVALS) {
		fps = MAX_FPS/(((float)(clock()-tClock))/(float)CLOCKS_PER_SEC);
		tCount = 0;
		tClock = start_time;
	}
}
*/

///////////////////////////////////////////////////////////
// Read data from a VB controller attached to the paralel port
// this is probably very intel specific, but for now it lives in 
// vb_io and not cp_io

#define VBPAD_POWER  248
#define VBPAD_CLOCK    1
#define VBPAD_LATCH    2
#define VBPAD_BUTTONS 16

VB_HWORD pport_read() {
	//return if no pport joystick
	if((tVBOpt.PPORT < 1) || (tVBOpt.PPORT > 4))
		return 0;

	static int pp_base[] = {0x378,0x278,0x3b8,0x3bc};
	int base = pp_base[tVBOpt.PPORT-1];

	int buttondata = 0;
	int i, tmp;

	// read bits from the VBpad
	for (i = 0; i < VBPAD_BUTTONS; i++) {
		//init controll lines high
		pport_outport(base, VBPAD_POWER+VBPAD_CLOCK);

		if (i == 0) //trigger latch to init controller
			pport_outport(base, VBPAD_POWER + VBPAD_LATCH + VBPAD_CLOCK);
		else //toggle clock to cycle next bit
			pport_outport(base, VBPAD_POWER + VBPAD_CLOCK);

		//data stable on falling edge of clock
		pport_outport(base, VBPAD_POWER);

		//data is inverted on paralel port...
		tmp = !((pport_inport(base + 1)&0x040)>>6);
		buttondata |= (tmp<<(15-i));
	}
	//clear controll lines, high
	pport_outport(base, VBPAD_POWER+VBPAD_CLOCK);
	return buttondata;
}


////////////////////////////////////////////////////////////////////
// platform specific I/O fns

// timmer to controll input 
volatile int input_read = 0;

void set_input_read() { input_read = 1; }
END_OF_FUNCTION(set_input_read)

void lib_init() {
	allegro_init();

	LOCK_VARIABLE(input_read);
	LOCK_FUNCTION(set_input_read);

	install_int_ex(set_input_read, BPS_TO_TIMER(60));
}

void lib_close() {
	allegro_exit();
}

void kbd_init(int key_map) {

	install_keyboard(); 
	clear_key();

	VBK_DATA[VBK_FSD]  = KEY_MINUS; 
	VBK_DATA[VBK_FSU]  = KEY_EQUALS;
	VBK_DATA[VBK_SWP]  = KEY_CLOSEBRACE;
	VBK_DATA[VBK_PRN]  = KEY_P;
	VBK_DATA[VBK_STS]  = KEY_0;
	VBK_DATA[VBK_PAUSE]  = KEY_TILDE;
	VBK_DATA[VBK_ESC]  = KEY_ESC;

	VBK_DATA[VBK_BRTU]   = KEY_2;
	VBK_DATA[VBK_BRTD]   = KEY_1;
	VBK_DATA[VBK_RBALU]  = KEY_4;
	VBK_DATA[VBK_RBALD]  = KEY_3;
	VBK_DATA[VBK_GBALU]  = KEY_6;
	VBK_DATA[VBK_GBALD]  = KEY_5;
	VBK_DATA[VBK_BBALU]  = KEY_8;
	VBK_DATA[VBK_BBALD]  = KEY_7;

	VBK_DATA[VBK_CACHE]  = KEY_BACKSLASH;
	VBK_DATA[VBK_CLR_STAT]  = KEY_SLASH;

	if(key_map!=0) {
		VBK_DATA[VBK_vBATT]= KEY_W;
		VBK_DATA[VBK_vA]   = KEY_M;
		VBK_DATA[VBK_vB]   = KEY_N;
		VBK_DATA[VBK_vR]   = KEY_H;
		VBK_DATA[VBK_vL]   = KEY_G;
		VBK_DATA[VBK_vRR]  = KEY_L;
		VBK_DATA[VBK_vRU]  = KEY_I;
		VBK_DATA[VBK_vLR]  = KEY_F;
		VBK_DATA[VBK_vLL]  = KEY_S;
		VBK_DATA[VBK_vLD]  = KEY_D;
		VBK_DATA[VBK_vLU]  = KEY_E;
		VBK_DATA[VBK_vSTR] = KEY_B;
		VBK_DATA[VBK_VSEL] = KEY_V;
		VBK_DATA[VBK_RL]   = KEY_J;
		VBK_DATA[VBK_RD]   = KEY_K;
	} else {
		VBK_DATA[VBK_vBATT]= KEY_W;
		VBK_DATA[VBK_vA]   = KEY_Z;
		VBK_DATA[VBK_vB]   = KEY_X;
		VBK_DATA[VBK_vR]   = KEY_S;
		VBK_DATA[VBK_vL]   = KEY_A;
		VBK_DATA[VBK_vRU]  = KEY_F;
		VBK_DATA[VBK_vRR]  = KEY_B;
		VBK_DATA[VBK_vLR]  = KEY_RIGHT;
		VBK_DATA[VBK_vLL]  = KEY_LEFT;
		VBK_DATA[VBK_vLD]  = KEY_DOWN;
		VBK_DATA[VBK_vLU]  = KEY_UP;
		VBK_DATA[VBK_vSTR] = KEY_Q;
		VBK_DATA[VBK_VSEL] = KEY_W;
		VBK_DATA[VBK_RL]   = KEY_C;
		VBK_DATA[VBK_RD]   = KEY_V;
	}
}

void kbd_close() {
	clear_key();
	remove_keyboard();
}

bool test_key(int key_code) {
	if((key_code<0) || (key_code>MAX_KEY))
		return false;

	return (0 != key[VBK_DATA[key_code]]);
}

char wait_key() {
	char ret;
	ret = readkey() & 0xFF;
	clear_key();
	return ret;
}

VB_HWORD kbd_read() {
	
	//delay so keys don't run away
	static unsigned int FS_DELAY = 0;

	if(!FS_DELAY) {
		if(key[VBK_DATA[VBK_FSD]]   || key[VBK_DATA[VBK_FSU]]   ||
		   key[VBK_DATA[VBK_BRTD]]  || key[VBK_DATA[VBK_BRTU]]  ||
		   key[VBK_DATA[VBK_RBALD]] || key[VBK_DATA[VBK_RBALU]] ||
		   key[VBK_DATA[VBK_GBALD]] || key[VBK_DATA[VBK_GBALU]] ||
		   key[VBK_DATA[VBK_BBALD]] || key[VBK_DATA[VBK_BBALU]] ||
		   key[VBK_DATA[VBK_SWP]]   || key[VBK_DATA[VBK_STS]])
			FS_DELAY = 5;

		//Handle Frame Skip
		if(key[VBK_DATA[VBK_FSD]]) 
			tVBOpt.FRMSKIP -= (tVBOpt.FRMSKIP==0)?0:1;
		if(key[VBK_DATA[VBK_FSU]])
			tVBOpt.FRMSKIP += (tVBOpt.FRMSKIP>15)?0:1;

		//red
		if(key[VBK_DATA[VBK_RBALD]]) 
			tVBOpt.R_BAL -= (tVBOpt.R_BAL<=0.2)?0:0.1;
		if(key[VBK_DATA[VBK_RBALU]])
			tVBOpt.R_BAL += (tVBOpt.R_BAL>=3.0)?0:0.1;
		//green
		if(key[VBK_DATA[VBK_GBALD]]) 
			tVBOpt.G_BAL -= (tVBOpt.G_BAL<=0.2)?0:0.1;
		if(key[VBK_DATA[VBK_GBALU]])
			tVBOpt.G_BAL += (tVBOpt.G_BAL>=3.0)?0:0.1;
		//blue
		if(key[VBK_DATA[VBK_BBALD]]) 
			tVBOpt.B_BAL -= (tVBOpt.B_BAL<=0.2)?0:0.1;
		if(key[VBK_DATA[VBK_BBALU]])
			tVBOpt.B_BAL += (tVBOpt.B_BAL>=3.0)?0:0.1;
		//bright
		if(key[VBK_DATA[VBK_BRTD]]) 
			tVBOpt.BFACTOR -= (tVBOpt.BFACTOR<=0.2)?0:0.1;
		if(key[VBK_DATA[VBK_BRTU]])
			tVBOpt.BFACTOR += (tVBOpt.BFACTOR>=3.0)?0:0.1;

		//Flip 3D display
		if(key[VBK_DATA[VBK_SWP]])
			tVBOpt.DSPSWAP = (tVBOpt.DSPSWAP)?0:1; 

		//Turn on status
		if(key[VBK_DATA[VBK_STS]])
			tVBOpt.STATUS = (tVBOpt.STATUS)?0:1; 

		//invalidate display cache
		clearCache();
	} else {
		FS_DELAY--;
	}

    int t1 = 0;
    if(key[VBK_DATA[VBK_vBATT]]) t1=t1|0x0001;     // Batery Low
    if(key[VBK_DATA[VBK_vA]])    t1=t1|0x0004;
    if(key[VBK_DATA[VBK_vB]])    t1=t1|0x0008;
    if(key[VBK_DATA[VBK_vR]])    t1=t1|0x0010;
    if(key[VBK_DATA[VBK_vL]])    t1=t1|0x0020;
    if(key[VBK_DATA[VBK_vRU]])   t1=t1|0x0040;
    if(key[VBK_DATA[VBK_vRR]])   t1=t1|0x0080;
    if(key[VBK_DATA[VBK_vLR]])   t1=t1|0x0100;
    if(key[VBK_DATA[VBK_vLL]])   t1=t1|0x0200;
    if(key[VBK_DATA[VBK_vLD]])   t1=t1|0x0400;
    if(key[VBK_DATA[VBK_vLU]])   t1=t1|0x0800;
    if(key[VBK_DATA[VBK_vSTR]])  t1=t1|0x1000;
    if(key[VBK_DATA[VBK_VSEL]])  t1=t1|0x2000;
    if(key[VBK_DATA[VBK_RL]])    t1=t1|0x4000;
    if(key[VBK_DATA[VBK_RD]])    t1=t1|0x8000;
    t1=t1|0x0002;                   // Always set bit1, ctrl ID
    return t1;
}

////////////////////////////////////
//Dynamic DLL stuff, what a mess

/* ----Prototypes of Inp and Outp--- */
//short _stdcall Inp32(short PortAddress);
//void _stdcall Out32(short PortAddress, short data);

#ifdef _WIN32
HINSTANCE ppt_lib = NULL;
typedef short (WINAPI *LPInp32)(short);
typedef void  (WINAPI *LPOut32)(short, short);

LPInp32 Inp32 = NULL;
LPOut32 Out32 = NULL;
#endif //_WIN32

bool pport_init() {
#ifdef _WIN32
	//load dll
	ppt_lib = LoadLibrary("InpOut32.dll");

	if (NULL == ppt_lib)
        return false;

	Inp32 = (LPInp32) GetProcAddress(ppt_lib,"Inp32");
	if(NULL == Inp32)
		return false;
	Out32 = (LPOut32) GetProcAddress(ppt_lib,"Out32");
	if(NULL == Out32)
		return false;
#endif //_WIN32
	return true;
}
void pport_close() {
#ifdef _WIN32
	if(NULL != ppt_lib)
		FreeLibrary(ppt_lib);
	ppt_lib = NULL;
	Inp32 = NULL;
	Out32 = NULL;
#endif //_WIN32
}

int  pport_inport(int base) {
#ifdef _WIN32
	if(NULL == Inp32) return 0;
	return (int)Inp32((short)base);
#else
	return 0;
#endif //_WIN32
}
void pport_outport(int base, int data) {
#ifdef _WIN32
	if(NULL == Out32) return;
	Out32((short)base, short(data));
#endif //_WIN32
}

////////////////////////////////////

void joy_init(int joy_map) {
#ifdef _WIN32
	//install joyticks
	if(0 != install_joystick(JOY_TYPE_AUTODETECT)) {
		tVBOpt.JOY_MAP = 0;
		return;
	}

	//quit if no joysticks
	if(0 != poll_joystick()) {
		tVBOpt.JOY_MAP = 0;
		return;
	}

	//quit if not enough sticks
	if(joy[0].num_sticks<2) {
		tVBOpt.JOY_MAP = 0;
		return;
	}

	//quit if not enough buttons
	if(joy[0].num_buttons<6) {
		tVBOpt.JOY_MAP = 0;
		return;
	}
#endif //_WIN32
}

VB_HWORD joy_read() {
	int ret = 0;

#ifdef _WIN32
	//query sticks
	if(0 != poll_joystick())
		return 0;

	if(joy[0].button[0].b)		ret |= 0x0004; //a
	if(joy[0].button[1].b)		ret |= 0x0008; //b
	if(joy[0].button[6].b)		ret |= 0x0010; //r
	if(joy[0].button[7].b)		ret |= 0x0020; //l
	if(joy[0].button[3].b)		ret |= 0x1000; //start
	if(joy[0].button[4].b)		ret |= 0x2000; //select

	if(joy[0].stick[0].axis[0].d2)	ret |= 0x0100; //left-right
	if(joy[0].stick[0].axis[0].d1)	ret |= 0x0200; //left-left
	if(joy[0].stick[0].axis[1].d2)	ret |= 0x0400; //left-down
	if(joy[0].stick[0].axis[1].d1)	ret |= 0x0800; //left-up
	
	if(joy[0].stick[2].axis[0].d2)	ret |= 0x0100; //left-right
	if(joy[0].stick[2].axis[0].d1)	ret |= 0x0200; //left-left
	if(joy[0].stick[2].axis[1].d2)	ret |= 0x0400; //left-down
	if(joy[0].stick[2].axis[1].d1)	ret |= 0x0800; //left-up

	if(joy[0].stick[1].axis[1].d1)	ret |= 0x0040; //right-up
	if(joy[0].stick[1].axis[0].d2)	ret |= 0x0080; //right-right
	if(joy[0].stick[1].axis[0].d1)	ret |= 0x4000; //right-left
	if(joy[0].stick[1].axis[1].d2)	ret |= 0x8000; //roght-down

	ret |= 0x0002; // Always set bit1, ctrl ID
#endif //_WIN32
	return ret;
}

void joy_close() {
}

////////////////////////////////////

void vbClose() {
	exit_flag = 1;
}

int init_graphics() {
	int tmp, tmp_x, tmp_y;
	int aDspM = GFX_AUTODETECT_WINDOWED;

#ifdef DJGPP
	//dos has no 'window' mode, force to full screen
	if(!tVBOpt.FULLSCR) {
		tVBOpt.FULLSCR = 1;
		tVBOpt.SCR_X = 640;
		tVBOpt.SCR_Y = 480;
	}
#endif //DJGPP

	if(tVBOpt.FULLSCR) {
		aDspM = GFX_AUTODETECT_FULLSCREEN;
	} else { //if windowed 
		aDspM = GFX_AUTODETECT_WINDOWED;

		//test for desktop resolution
		get_desktop_resolution(&tmp_x, &tmp_y);

		//if debug mode, force a 512x512 screen, clean this up
		if(tVBOpt.DEBUG) {
			tVBOpt.VB_X = 512;
			tVBOpt.VB_Y = 512;
		}

		//make shure scaled window is smaller thain desktop
		tmp = tmp_x/(tVBOpt.VB_X*tVBOpt.HSTRETCH);
		if(tmp<tVBOpt.SCLSCR) tVBOpt.SCLSCR = tmp;
		tmp = tmp_y/tVBOpt.VB_Y;
		if(tmp<tVBOpt.SCLSCR) tVBOpt.SCLSCR = tmp;

		//check for stupidity
		if(tVBOpt.SCLSCR<1) tVBOpt.SCLSCR = 1;

		//Set screen size
		tVBOpt.SCR_X = tVBOpt.VB_X*tVBOpt.SCLSCR*tVBOpt.HSTRETCH;
		tVBOpt.SCR_Y = tVBOpt.VB_Y*tVBOpt.SCLSCR;
	}

	if(set_gfx_mode(aDspM, tVBOpt.SCR_X, tVBOpt.SCR_Y, 0, 0)<0) {
        	vb_printf("Screen faild to initialize, exiting\n");
        	return(false);
    }
	tVBOpt.SCR_X = SCREEN_W;
	tVBOpt.SCR_Y = SCREEN_H;

	set_display_switch_mode(SWITCH_BACKGROUND);
	set_window_title(VB_VER_STR_1);
	set_close_button_callback(vbClose);
	
	return true;
}

int close_graphics() {
	set_gfx_mode(GFX_TEXT,0,0,0,0);
	return true;
}

///////////////////////////////////////////////////////
// Bitmap routine

//Blit finished screen to display, and scale
//****FixMe, precompute all of this somewhere else
void bmp_display(BITMAP * bmp) {
	int dim_x, dim_y, off_x, off_y;

	//if scaling to full screen
	if(tVBOpt.FULLSCR && (0 == tVBOpt.SCLSCR)) {

		//adjust aspect ratio (cleanup, fix for wide aspect ratios)
		if(((float)tVBOpt.SCR_X/(float)bmp->w) < ((float)tVBOpt.SCR_Y/(float)bmp->h)) {
			dim_x = tVBOpt.SCR_X;
			off_x = 0;

			dim_y = (dim_x*bmp->h)/bmp->w;
			off_y = (tVBOpt.SCR_Y - dim_y) >> 1;
		} else {
			dim_y = tVBOpt.SCR_Y;
			off_y = 0;

			dim_x = (dim_y*bmp->w)/bmp->h;
			off_x = (tVBOpt.SCR_X - dim_x) >> 1;
		}
	} else {
		//scale
		dim_x = bmp->w * tVBOpt.SCLSCR * tVBOpt.HSTRETCH;
		dim_y = bmp->h * tVBOpt.SCLSCR;

		//if not a window, center
		if(tVBOpt.FULLSCR) {
			off_x = (tVBOpt.SCR_X - dim_x) >> 1;
			off_y = (tVBOpt.SCR_Y - dim_y) >> 1;
		} else {
			off_x = off_y = 0;
		}
	}

	stretch_blit(bmp,screen,
		0,0,bmp->w,bmp->h,off_x, off_y,dim_x, dim_y);
}

void bmp_clear_palette() {
	int i;

    //Clear our palette, to a default collor...
    for(i=0; i<256; i++) {
        palette[i].r = 0; 
        palette[i].g = 0;
        palette[i].b = 0;
    }
    //Add the display Color (Text Color)
    palette[255].r = 63; 
    palette[255].g = 63;
    palette[255].b = 63;
}

void bmp_set_palette(VB_OPT &tVBOpt, int brtA, int brtB, int brtC) {
    int i,L,R;
    int tPal[] = {0, 0, 21, 42, 63};

	tPal[2] = (int)(brtA);
	tPal[3] = (int)(brtB);
	tPal[4] = (int)(brtC);

	//***FixMe, clean this up, make an assignment with limits: x = dtset(val,min,max)
	if(tPal[4]>63)
		tPal[4]=63;
	if(tPal[3]>63)
		tPal[3]=63;
	if(tPal[2]>63)
		tPal[2]=63;

    //Setup palette
    if (tVBOpt.DSPMODE == dm_AFFINE) {//Red/Blue Palette...
		//make a gradiant of left and right eye palettes mixed together
        for(L=0;L<4;L++) {
            for(R=0;R<4;R++) {
                //tpal goes from 0-4, with 0 and 1 being black (What a Cluge)
                if(tVBOpt.PALMODE == pal_RG) {			//Red_Green Palette
					palette[L+(R*4)+8].r = (unsigned char)(tPal[L+1]*tVBOpt.R_BAL);
                    palette[L+(R*4)+8].g = (unsigned char)(tPal[R+1]*tVBOpt.G_BAL);
                    palette[L+(R*4)+8].b = 0;
                } else if(tVBOpt.PALMODE == pal_RC) {	//Red_Cyan Palette
					palette[L+(R*4)+8].r = (unsigned char)(tPal[L+1]*tVBOpt.R_BAL);
                    palette[L+(R*4)+8].g = (unsigned char)(tPal[R+1]*tVBOpt.G_BAL);
                    palette[L+(R*4)+8].b = (unsigned char)(tPal[R+1]*tVBOpt.B_BAL);
                } else if(tVBOpt.PALMODE == pal_YB) {	//Yellow_Blue Palette
					palette[L+(R*4)+8].r = (unsigned char)(tPal[L+1]*tVBOpt.R_BAL);
                    palette[L+(R*4)+8].g = (unsigned char)(tPal[L+1]*tVBOpt.G_BAL);
                    palette[L+(R*4)+8].b = (unsigned char)(tPal[R+1]*tVBOpt.B_BAL);
                } else if(tVBOpt.PALMODE == pal_MG) {	//Magenta_Green Palette
					palette[L+(R*4)+8].r = (unsigned char)(tPal[L+1]*tVBOpt.R_BAL);
                    palette[L+(R*4)+8].g = (unsigned char)(tPal[R+1]*tVBOpt.G_BAL);
                    palette[L+(R*4)+8].b = (unsigned char)(tPal[L+1]*tVBOpt.B_BAL);
                } else if(tVBOpt.PALMODE == pal_BG) {	//Blue_Green Palette
					palette[L+(R*4)+8].r = 0;
                    palette[L+(R*4)+8].g = (unsigned char)(tPal[L+1]*tVBOpt.G_BAL);
                    palette[L+(R*4)+8].b = (unsigned char)(tPal[R+1]*tVBOpt.B_BAL);
                } else {								//Red_Blue Palette
					palette[L+(R*4)+8].r = (unsigned char)(tPal[L+1]*tVBOpt.R_BAL);
                    palette[L+(R*4)+8].g = 0;
                    palette[L+(R*4)+8].b = (unsigned char)(tPal[R+1]*tVBOpt.B_BAL);
                }
            }
        }
    } else { // standard palette
        if(tVBOpt.PALMODE == pal_RED) { //Red Palette
            for(i=0;i<5;i++) {
                palette[i].r = tPal[i];
                palette[i].g = 0;
                palette[i].b = 0;
            }
        } else { //Standard Palette
            for(i=0;i<5;i++) {
                palette[i].r = tPal[i];
                palette[i].g = tPal[i];
                palette[i].b = tPal[i];
            }
        }
    }// end Standard palette

	set_palette(palette);
}

void vb_yield() { rest(0); }

void clear_key() { clear_keybuf(); }

void read_line(char *buf, int buflen) {
	int i=0;
	char a;

	while(true) {
		a = readkey();

		if((a>>8)== KEY_ENTER)
			break;
		buf[i++]=(a & 0xFF);

		if(i >= (buflen-1))
			break;
	}
	clear_key();
	buf[i]='\0';
}

//****Warning only supports a maximum of 512 byte strings
void bmp_printf(BITMAP *bmp, int x, int y, const char *format, ...) {
	char str[512];
	va_list argp;
	va_start(argp,format);
	//vsnprintf(str,512,format,argp);
	vsprintf(str,format,argp);
	str[511]='\0';
	textprintf_ex(bmp, font, x, y, 255, 0, "%s" ,str);
	va_end(argp);
}

void bmp_clear(BITMAP *bmp, int index) {
	clear_to_color(bmp,index);
}
void scr_clear() {
	bmp_clear(screen,0);
}

void bmp_save(BITMAP *bmp, const char *name) {
	PALETTE pal;
    char buffer [MAX_PATH];
	char tpath[MAX_PATH];
	FILE * fptr;
	int pCnt = 0;

    get_palette(pal);
	strcpy(tpath,tVBOpt.ROM_NAME);
    sprintf(buffer, "%s%02d.bmp",name,pCnt);
	replace_filename(tpath, tpath,  buffer, MAX_PATH);


	//while file exists, try again...
	while(NULL != (fptr = fopen(tpath,"r"))) {
		fclose(fptr);
		pCnt++;
	    sprintf(buffer, "%s%02d.bmp",name,pCnt); 
		replace_filename(tpath, tpath,  buffer, MAX_PATH);
	}

    save_bmp(tpath,bmp,pal);
}

void bmp_copy(BITMAP *src, BITMAP *dest, int src_x, int src_y,
			  int dest_x, int dest_y, int width, int height) {
	masked_blit(src,dest,src_x,src_y,dest_x,dest_y,width,height);
}

void bmp_rotate(BITMAP *src, BITMAP *dest, int src_x, int src_y,
			  int cx, int cy, int angle) {
	pivot_sprite(src,dest, src_x,src_y,cx,cy, itofix(angle));
}

BITMAP* bmp_create(int width, int height) {
	return create_bitmap(width, height);
}

BITMAP* bmp_clip(BITMAP* bmp, int src_x, int src_y, int width, int height) {
		return create_sub_bitmap(bmp, src_x, src_y, width, height);
}

void bmp_free(BITMAP *bmp) {
	destroy_bitmap(bmp);
}

