/*********************************
* cp_io.h
*
* Cross Platform I/O wrapper for keyboard/joystick/mouse,
* Sound, and video interfaces
*
**********************************/
//Windows Heap Debugging
//#define _CRTDBG_MAP_ALLOC
//#include <stdlib.h>
//#include <crtdbg.h>

// Exclude rarely-used stuff from Windows headers
#define WIN32_LEAN_AND_MEAN

#ifdef DBG_PRINT
#define _CONSOLE
#define ALLEGRO_USE_CONSOLE
#define ALLEGRO_NO_MAGIC_MAIN
#endif

#include <allegro.h>
#include <winalleg.h>

#ifndef WORD
#define WORD  unsigned long    //Full 32bit
#define BYTE  unsigned char    //8bit
#endif

#ifndef HWORD
#define HWORD unsigned short   //16bit
#endif

#ifndef INT64
#define INT64		_int64 //64 bit int
#define INT64U		unsigned _int64 //64 bit Unsigned
#endif

#define VB_INLINE	__inline

//64 bit constants are not cross platform compatible
#define sign_32(num) (((num) & 0x80000000) ? (INT64)((num)|0xFFFFFFFF00000000) : (num))

