#ifndef VB_SET_H_
#define VB_SET_H_


#define dm_NORMAL		0
#define dm_AFFINE		1 //Red/Blue glasses
#define dm_INTERLACED	2
#define dm_OVRUNDR		3
#define dm_SIDESIDE		4
#define dm_CYBERSCOPE	5

#define pal_NORMAL	0
#define pal_RED		1
#define pal_RB		2
#define pal_RG		3
#define pal_RC		4
#define pal_YB		5
#define pal_MG		6
#define pal_BG		7


enum dsp_var {vbFrame=0,vb320,vb640,vb800,vb1024,vb1280,vb1400,vb1600};

//Global Options list
typedef struct VB_OPT {
        int     FRMSKIP;  //Frame Skip of cource
        int     SCLSCR;   //Screen scaling (1x-6x)
		int		HSTRETCH; //Double the width of the display
        int     DSPMODE;  //Normal, 3D, etc
        int     DSPSWAP;  //Swap 3D Efect, 0 normal, 1 swap
        int     PALMODE;  //Select A Pallet Type:0-normal, 1-red,etc...
        int     DEBUG;    //Releas vs Debug
        int     STDOUT;   //File vs Screen (debug)
        float   BFACTOR;  //User adjustible brightness
        float   R_BAL;	  //Balance brightness of left/right screen
        float   G_BAL;	  
        float   B_BAL;	  
        int     SCR_X;    //Physical Display Dimentions
        int     SCR_Y;
		int     VB_X;     //virtual display dimentions
		int     VB_Y;
        int     LTIMMER;  //Force a 1ms timmer.
        int     VFHACK;	  //force a display interupt.
        int     DISASM;   //Interactive dissasembly of all executed instructions...
        dsp_var SCR_MODE; //0-frame, 1-320x200, 2-640x480
        char   *ROM_NAME; //Path\Name of game to open
        char   *PROG_NAME;//Path\Name of program
		int     KBD_MAP;  //keyboard mapping
		int     NO_THRTL; //turn off speed throttling
		int     STATUS;   //turn on status line (fps, etc)
		int     PPORT;    //turns on paralel port controller
		int     JOY_MAP;  //joystick mapping
		int		MORE_RAM; //increase avalible ram
} VB_OPT;

int setOptions(int argc, char *argv[]);

void dump_settings();

extern VB_OPT         tVBOpt;


#endif


