#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "vb_set.h"
#include "vb_vbtD.h"

#define CL_DISP			"-display"
#define CL_DISP_FRAME	  "frame"
#define CL_DISP_320		  "320"  //320x200
#define CL_DISP_640		  "640"  //640x480
#define CL_DISP_800		  "800"  //800x600
#define CL_DISP_1024	  "1024" //1024x768
#define CL_DISP_1280	  "1280" //1280x1024
#define CL_DISP_1400	  "1400" //1400x1050
#define CL_DISP_1600	  "1600" //1600x1200


#define CL_DSPMODE		"-dspmode"
#define CL_DSPMODE_NORM	  "normal"
#define CL_DSPMODE_AFFINE "affine"
#define CL_DSPMODE_INT	  "interlace"
#define CL_DSPMODE_OV	  "over_under"
#define CL_DSPMODE_SS	  "side"
#define CL_DSPMODE_CSCOPE "cscope"

#define CL_FRMSKP		"-frmskp" 

#define CL_PALLET		"-pallet"
#define CL_PALLET_NORM	  "normal"	//Gray
#define CL_PALLET_RED	  "red"		//Red
#define CL_PALLET_RB	  "rb"		//Red/Blue
#define CL_PALLET_RG	  "rg"		//Red/Green
#define CL_PALLET_RC	  "rc"		//Red/Cyan
#define CL_PALLET_YB	  "yb"		//Yellow/Blue
#define CL_PALLET_MG	  "mg"		//Magenta/Green
#define CL_PALLET_BG	  "bg"		//Blue/Green

#define CL_BRTNES		"-brite"
#define CL_BALANCE		"-balance"
#define CL_FLIP			"-flip"
#define CL_LTIMMER		"-ltimmer"
#define CL_VFHACK		"-vfhack"

#define CL_DEBUG		"-debug"
#define CL_STDOUT		"-stdout"
#define CL_DISASM		"-disasm"

#define CL_ALTKBD		"-altkbd" 
#define CL_NOTHRTL		"-nothrtl" 
#define CL_STATUS		"-status" 
#define CL_PPORT		"-pport"
#define CL_JOY			"-joy"

#define CL_SCLSCR		"-sclscr"
#define CL_HSTRETCH		"-hstretch"

#define CL_MORE_RAM		"-more_ram"

#define CL_HELP1		"-?"
#define CL_HELP2		"-help"


VB_OPT					tVBOpt;


int setOptions(int argc, char *argv[]) {
   int tmp=-1;
   int done = 0;
   int vIndex = 2;
   
   //Set up the Defaults
   tVBOpt.FRMSKIP  = 0;
   tVBOpt.SCLSCR   = 0;
   tVBOpt.HSTRETCH = 1;
   tVBOpt.DSPMODE  = dm_NORMAL;
   tVBOpt.DSPSWAP  = 0;
   tVBOpt.PALMODE  = pal_NORMAL;
   tVBOpt.DEBUG    = 0;
   tVBOpt.STDOUT   = 0;
   tVBOpt.BFACTOR  = 1.0;
   tVBOpt.R_BAL    = 1.0;
   tVBOpt.G_BAL    = 1.0;
   tVBOpt.B_BAL    = 1.0;
   tVBOpt.SCR_X    = 640;
   tVBOpt.SCR_Y    = 480;
   tVBOpt.VB_X     = 384;
   tVBOpt.VB_Y     = 224;
   tVBOpt.SCR_MODE = vbFrame;
   tVBOpt.LTIMMER  = 0;
   tVBOpt.VFHACK   = 0;
   tVBOpt.DISASM   = 0;
   tVBOpt.KBD_MAP  = 0;
   tVBOpt.NO_THRTL = 0;
   tVBOpt.STATUS   = 0;
   tVBOpt.JOY_MAP  = 0;
   tVBOpt.PPORT    = 0;
   tVBOpt.MORE_RAM = 0;

   if ((argc < 2)||(strcmp(argv[1], CL_HELP1) == 0)||(strcmp(argv[1], CL_HELP2) == 0)) {
      printf(" Usage: reality_boy <rom_name.vb> [-options]\n");
      printf(" Options: \n");
      printf("  -display (frame, 320, 640, 800, 1024) \n");
      printf("  -dspmode (normal, red_blue, interlace, over_under, side, cscope)\n");
      printf("  -frmskp (0-9)\n");
      printf("  -pallet (normal, red, rb, rg, rbg)\n");
      //printf("  -brite (0-127)\n");
	  printf("  -sclscr (0-4)\n");
	  printf("  -hstretch\n");
      printf("  -flip\n");
      printf("  -altkbd\n");
      printf("  -ltimmer\n");
      printf("  -vfhack\n");
	  printf("  -nothrtl\n");
	  printf("  -status\n");
	  printf("  -pport (0-2)\n");
	  printf("  -joy\n");
	  printf("  -more_ram\n");

#ifdef DBG_PRINT
      printf("  -debug\n");
      printf("    -disasm\n");
      printf("    -stdout\n");
#endif
      return 0; //fail, quit program
   }

   tVBOpt.PROG_NAME = argv[0];
   tVBOpt.ROM_NAME  = argv[1];

   //Break if we have no optional params...
   //***FixMe, insert tolower() so we are not case sensitive
   if(argc <= 2) done = 1;

   while(!done) {

      if (strcmp(argv[vIndex], CL_DISP) == 0) {
         if (strcmp(argv[vIndex+1], CL_DISP_FRAME) == 0) {
            tVBOpt.SCR_MODE = vbFrame; //Vesa2
            tVBOpt.SCR_X   = 640;      //place holder, desktop resolution is set in init_graphics()
            tVBOpt.SCR_Y   = 480;
         } else if (strcmp(argv[vIndex+1], CL_DISP_320) == 0) {
            tVBOpt.SCR_MODE = vb320; //VGA
            tVBOpt.SCR_X   = 320;
            tVBOpt.SCR_Y   = 200;
         } else if (strcmp(argv[vIndex+1], CL_DISP_640) == 0) {
            tVBOpt.SCR_MODE = vb640; //Vesa1
            tVBOpt.SCR_X   = 640;
            tVBOpt.SCR_Y   = 480;
         } else if (strcmp(argv[vIndex+1], CL_DISP_800) == 0) {
            tVBOpt.SCR_MODE = vb800; //Vesa1
            tVBOpt.SCR_X   = 800;
            tVBOpt.SCR_Y   = 600;
         } else if (strcmp(argv[vIndex+1], CL_DISP_1024) == 0) {
            tVBOpt.SCR_MODE = vb1024; //Vesa1
            tVBOpt.SCR_X   = 1024;
            tVBOpt.SCR_Y   = 768;
         } else if (strcmp(argv[vIndex+1], CL_DISP_1280) == 0) {
            tVBOpt.SCR_MODE = vb1280; //Vesa1
            tVBOpt.SCR_X   = 1280;
            tVBOpt.SCR_Y   = 1024;
         } else if (strcmp(argv[vIndex+1], CL_DISP_1400) == 0) {
            tVBOpt.SCR_MODE = vb1400; //Vesa1
            tVBOpt.SCR_X   = 1400;
            tVBOpt.SCR_Y   = 1050;
         } else if (strcmp(argv[vIndex+1], CL_DISP_1600) == 0) {
            tVBOpt.SCR_MODE = vb1600; //Vesa1
            tVBOpt.SCR_X   = 1600;
            tVBOpt.SCR_Y   = 1200;
         }
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_DSPMODE) == 0){
         if (strcmp(argv[vIndex+1], CL_DSPMODE_NORM) == 0) {
            tVBOpt.DSPMODE = dm_NORMAL;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_AFFINE) == 0) {
            tVBOpt.DSPMODE = dm_AFFINE;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_INT) == 0) {
            tVBOpt.DSPMODE = dm_INTERLACED;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_OV) == 0) {
            tVBOpt.DSPMODE = dm_OVRUNDR;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_SS) == 0) {
            tVBOpt.DSPMODE = dm_SIDESIDE;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_CSCOPE) == 0) {
            tVBOpt.DSPMODE = dm_CYBERSCOPE;
         }
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_PALLET) == 0){
         if (strcmp(argv[vIndex+1], CL_PALLET_NORM) == 0) {
            tVBOpt.PALMODE = pal_NORMAL;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RED) == 0) {
            tVBOpt.PALMODE = pal_RED;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RB) == 0) {
            tVBOpt.PALMODE = pal_RB;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RG) == 0) {
            tVBOpt.PALMODE = pal_RG;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RC) == 0) {
            tVBOpt.PALMODE = pal_RC;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_YB) == 0) {
            tVBOpt.PALMODE = pal_YB;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_MG) == 0) {
            tVBOpt.PALMODE = pal_MG;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_BG) == 0) {
            tVBOpt.PALMODE = pal_BG;
         }
         vIndex+=2;

      }else if (strcmp(argv[vIndex], CL_FRMSKP) == 0){
         tmp=atoi(argv[vIndex+1]);
	     if((tmp>=0)&&(tmp<=9)) 
			 tVBOpt.FRMSKIP = tmp;
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_SCLSCR) == 0){
         tmp=atoi(argv[vIndex+1]);
         if((tmp>=0)&&(tmp<=6)) 
			 tVBOpt.SCLSCR = tmp;
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_BRTNES) == 0){
         tVBOpt.BFACTOR=(float)atof(argv[vIndex+1]);
	     if((tVBOpt.BFACTOR<=0.1)||(tVBOpt.BFACTOR>3.0)) 
			 tVBOpt.BFACTOR = 1.0;
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_BALANCE) == 0){
         tVBOpt.R_BAL = (float)atof(argv[vIndex+1]);
         tVBOpt.G_BAL = (float)atof(argv[vIndex+2]);
         tVBOpt.B_BAL = (float)atof(argv[vIndex+3]);
	     if((tVBOpt.R_BAL<=0.1)||(tVBOpt.R_BAL>3.0)) tVBOpt.R_BAL = 1.0;
	     if((tVBOpt.G_BAL<=0.1)||(tVBOpt.G_BAL>3.0)) tVBOpt.G_BAL = 1.0;
	     if((tVBOpt.B_BAL<=0.1)||(tVBOpt.B_BAL>3.0)) tVBOpt.B_BAL = 1.0;
         vIndex+=4;

      }else if (strcmp(argv[vIndex], CL_HSTRETCH) == 0){
         tVBOpt.HSTRETCH = 2;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_MORE_RAM) == 0){
         tVBOpt.MORE_RAM = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_FLIP) == 0){
         tVBOpt.DSPSWAP = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_LTIMMER) == 0){ 
         tVBOpt.LTIMMER = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_VFHACK) == 0){ 
         tVBOpt.VFHACK = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_ALTKBD) == 0){
         tVBOpt.KBD_MAP = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_NOTHRTL) == 0){
         tVBOpt.NO_THRTL = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_STATUS) == 0){
         tVBOpt.STATUS = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_PPORT) == 0){
         tmp=atoi(argv[vIndex+1]);
         if((tmp>=0)&&(tmp<=4)) 
			 tVBOpt.PPORT = tmp;
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_JOY) == 0){
         tVBOpt.JOY_MAP = 1;
         vIndex++;
		 
#ifdef DBG_PRINT
      }else if (strcmp(argv[vIndex], CL_DISASM) == 0){ 
         tVBOpt.DISASM = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_DEBUG) == 0){
         tVBOpt.DEBUG = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_STDOUT) == 0){
         tVBOpt.STDOUT = 1;
         vIndex++;
#endif
      } else {
         vIndex++;
      }
      if(vIndex >= argc) done = 1;
   }

	//set virtual screen resolution
	switch(tVBOpt.DSPMODE) {
	case dm_NORMAL:
	case dm_AFFINE:
		tVBOpt.VB_X   = 384;
		tVBOpt.VB_Y   = 224;
		break;
	case dm_INTERLACED:
	case dm_OVRUNDR:
		tVBOpt.VB_X   = 384;
		tVBOpt.VB_Y   = 448;
		break;

	case dm_SIDESIDE:
		tVBOpt.VB_X   = 768;
		tVBOpt.VB_Y   = 224;
		break;

	case dm_CYBERSCOPE:
		tVBOpt.VB_X   = 448;
		tVBOpt.VB_Y   = 384;
		break;
	default:
		break;
	};

   return 1;
}

void dump_settings() {
	dtprintf(10,ferr,"FRMSKIP: %d\n", tVBOpt.FRMSKIP);
	dtprintf(10,ferr,"SCLSCR: %d\n", tVBOpt.SCLSCR);
	dtprintf(10,ferr,"HSTRETCH: %d\n", tVBOpt.HSTRETCH);
	dtprintf(10,ferr,"DSPMODE: %d\n", tVBOpt.DSPMODE);
	dtprintf(10,ferr,"DSPSWAP: %d\n", tVBOpt.DSPSWAP);
	dtprintf(10,ferr,"PALMODE: %d\n", tVBOpt.PALMODE);
	dtprintf(10,ferr,"DEBUG: %d\n", tVBOpt.DEBUG);
	dtprintf(10,ferr,"STDOUT: %d\n", tVBOpt.STDOUT);
	dtprintf(10,ferr,"BFACTOR: %f\n", tVBOpt.BFACTOR);
	dtprintf(10,ferr,"R_BAL: %f\n", tVBOpt.R_BAL);
	dtprintf(10,ferr,"G_BAL: %f\n", tVBOpt.G_BAL);
	dtprintf(10,ferr,"B_BAL: %f\n", tVBOpt.B_BAL);
	dtprintf(10,ferr,"SCR_X: %d\n", tVBOpt.SCR_X);
	dtprintf(10,ferr,"SCR_Y: %d\n", tVBOpt.SCR_Y);
	dtprintf(10,ferr,"VB_X: %d\n", tVBOpt.VB_X);
	dtprintf(10,ferr,"VB_Y: %d\n", tVBOpt.VB_Y);
	dtprintf(10,ferr,"LTIMMER: %d\n", tVBOpt.LTIMMER);
	dtprintf(10,ferr,"VFHACK: %d\n", tVBOpt.VFHACK);
	dtprintf(10,ferr,"DISASM: %d\n", tVBOpt.DISASM);
	dtprintf(10,ferr,"SCR_MODE: %d\n", tVBOpt.SCR_MODE);
	dtprintf(10,ferr,"ROM_NAME: %s\n", tVBOpt.ROM_NAME);
	dtprintf(10,ferr,"PROG_NAME: %s\n", tVBOpt.PROG_NAME);
	dtprintf(10,ferr,"KBD_MAP: %d\n", tVBOpt.KBD_MAP);
	dtprintf(10,ferr,"NO_THRTL: %d\n", tVBOpt.NO_THRTL);
	dtprintf(10,ferr,"STATUS: %d\n", tVBOpt.STATUS);
	dtprintf(10,ferr,"PPORT: %d\n", tVBOpt.PPORT);
	dtprintf(10,ferr,"JOY_MAP: %d\n", tVBOpt.JOY_MAP);
}