#include "cp_io.h"
#include "..\vb_io.h"
#include "..\vb_set.h"
#include "..\vb_vbtD.h"
#include "..\vb_dsp.h"



////////////////////////////////////////////////////////////////////
// platform specific I/O fns

// timmer to controll input 
volatile int input_read = 0;

void set_input_read() { input_read = 1; }
END_OF_FUNCTION(set_input_read)

void lib_init() {
	allegro_init();

	LOCK_VARIABLE(input_read);
	LOCK_FUNCTION(set_input_read);

	install_int_ex(set_input_read, BPS_TO_TIMER(60));
}

void lib_close() {
	allegro_exit();
}

void kbd_init(int key_map) {

	install_keyboard(); 
	clear_keybuf();

	VBK_DATA[VBK_FSD]  = KEY_MINUS; 
	VBK_DATA[VBK_FSU]  = KEY_EQUALS;
	VBK_DATA[VBK_SWP]  = KEY_CLOSEBRACE;
	VBK_DATA[VBK_PRN]  = KEY_P;
	VBK_DATA[VBK_STS]  = KEY_0;
	VBK_DATA[VBK_ESC]  = KEY_ESC;

	VBK_DATA[VBK_BRTU]   = KEY_2;
	VBK_DATA[VBK_BRTD]   = KEY_1;
	VBK_DATA[VBK_RBALU]  = KEY_4;
	VBK_DATA[VBK_RBALD]  = KEY_3;
	VBK_DATA[VBK_GBALU]  = KEY_6;
	VBK_DATA[VBK_GBALD]  = KEY_5;
	VBK_DATA[VBK_BBALU]  = KEY_8;
	VBK_DATA[VBK_BBALD]  = KEY_7;

	if(key_map!=0) {
		VBK_DATA[VBK_vBATT]= KEY_W;
		VBK_DATA[VBK_vA]   = KEY_M;
		VBK_DATA[VBK_vB]   = KEY_N;
		VBK_DATA[VBK_vR]   = KEY_H;
		VBK_DATA[VBK_vL]   = KEY_G;
		VBK_DATA[VBK_vRR]  = KEY_L;
		VBK_DATA[VBK_vRU]  = KEY_I;
		VBK_DATA[VBK_vLR]  = KEY_F;
		VBK_DATA[VBK_vLL]  = KEY_S;
		VBK_DATA[VBK_vLD]  = KEY_D;
		VBK_DATA[VBK_vLU]  = KEY_E;
		VBK_DATA[VBK_vSTR] = KEY_B;
		VBK_DATA[VBK_VSEL] = KEY_V;
		VBK_DATA[VBK_RL]   = KEY_J;
		VBK_DATA[VBK_RD]   = KEY_K;
	} else {
		VBK_DATA[VBK_vBATT]= KEY_W;
		VBK_DATA[VBK_vA]   = KEY_Z;
		VBK_DATA[VBK_vB]   = KEY_X;
		VBK_DATA[VBK_vR]   = KEY_S;
		VBK_DATA[VBK_vL]   = KEY_A;
		VBK_DATA[VBK_vRU]  = KEY_F;
		VBK_DATA[VBK_vRR]  = KEY_B;
		VBK_DATA[VBK_vLR]  = KEY_RIGHT;
		VBK_DATA[VBK_vLL]  = KEY_LEFT;
		VBK_DATA[VBK_vLD]  = KEY_DOWN;
		VBK_DATA[VBK_vLU]  = KEY_UP;
		VBK_DATA[VBK_vSTR] = KEY_Q;
		VBK_DATA[VBK_VSEL] = KEY_W;
		VBK_DATA[VBK_RL]   = KEY_C;
		VBK_DATA[VBK_RD]   = KEY_V;
	}
}

void kbd_close() {
	clear_keybuf();
	remove_keyboard();
}

bool test_key(int key_code) {
	if((key_code<0) || (key_code>MAX_KEY))
		return false;

	return (0 != key[VBK_DATA[key_code]]);
}

char wait_key() {
	char ret;
	ret = readkey() & 0xFF;
	clear_keybuf();
	return ret;
}

HWORD kbd_read() {
	
	//delay so keys don't run away
	static unsigned int FS_DELAY = 0;

	if(!FS_DELAY) {
		if(key[VBK_DATA[VBK_FSD]]   || key[VBK_DATA[VBK_FSU]]   ||
		   key[VBK_DATA[VBK_BRTD]]  || key[VBK_DATA[VBK_BRTU]]  ||
		   key[VBK_DATA[VBK_RBALD]] || key[VBK_DATA[VBK_RBALU]] ||
		   key[VBK_DATA[VBK_GBALD]] || key[VBK_DATA[VBK_GBALU]] ||
		   key[VBK_DATA[VBK_BBALD]] || key[VBK_DATA[VBK_BBALU]] ||
		   key[VBK_DATA[VBK_SWP]]   || key[VBK_DATA[VBK_STS]])
			FS_DELAY = 5;

		//Handle Frame Skip
		if(key[VBK_DATA[VBK_FSD]]) 
			tVBOpt.FRMSKIP -= (tVBOpt.FRMSKIP==0)?0:1;
		if(key[VBK_DATA[VBK_FSU]])
			tVBOpt.FRMSKIP += (tVBOpt.FRMSKIP>15)?0:1;

		//red
		if(key[VBK_DATA[VBK_RBALD]]) 
			tVBOpt.R_BAL -= (tVBOpt.R_BAL<=0.2)?0:0.1;
		if(key[VBK_DATA[VBK_RBALU]])
			tVBOpt.R_BAL += (tVBOpt.R_BAL>=3.0)?0:0.1;
		//green
		if(key[VBK_DATA[VBK_GBALD]]) 
			tVBOpt.G_BAL -= (tVBOpt.G_BAL<=0.2)?0:0.1;
		if(key[VBK_DATA[VBK_GBALU]])
			tVBOpt.G_BAL += (tVBOpt.G_BAL>=3.0)?0:0.1;
		//blue
		if(key[VBK_DATA[VBK_BBALD]]) 
			tVBOpt.B_BAL -= (tVBOpt.B_BAL<=0.2)?0:0.1;
		if(key[VBK_DATA[VBK_BBALU]])
			tVBOpt.B_BAL += (tVBOpt.B_BAL>=3.0)?0:0.1;
		//bright
		if(key[VBK_DATA[VBK_BRTD]]) 
			tVBOpt.BFACTOR -= (tVBOpt.BFACTOR<=0.2)?0:0.1;
		if(key[VBK_DATA[VBK_BRTU]])
			tVBOpt.BFACTOR += (tVBOpt.BFACTOR>=3.0)?0:0.1;

		//Flip 3D display
		if(key[VBK_DATA[VBK_SWP]])
			tVBOpt.DSPSWAP = (tVBOpt.DSPSWAP)?0:1; 

		//Turn on status
		if(key[VBK_DATA[VBK_STS]])
			tVBOpt.STATUS = (tVBOpt.STATUS)?0:1; 

		//invalidate display cache
		clearCache();
	} else {
		FS_DELAY--;
	}

    int t1 = 0;
    if(key[VBK_DATA[VBK_vBATT]]) t1=t1|0x0001;     // Batery Low
    if(key[VBK_DATA[VBK_vA]])    t1=t1|0x0004;
    if(key[VBK_DATA[VBK_vB]])    t1=t1|0x0008;
    if(key[VBK_DATA[VBK_vR]])    t1=t1|0x0010;
    if(key[VBK_DATA[VBK_vL]])    t1=t1|0x0020;
    if(key[VBK_DATA[VBK_vRU]])   t1=t1|0x0040;
    if(key[VBK_DATA[VBK_vRR]])   t1=t1|0x0080;
    if(key[VBK_DATA[VBK_vLR]])   t1=t1|0x0100;
    if(key[VBK_DATA[VBK_vLL]])   t1=t1|0x0200;
    if(key[VBK_DATA[VBK_vLD]])   t1=t1|0x0400;
    if(key[VBK_DATA[VBK_vLU]])   t1=t1|0x0800;
    if(key[VBK_DATA[VBK_vSTR]])  t1=t1|0x1000;
    if(key[VBK_DATA[VBK_VSEL]])  t1=t1|0x2000;
    if(key[VBK_DATA[VBK_RL]])    t1=t1|0x4000;
    if(key[VBK_DATA[VBK_RD]])    t1=t1|0x8000;
    t1=t1|0x0002;                   // Always set bit1, ctrl ID
    return t1;
}

////////////////////////////////////
//Dynamic DLL stuff, what a mess

/* ----Prototypes of Inp and Outp--- */
//short _stdcall Inp32(short PortAddress);
//void _stdcall Out32(short PortAddress, short data);

HINSTANCE ppt_lib = NULL;
typedef short (WINAPI *LPInp32)(short);
typedef void  (WINAPI *LPOut32)(short, short);

LPInp32 Inp32 = NULL;
LPOut32 Out32 = NULL;

bool pport_init() {

	//load dll
	ppt_lib = LoadLibrary("InpOut32.dll");

	if (NULL == ppt_lib)
        return false;

	Inp32 = (LPInp32) GetProcAddress(ppt_lib,"Inp32");
	if(NULL == Inp32)
		return false;
	Out32 = (LPOut32) GetProcAddress(ppt_lib,"Out32");
	if(NULL == Out32)
		return false;

	return true;
}
void pport_close() {
	if(NULL != ppt_lib)
		FreeLibrary(ppt_lib);
	ppt_lib = NULL;
	Inp32 = NULL;
	Out32 = NULL;
}

int  pport_inport(int base) {
	if(NULL == Inp32) return 0;
	return (int)Inp32((short)base);
}
void pport_outport(int base, int data) {
	if(NULL == Out32) return;
	Out32((short)base, short(data));
}

////////////////////////////////////

void joy_init(int joy_map) {

	//install joyticks
	if(0 != install_joystick(JOY_TYPE_AUTODETECT)) {
		tVBOpt.JOY_MAP = 0;
		return;
	}

	//quit if no joysticks
	if(0 != poll_joystick()) {
		tVBOpt.JOY_MAP = 0;
		return;
	}

	//quit if not enough sticks
	if(joy[0].num_sticks<2) {
		tVBOpt.JOY_MAP = 0;
		return;
	}

	//quit if not enough buttons
	if(joy[0].num_buttons<6) {
		tVBOpt.JOY_MAP = 0;
		return;
	}


}

HWORD joy_read() {
	int ret = 0;

	//query sticks
	if(0 != poll_joystick())
		return 0;

	if(joy[0].button[0].b)		ret |= 0x0004; //a
	if(joy[0].button[1].b)		ret |= 0x0008; //b
	if(joy[0].button[6].b)		ret |= 0x0010; //r
	if(joy[0].button[7].b)		ret |= 0x0020; //l
	if(joy[0].button[3].b)		ret |= 0x1000; //start
	if(joy[0].button[4].b)		ret |= 0x2000; //select

	if(joy[0].stick[0].axis[0].d2)	ret |= 0x0100; //left-right
	if(joy[0].stick[0].axis[0].d1)	ret |= 0x0200; //left-left
	if(joy[0].stick[0].axis[1].d2)	ret |= 0x0400; //left-down
	if(joy[0].stick[0].axis[1].d1)	ret |= 0x0800; //left-up
	
	if(joy[0].stick[2].axis[0].d2)	ret |= 0x0100; //left-right
	if(joy[0].stick[2].axis[0].d1)	ret |= 0x0200; //left-left
	if(joy[0].stick[2].axis[1].d2)	ret |= 0x0400; //left-down
	if(joy[0].stick[2].axis[1].d1)	ret |= 0x0800; //left-up

	if(joy[0].stick[1].axis[1].d1)	ret |= 0x0040; //right-up
	if(joy[0].stick[1].axis[0].d2)	ret |= 0x0080; //right-right
	if(joy[0].stick[1].axis[0].d1)	ret |= 0x4000; //right-left
	if(joy[0].stick[1].axis[1].d2)	ret |= 0x8000; //roght-down

	ret |= 0x0002; // Always set bit1, ctrl ID

	return ret;
}

void joy_close() {
}

////////////////////////////////////
int init_graphics() {
	int tmp, tmp_x, tmp_y;
	int aDspM;

	int scr_mode[] = 
		{GFX_AUTODETECT_WINDOWED,
		GFX_AUTODETECT_FULLSCREEN,
		GFX_AUTODETECT_FULLSCREEN,
		GFX_AUTODETECT_FULLSCREEN,
		GFX_AUTODETECT_FULLSCREEN,
		GFX_AUTODETECT_FULLSCREEN,
		GFX_AUTODETECT_FULLSCREEN,
		GFX_AUTODETECT_FULLSCREEN };


	aDspM = scr_mode[tVBOpt.SCR_MODE];

	//if windowed 
	if(0 == tVBOpt.SCR_MODE) {
		//test for desktop resolution
		get_desktop_resolution(&tmp_x, &tmp_y);

		//if debug mode, force a 512x512 screen, clean this up
		if(tVBOpt.DEBUG) {
			//make shure scaled window is smaller thain desktop
			tmp = tmp_x/(512 * tVBOpt.HSTRETCH);
			if(tmp<tVBOpt.SCLSCR) tVBOpt.SCLSCR = tmp;
			tmp = tmp_y/512;
			if(tmp<tVBOpt.SCLSCR) tVBOpt.SCLSCR = tmp;
			//check for stupidity
			if(tVBOpt.SCLSCR<1) tVBOpt.SCLSCR = 1;

			tVBOpt.SCR_X = 512*tVBOpt.SCLSCR * tVBOpt.HSTRETCH;
			tVBOpt.SCR_Y = 512*tVBOpt.SCLSCR;
		} else {

			//make shure scaled window is smaller thain desktop
			tmp = tmp_x/(tVBOpt.VB_X * tVBOpt.HSTRETCH);
			if(tmp<tVBOpt.SCLSCR) tVBOpt.SCLSCR = tmp;
			tmp = tmp_y/tVBOpt.VB_Y;
			if(tmp<tVBOpt.SCLSCR) tVBOpt.SCLSCR = tmp;
			//check for stupidity
			if(tVBOpt.SCLSCR<1) tVBOpt.SCLSCR = 1;


			//Set screen size
			tVBOpt.SCR_X = tVBOpt.VB_X*tVBOpt.SCLSCR * tVBOpt.HSTRETCH;
			tVBOpt.SCR_Y = tVBOpt.VB_Y*tVBOpt.SCLSCR;
		}
	}

	if(set_gfx_mode(aDspM, tVBOpt.SCR_X, tVBOpt.SCR_Y, 0, 0)<0) {
		return(false);
	}

	return true;
}

int close_graphics() {
	set_gfx_mode(GFX_TEXT,0,0,0,0);
	return true;
}

///////////////////////////////////////////////////////
// Bitmap routine

//Blit finished screen to display, and scale
//****FixMe, precompute all of this somewhere else
void bmp_display(BITMAP * bmp) {
	int dim_x, dim_y, off_x, off_y;

	//if scaling to full screen
	if((0 != tVBOpt.SCR_MODE) && (0 == tVBOpt.SCLSCR)) {

		//adjust aspect ratio (cleanup, fix for wide aspect ratios)
		if(((float)tVBOpt.SCR_X/(float)bmp->w) < ((float)tVBOpt.SCR_Y/(float)bmp->h)) {
			dim_x = tVBOpt.SCR_X;
			off_x = 0;

			dim_y = (dim_x*bmp->h)/bmp->w;
			off_y = (tVBOpt.SCR_Y - dim_y) >> 1;
		} else {
			dim_y = tVBOpt.SCR_Y;
			off_y = 0;

			dim_x = (dim_y*bmp->w)/bmp->h;
			off_x = (tVBOpt.SCR_X - dim_x) >> 1;
		}
	} else {
		//scale
		dim_x = bmp->w * tVBOpt.SCLSCR * tVBOpt.HSTRETCH;
		dim_y = bmp->h * tVBOpt.SCLSCR;

		//if not a window, center
		if(0 != tVBOpt.SCR_MODE) {
			off_x = (tVBOpt.SCR_X - dim_x) >> 1;
			off_y = (tVBOpt.SCR_Y - dim_y) >> 1;
		} else {
			off_x = off_y = 0;
		}
	}

	stretch_blit(bmp,screen,
		0,0,bmp->w,bmp->h,off_x, off_y,dim_x, dim_y);
}

void scr_clear() {
	bmp_clear(screen,0);
}

void bmp_clear(BITMAP *bmp, int index) {
	clear_to_color(bmp,index);
}

void bmp_save(BITMAP *bmp, char *name) {
	PALETTE pal;
    char buffer [MAX_PATH];
	char tpath[MAX_PATH];
	FILE * fptr;
	int pCnt = 0;

    get_palette(pal);
	strcpy(tpath,tVBOpt.ROM_NAME);
    sprintf(buffer, "%s%02d.bmp",name,pCnt);
	replace_filename(tpath, tpath,  buffer, MAX_PATH);


	while(fptr = fopen(tpath,"r")) {
		fclose(fptr);
		pCnt++;
	    sprintf(buffer, "%s%02d.bmp",name,pCnt); 
		replace_filename(tpath, tpath,  buffer, MAX_PATH);
	}

    save_bmp(tpath,bmp,pal);
}

void bmp_copy(BITMAP *src, BITMAP *dest,
			  int src_x, int src_y,
			  int dest_x, int dest_y,
			  int width, int height) {
	masked_blit(src,dest,src_x,src_y,dest_x,dest_y,width,height);
}

void bmp_rotate(BITMAP *src, BITMAP *dest,
			  int src_x, int src_y,
			  int cx, int cy,
			  int angle) {
	pivot_sprite(src,dest, src_x,src_y,cx,cy, itofix(angle));
}

BITMAP* bmp_create(int width, int height) {
	return create_bitmap(width, height);
}

BITMAP* bmp_clip(BITMAP* bmp, int src_x, int src_y, int width, int height) {
		return create_sub_bitmap(bmp, src_x, src_y, width, height);
}

void bmp_free(BITMAP *bmp) {
	destroy_bitmap(bmp);
}

