#include <stdarg.h> //Needed for the dtfprintf() fn
#include <ctype.h>

#include "vb_io.h"
#include "v810_cpu.h"
#include "v810_cpuD.h"
#include "vb_dsp.h"
#include "vb_set.h"
#include "vb_vbt.h"
#include "vb_vbtD.h"


//////////////////////////////////////////////////////////
//Debug fPrintf
//Can be turnd on and off by seting the debug level to 10
int dtPrintLVL = 10;
FILE *ferr;
WORD queue[100];
int qptr = 0;

#ifdef DBG_PRINT
void dtprintf(int level, FILE *_stream, const char *_format, ...) {
	va_list argp;
	if(level>=dtPrintLVL) {
		va_start(argp,_format);
		vfprintf(_stream,_format,argp);
		va_end(argp);
	}
}

//////////////////////////////////////////////////////////
void vb_addQueue(WORD num) {
	queue[qptr] = num;
	qptr +=1;
	if(qptr >=100) qptr = 0;
}

void vb_dumpQueue() {
	int i = 0;
	for(i=0;i<100;i++) {
		v810_dis(queue[qptr],1,ferr);
		qptr +=1;
		if(qptr >=100) qptr = 0;
	}
}

//////////////////////////////////////////////////////////
#endif

void vb_goDbg() {
    char inputstr[80];
    char *cmd, *args, *argsend;
    unsigned long tmppc, debugPC;
    FILE *nvramf;
    WORD j;

    debugPC = PC;
    v810_dis(PC, 1,stdout);

    printf("\n Beginning emulation, type ? for help\n");
    // Controll Loop stolen form StarScream CPU Core
    for(;;){
        fprintf(stdout,"\nV810-");
        fflush(stdout);fflush(stderr);
        fgets(inputstr,sizeof(inputstr),stdin);
        cmd=inputstr;
        while((tolower(*cmd)<'a')&&(tolower(*cmd)>'z')){
            if(*cmd==0)break;
            cmd++;
        }
        if(!(*cmd))continue;
        *cmd=tolower(*cmd);
        args=cmd+1;
        while(((*args)!=0)&&((*args)<32))args++;
        switch(*cmd){
        case '?': //Help
            fprintf(stdout,
            "b [address]    Run continuously, break at PC=[address]\n"
            "d [address]    Dump memory, starting at [address]\n"
            "i [number]     Generate hardware interrupt [number]\n"
            "j [address]    Jump directly to [address]\n"
            "q              Quit\n"
            "r              Show register dump and next instruction\n"
            "t [hex number] Trace through [hex number] instructions\n"
            "u [address]    Unassemble code, starting at [address]\n"
            "v              goto Video mode\n"
            "m              write memory to a file(For debug only)\n"
            "l [level]      set the debug level\n"
			"a              start interactive dissasembler\n"
            );
            break;
        case 'b':          //Break at addres
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,16);
                if(argsend!=args){
                    while(PC !=tmppc){
                        //if(kbhit())
                            //if(getch() == 27) break; //Fix with allegro!
                        v810_trc(1);
                    }
                    v810_preg();
                    v810_dis(PC, 1,stdout);
                    debugPC = PC;
                }else{
                    fprintf(stdout,"Invalid address\n");
                }
            }else{
                fprintf(stdout,"Need an address\n");
            }
            break;
        case 'd': //Dump memory
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,16);
                if(argsend!=args)debugPC=tmppc;
                if (tmppc == -1) debugPC = PC; //Hack, Ignore the sign/unsgn prob...
            }
            v810_dump(debugPC, 16);
            debugPC += 16*16;
            break;
        case 'i': //Generate Interupt #
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,10);
                if(argsend!=args){
                    printf("Interrupt %ld generated\n",tmppc);
                    v810_int(tmppc);
                    //v810_trc();
                    v810_preg();
                    v810_dis(PC, 1,stdout);
                    debugPC = PC;
                }else{
                    printf("Invalid interrupt number\n");
                }
            }else{
                printf("Need an interrupt number\n");
            }
            break;
        case 'j': //Jump directly to address
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,16);
                if(argsend!=args){
                    PC=tmppc;
                    printf("PC set to %08lx\n",PC);
                    //v810_trc();
                    v810_preg();
                    v810_dis(PC, 1,stdout);
                    debugPC = PC;
                }else{
                    printf("Invalid address\n");
                }
            }else{
                printf("Need an address\n");
            }
            break;
        case 'm':  //Dump Memory
            printf("\nWriting memory to file...");
            // save out the VIP Display ram
            if((nvramf = fopen("ram_vip.bin", "wb")) == NULL) {
                printf("\nError opening ram_vip.bin");
            }
            for(j=V810_DISPLAY_RAM.lowaddr; j <= V810_DISPLAY_RAM.highaddr; j++) {
                fputc((char)mem_rbyte(j), nvramf);
            }
            fclose(nvramf);
            // save out the Sound ram
            if((nvramf = fopen("ram_sound.bin", "wb")) == NULL) {
                printf("\nError opening ram_sound.bin");
            }
            for(j=V810_SOUND_RAM.lowaddr; j <= V810_SOUND_RAM.highaddr; j++) {
                fputc((char)mem_rbyte(j), nvramf);
            }
            fclose(nvramf);
            // save out the system ram
            if((nvramf = fopen("ram_sys.bin", "wb")) == NULL) {
                printf("\nError opening ram_sys.bin");
            }
            for(j=V810_VB_RAM.lowaddr; j <= V810_VB_RAM.highaddr; j++) {
                fputc((char)mem_rbyte(j), nvramf);
            }
            fclose(nvramf);
            // save out the sram ram
            if((nvramf = fopen("ram_sram.bin", "wb")) == NULL) {
                printf("\nError opening ram_sram.bin");
            }
            for(j=V810_GAME_RAM.lowaddr; j <= V810_GAME_RAM.highaddr; j++) {
                fputc((char)mem_rbyte(j), nvramf);
            }
            fclose(nvramf);
            break;  
        case 'q':  //Quit
		return;
        case 'r':
            v810_preg();
            v810_dis(PC, 1,stdout);
            break;
        case 't': //Trace through n lines of code
            tmppc=1;
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,16);
                if(argsend==args)tmppc=1;
            }
            if(tmppc>0){
                v810_trc(1);
                v810_preg();
                v810_dis(PC, 1,stdout);
                debugPC = PC;
            }
            break;
        case 'u': //Unassemble
            if((*args)!=0){ 
                tmppc=strtoul(args,&argsend,16);
                if(argsend!=args)debugPC=tmppc;
                if (tmppc == -1) debugPC = PC; //Hack, ignore the Signed/unsigned prob
            }
            debugPC = v810_dis(debugPC, 16,stdout);
            //debugPC +=16;
            break;
        case 'v': //got Video Mode
            V810_DSP();
            break;
        case 'l': //debug level
            if((*args)!=0){
                tmppc=strtoul(args,&argsend,10);
                if(argsend!=args){
                    printf("Debug level %ld set\n",tmppc);
                    dtPrintLVL = tmppc;
                }else{
                    printf("Invalid debug level\n");
                }
            }else{
                printf("Need an debug level\n");
            }
            break;
		case 'a':
			if(tVBOpt.DISASM) {
				tVBOpt.DISASM = 0;
				printf("dissasembler is off\n");
			} else {
				tVBOpt.DISASM = 1;
				printf("dissasembler is on\n");
			}
			break;
        default:
            break;
        }
    }
}
