#ifndef VBIO_H
#define VBIO_H

#include "cp_io.h"

/* *************************************
 * VB_IO.h 
 *
 * Defines the I/O routines, keyboard, joystick, sound, etc
 * 'Virtual Class' (of sourts) is filled in by CP_IO.h for 
 * platform specific code
 *
 * ************************************
 */

typedef BITMAP BMP_BITMAP;

void vbio_init();

int init_graphics();
int close_graphics();
	
//Read the Controller
HWORD handle_input();
char wait_key();

bool test_key(int key_code);
void scr_clear();
void bmp_display(BMP_BITMAP * bmp);
void bmp_clear(BMP_BITMAP *bmp, int index);
void bmp_save(BMP_BITMAP *bmp, char *name);

void bmp_copy(BMP_BITMAP *src, BMP_BITMAP *dest,
			  int src_x, int src_y,
			  int dest_x, int dest_y,
			  int width, int height);

void bmp_free(BMP_BITMAP *bmp);
BMP_BITMAP* bmp_create(int width, int height);
BMP_BITMAP* bmp_create(int width, int height);
BMP_BITMAP* bmp_clip(BMP_BITMAP* bmp, int src_x, int src_y, int width, int height);
void bmp_rotate(BITMAP *src, BITMAP *dest,
			  int src_x, int src_y,
			  int cx, int cy,
			  int angle);
////////////////////////////////////////////////////////////////////
// Keybd Fn's

#define MAX_KEY   30

#define VBK_vBATT 0
//		VBK_vCID  1
#define VBK_vA    2
#define VBK_vB    3
#define VBK_vR    4
#define VBK_vL    5
#define VBK_vRR   6
#define VBK_vRU   7
#define VBK_vLR   8
#define VBK_vLL   9
#define VBK_vLD   10
#define VBK_vLU   11
#define VBK_vSTR  12
#define VBK_VSEL  13
#define VBK_RL    14
#define VBK_RD    15

#define VBK_FSD 16
#define VBK_FSU 17
#define VBK_SWP 18
#define VBK_PRN 19
#define VBK_STS 20
#define VBK_ESC 21

#define VBK_BRTU 22
#define VBK_BRTD 23
#define VBK_RBALU 24
#define VBK_RBALD 25
#define VBK_GBALU 26
#define VBK_GBALD 27
#define VBK_BBALU 28
#define VBK_BBALD 29


//keyboard map
extern int VBK_DATA[MAX_KEY];

#endif

