#include "vb_io.h"
#include "vb_set.h"
#include "vb_vbtD.h"


//////////////////////////////////
//Private fn's from cp_io.h

void kbd_init(int key_map);
void kbd_close();
HWORD kbd_read();

bool pport_init();
void pport_close();
int  pport_inport(int base);
void pport_outport(int base, int data);
HWORD pport_read();

void joy_init(int joy_map);
void joy_close();
HWORD joy_read();

void lib_init();
void lib_close();

extern volatile int input_read;



/////////////////////////////////
int VBK_DATA[MAX_KEY];

void vbio_init() {
	lib_init();
	//initialize cpio libs, (keyboard mappings, etc)
	kbd_init(tVBOpt.KBD_MAP);

	//disable parallel port if driver failed to load
	if(!pport_init()) {
		tVBOpt.PPORT = -1;
		dtprintf(10,ferr,"\nfailed to load paralel port driver");
	}

	joy_init(tVBOpt.JOY_MAP);
}

void vbio_close() {
	kbd_close();
	pport_close();
	joy_close();
	lib_close();
}


HWORD handle_input() {
	static HWORD ret = 0;

	//only read 60 times a second...
	if(!input_read)
		return ret;

	ret  = kbd_read();
	if(0<tVBOpt.JOY_MAP)
		ret |= joy_read();
	if(0<tVBOpt.PPORT)
		ret |= pport_read()&0xFFFE;

	input_read = 0;
	return ret;
}

/*

//frame skip stuff
if((frm_cnt > (MAX_FPS/INTERVALS))) {
	if(!tVBOpt.NO_THRTL) //only throttle if nessisary
		while(clock() < (start_time+CLOCK_TICKS))
			yield_timeslice();

	start_time = clock();
	frm_cnt = 0;

	if(++tCount == INTERVALS) {
		fps = MAX_FPS/(((float)(clock()-tClock))/(float)CLOCKS_PER_SEC);
		tCount = 0;
		tClock = start_time;
	}
}

*/

///////////////////////////////////////////////////////////
// Read data from a VB controller attached to the paralel port
// this is probably very intel specific, but for now it lives in 
// vb_io and not cp_io

#define VBPAD_POWER  248
#define VBPAD_CLOCK    1
#define VBPAD_LATCH    2
#define VBPAD_BUTTONS 16

HWORD pport_read() {
	//return if no pport joystick
	if((tVBOpt.PPORT < 1) || (tVBOpt.PPORT > 4))
		return 0;

	static int pp_base[] = {0x378,0x278,0x3b8,0x3bc};
	int base = pp_base[tVBOpt.PPORT-1];

	int buttondata = 0;
	int i, tmp;

	// read bits from the VBpad
	for (i = 0; i < VBPAD_BUTTONS; i++) {
		//init controll lines high
		pport_outport(base, VBPAD_POWER+VBPAD_CLOCK);

		if (i == 0) //trigger latch to init controller
			pport_outport(base, VBPAD_POWER + VBPAD_LATCH + VBPAD_CLOCK);
		else //toggle clock to cycle next bit
			pport_outport(base, VBPAD_POWER + VBPAD_CLOCK);

		//data stable on falling edge of clock
		pport_outport(base, VBPAD_POWER);

		//data is inverted on paralel port...
		tmp = !((pport_inport(base + 1)&0x040)>>6);
		buttondata |= (tmp<<(15-i));
	}
	//clear controll lines, high
	pport_outport(base, VBPAD_POWER+VBPAD_CLOCK);
	return buttondata;
}

