/*********************************
* cp_io.h
*
* Cross Platform I/O wrapper for keyboard/joystick/mouse,
* Sound, and video interfaces
*
**********************************/

#include <allegro.h>

#ifndef MAX_PATH
#define MAX_PATH 512
#endif

#ifndef WORD
#define WORD  unsigned long    //Full 32bit
#define BYTE  unsigned char    //8bit
#endif

#ifndef HWORD
#define HWORD unsigned short   //16bit
#endif

#ifndef INT64
#define INT64 long long int //64 bit int
#define INT64U long long unsigned int //64 bit Unsigned
#endif

#define VB_INLINE inline

//64 bit constants are not cross platform compatible
#define sign_32(num) (((num) & 0x80000000) ? (INT64)((num)|0xFFFFFFFF00000000LL) : (num))
