#include <stdio.h>
#include <shlobj.h>
#include "settings.h"

Settings::Settings() {
	emuPath = NULL;
	romPath = NULL;
	progPath = NULL;
}

Settings::~Settings() {
	if(emuPath) delete[] emuPath;
	if(romPath) delete[] romPath;
	//throws an exception! why, maby ShellExecute is holding on to it
	//if(progPath) delete[] progPath; 
}

void Settings::procArgs() {
	char * tCmd, * tPtr, * tPtr2;
	int strlen;

	tCmd = GetCommandLine();
	tPtr = strtok(tCmd+1,"\"");
	if(NULL != tPtr) {
		//truncate exe name
		strlen = sizeof(tPtr);
		tPtr2 = strrchr(tPtr,'\\');
		if(tPtr2)
			strlen = tPtr2 - tPtr;

		progPath = new char[strlen];
		strncpy(progPath,tPtr,strlen);
		progPath[strlen] = '\0';
	}
	//***FixMe, call tPtr = strtok(NULL," "); repeatedly to get rest of args
	FreeEnvironmentStrings(tCmd);
}

bool Settings::init() {
	char tstr[MAX_PATH];

	procArgs();

	dspMode = getInt("dspMode",0);
	threedMode = getInt("threedMode",0);
	pallet = getInt("pallet",0);
	fSkip = getInt("fSkip",0);
	bFactor = (float)getDouble("bFactor",1.0);
	balr = (float)getDouble("balr",1.0);
	balg = (float)getDouble("balg",1.0);
	balb = (float)getDouble("balb",1.0);
	scale = getInt("scale",1);
	pport = getInt("pport",0);
	keyMap = getInt("keyMap",0);
	joy = getInt("joy",0);
	more_ram = getInt("more_ram",0);

	swap = (getInt("swap",0))?true:false;
	hstretch = (getInt("hstretch",0))?true:false;
	timmerHack = (getInt("timmerHack",0))?true:false;
	vfHack = (getInt("vfHack",0))?true:false;
	debug = (getInt("debug",0))?true:false;
	nothrtl = (getInt("nothrtl",0))?true:false;
	status = (getInt("status",0))?true:false;
	disasm = (getInt("disasm",0))?true:false;
	stdOut = (getInt("stdout",0))?true:false;

	strcpy(tstr,progPath);
	strcat(tstr,"\\reality_boy.exe");
	emuPath = getString("emuPath",tstr);

	strcpy(tstr,progPath);
	strcat(tstr,"\\vb_demo_1.vb");
	romPath = getString("romPath",tstr);


	return true;
}

bool Settings::save_settings() {
	setInt("dspMode",dspMode);
	setInt("threedMode",threedMode);
	setInt("pallet",pallet);
	setInt("fSkip",fSkip);
	setDouble("bFactor",bFactor);
	setDouble("balr",balr);
	setDouble("balg",balg);
	setDouble("balb",balb);
	setInt("scale",scale);
	setInt("pport",pport);
	setInt("keyMap",keyMap);
	setInt("joy",joy);
	setInt("more_ram",more_ram);

	setInt("swap",swap);
	setInt("hstretch",hstretch);
	setInt("timmerHack",timmerHack);
	setInt("vfHack",vfHack);
	setInt("debug",debug);
	setInt("nothrtl",nothrtl);
	setInt("status",status);
	setInt("disasm",disasm);
	setInt("stdout",stdOut);

	setString("emuPath",emuPath);
	setString("romPath",romPath);

	return true;
}

char * Settings::getString(char * key, char * init) {
	if(key == NULL) return NULL;
	if(init == NULL) init = "";
	char tpath[MAX_PATH];
	char * tstr = new char[256];

	strcpy(tpath,progPath);
	strcat(tpath,"\\reality_boy.ini");

	GetPrivateProfileString("main",key,init,tstr,256,tpath);
	return tstr;
}
int Settings::getInt(char * key, int init) {
	char * tstr;
	int ret;
	tstr = getString(key,NULL);
	if(tstr == NULL || strlen(tstr)<1) {
		if(tstr) delete[] tstr;
		return init;
	}
	ret = atoi(tstr);
	delete[] tstr;

	return ret;
}

double Settings::getDouble(char * key, double init) {
	char * tstr;
	double ret;

	tstr = getString(key,NULL);
	if(tstr == NULL || strlen(tstr)<1) {
		if(tstr) delete[] tstr;
		return init;
	}
	ret = atof(tstr);
	delete[] tstr;

	return ret;
}

void Settings::setString(char * key, char * val) {
	if(key == NULL) return;
	if(val == NULL) return;
	char tpath[MAX_PATH];

	strcpy(tpath,progPath);
	strcat(tpath,"\\reality_boy.ini");

	WritePrivateProfileString("main",key,val,tpath);
}
void Settings::setInt(char * key, int val) {
	static char tstr[30];
	sprintf(tstr,"%d",val);
	setString(key,tstr);
}
void Settings::setDouble(char * key, double val) {
	static char tstr[30];
	sprintf(tstr,"%f",val);
	setString(key,tstr);
}
