#include <windows.h>
#include <Commctrl.h>
#include <stdio.h>
#include <string.h>
//#include <shlobj.h>

#include "resource.h"
#include "settings.h"

#ifndef MAX_PATH
#define   MAX_PATH 2048
#endif


//  Function prototypes -------------------------

int CALLBACK RBDlgProc(HWND, UINT, WPARAM, LPARAM) ;
void init() ;
void get_file(int ID, char * mask);
void init_pdialog(bool is_affine);
bool launch_app();
bool launch_help();

// Globals --------------------------------------
HWND	 hwnd = 0 ;
Settings s;


int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
			 PSTR szCmdLine, int iCmdShow) {
	
	MSG	 msg ;

	InitCommonControls();

	s.init();

	char* x = MAKEINTRESOURCE(IDD_DIALOG_MAIN );
	hwnd = CreateDialog(hInstance, x, NULL, RBDlgProc);

	init();
	
	ShowWindow (hwnd, iCmdShow) ;
	UpdateWindow (hwnd) ;

	
	do {
		if (PeekMessage (&msg, NULL, 0, 0, PM_NOREMOVE)) {
			if (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE)) {
				if (msg.message != WM_QUIT) {
					TranslateMessage (&msg) ;
					DispatchMessage  (&msg) ;
				}
			}
		} else {
			//ToDo, interject status info
			Sleep(10);
		}
	} while (msg.message != WM_QUIT) ;

	s.save_settings();

	return 1 ;
}

//  WndProc -------------------------------------
int CALLBACK RBDlgProc(HWND hwnd, UINT message, 
						WPARAM wParam, LPARAM lParam) {
	static char tstr[MAX_PATH];
	//static bool init = false;

	switch (message) {
	case WM_COMMAND:
		switch(LOWORD(wParam)) {
		case IDC_EMU_EDIT:
			if(HIWORD(wParam) == EN_UPDATE) {
				GetDlgItemText(hwnd,IDC_EMU_EDIT,tstr,MAX_PATH);
				if(s.emuPath) delete [] s.emuPath;
				s.emuPath = new char[sizeof(tstr)+1];
				strcpy(s.emuPath,tstr);
			}
			break;
		case IDC_ROM_EDIT:
			if(HIWORD(wParam) == EN_UPDATE) {
				GetDlgItemText(hwnd,IDC_ROM_EDIT,tstr,MAX_PATH);
				if(s.romPath) delete [] s.romPath;
				s.romPath = new char[sizeof(tstr)+1];
				strcpy(s.romPath,tstr);
			}
			break;
		case IDC_FSKIP_EDIT:
			//fixme, spin controll causes recursion here due to a race condition,
			// handle spin on our own to eleviate the problem
			//FixMe, limit this to a resonable range [0-9] for example
			/*
			if(!init) {
				SetDlgItemInt(hwnd,IDC_FSKIP_EDIT,s.fSkip,false);
				init = true;
			} else 
			*/
			if(HIWORD(wParam) == EN_UPDATE)
				s.fSkip = GetDlgItemInt(hwnd,IDC_FSKIP_EDIT,NULL,false);
			break;
		case IDC_BFACTOR_EDIT:
			if(HIWORD(wParam) == EN_UPDATE) {
				GetDlgItemText(hwnd,IDC_BFACTOR_EDIT,tstr,MAX_PATH);
				s.bFactor = (float)atof(tstr);
			}
			break;
		case IDC_BALR_EDIT:
			if(HIWORD(wParam) == EN_UPDATE) {
				GetDlgItemText(hwnd,IDC_BALR_EDIT,tstr,MAX_PATH);
				s.balr = (float)atof(tstr);
			}
			break;
		case IDC_BALG_EDIT:
			if(HIWORD(wParam) == EN_UPDATE) {
				GetDlgItemText(hwnd,IDC_BALG_EDIT,tstr,MAX_PATH);
				s.balg = (float)atof(tstr);
			}
			break;
		case IDC_BALB_EDIT:
			if(HIWORD(wParam) == EN_UPDATE) {
				GetDlgItemText(hwnd,IDC_BALB_EDIT,tstr,MAX_PATH);
				s.balb = (float)atof(tstr);
			}
			break;
		case IDC_SCL_COMBO:
			if(HIWORD(wParam) == CBN_SELCHANGE) {
				s.scale = SendMessage((HWND)lParam,CB_GETCURSEL,0,0);
			}
			break;
		case IDC_PPT_COMBO:
			if(HIWORD(wParam) == CBN_SELCHANGE) {
				s.pport = SendMessage((HWND)lParam,CB_GETCURSEL,0,0);
			}
			break;
		case IDC_JOY_COMBO:
			if(HIWORD(wParam) == CBN_SELCHANGE) {
				s.joy = SendMessage((HWND)lParam,CB_GETCURSEL,0,0);
			}
			break;
		case IDC_DSP_COMBO:
			if(HIWORD(wParam) == CBN_SELCHANGE)
				s.dspMode = SendMessage((HWND)lParam,CB_GETCURSEL,0,0);
			break;
		case IDC_3D_COMBO:
			if(HIWORD(wParam) == CBN_SELCHANGE) {
				s.threedMode = SendMessage((HWND)lParam,CB_GETCURSEL,0,0);
				s.pallet = 0; //reset pallet if switching mode.
				init_pdialog(1 == s.threedMode);
			}
			break;
		case IDC_PAL_COMBO:
			if(HIWORD(wParam) == CBN_SELCHANGE)
				s.pallet = SendMessage((HWND)lParam,CB_GETCURSEL,0,0);
			break;
		case IDC_KEY_COMBO:
			if(HIWORD(wParam) == CBN_SELCHANGE)
				s.keyMap = SendMessage((HWND)lParam,CB_GETCURSEL,0,0);
			break;
		case IDC_SWP_CHECK:
			s.swap = SendMessage ((HWND) lParam,BM_GETCHECK,0,0);
			break;
		case IDC_HSTRETCH_CHECK:
			s.hstretch = (bool)SendMessage ((HWND) lParam, BM_GETCHECK, 0, 0);
			break;
		case IDC_LTHACK_CHECK:
			s.timmerHack = (bool)SendMessage ((HWND) lParam, BM_GETCHECK, 0, 0);
			break;
		case IDC_VFHACK_CHECK:
			s.vfHack = (bool)SendMessage ((HWND) lParam, BM_GETCHECK, 0, 0);
			break;
		case IDC_MRAM_CHECK:
			s.more_ram = (bool)SendMessage ((HWND) lParam, BM_GETCHECK, 0, 0);
			break;
		case IDC_DBG_CHECK:
			s.debug = (bool)SendMessage ((HWND) lParam, BM_GETCHECK, 0, 0);
			break;
		
		case IDC_THR_CHECK:
			s.nothrtl = (bool)SendMessage ((HWND) lParam, BM_GETCHECK, 0, 0);
			break;
		case IDC_STS_CHECK:
			s.status = (bool)SendMessage ((HWND) lParam, BM_GETCHECK, 0, 0);
			break;
		case IDC_DIS_CHECK:
			s.disasm = (bool)SendMessage ((HWND) lParam, BM_GETCHECK, 0, 0);
			break;

		case IDC_CON_CHECK:
			s.stdOut = (bool)SendMessage ((HWND) lParam, BM_GETCHECK, 0, 0);
			break;

		case IDC_HELP_BUTTON:
			launch_help();
			break;
		case IDC_LAUNCH_BUTTON:
			launch_app();
			break;

		case IDC_EMU_BUTTON:
			get_file(IDC_EMU_EDIT, "*.exe\0*.exe\0all files\0*.*\0\0");
			break;

		case IDC_ROM_BUTTON:
			get_file(IDC_ROM_EDIT, "*.vb\0*.vb\0all files\0*.*\0\0");
			break;
			
		default:
			break;
		}
		
		break;

	case WM_PAINT:
		return FALSE;

	case WM_CLOSE:
		// since the dialog is non-modal, we destroy it instead of 
		//  calling EndDialog
		DestroyWindow (hwnd) ;
		return TRUE ;
	case WM_DESTROY:
		PostQuitMessage(0) ;
		return TRUE ;
	}

	return FALSE;
}

void get_file(int ID, char * mask) {
	OPENFILENAME ofn;
	char tstr[MAX_PATH];

	memset(&ofn,0,sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof (OPENFILENAME);

	ofn.hwndOwner = hwnd;
	ofn.lpstrFilter = TEXT(mask);
	GetDlgItemText(hwnd,ID,tstr,MAX_PATH);
	ofn.lpstrFile = tstr;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrTitle = NULL;

	if(GetOpenFileName(&ofn)) {
		if(strlen(tstr)<1) return;
		SetDlgItemText(hwnd,ID,tstr);
	}
}

void init_pdialog(bool is_affine) {
	HWND ht;

	ht = GetDlgItem(hwnd,IDC_PAL_COMBO);

	//remove old strings, make better!
	SendMessage(ht, CB_DELETESTRING, 0, NULL);
	SendMessage(ht, CB_DELETESTRING, 0, NULL);
	SendMessage(ht, CB_DELETESTRING, 0, NULL);
	SendMessage(ht, CB_DELETESTRING, 0, NULL);
	SendMessage(ht, CB_DELETESTRING, 0, NULL);
	SendMessage(ht, CB_DELETESTRING, 0, NULL);
	
	if(!is_affine) {
		SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Normal");
		SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Red");
	} else {
		SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Red-Blue");
		SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Red-Green");
		SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Red-Cyan");
		SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Yellow-Blue");
		SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Magenta-Green");
		SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Blue-Green");
	}
	SendMessage(ht, CB_SETCURSEL, s.pallet, 0);
}

void init() {
	HWND ht;
	char tstr[10];

	//Initialize the dropdown boxes
	ht = GetDlgItem(hwnd,IDC_DSP_COMBO);
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Frame");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"320x200");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"640x480");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"800x600");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"1024x768");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"1280x1024");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"1400x1050");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"1600x1200");
	SendMessage(ht, CB_SETCURSEL, s.dspMode, 0);

	ht = GetDlgItem(hwnd,IDC_3D_COMBO);
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Normal");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Affine");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Interlaced");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Over under");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Side");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"CyberScope");
	SendMessage(ht, CB_SETCURSEL, s.threedMode, 0);

	init_pdialog(1 == s.threedMode);

	ht = GetDlgItem(hwnd,IDC_KEY_COMBO);
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Default");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Alternate");
	SendMessage(ht, CB_SETCURSEL, s.keyMap, 0);


	ht = GetDlgItem(hwnd,IDC_SCL_COMBO);
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Stretch");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"1x");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"2x");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"3x");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"4x");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"5x");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"6x");
	SendMessage(ht, CB_SETCURSEL, s.scale, 0);

	ht = GetDlgItem(hwnd,IDC_PPT_COMBO);
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"none");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"lpt1 (0x378)");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"lpt2 (0x278)");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"lpt3 (0x3B8)");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"IBM (0x3BC)");
	SendMessage(ht, CB_SETCURSEL, s.pport, 0);

	ht = GetDlgItem(hwnd,IDC_JOY_COMBO);
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"none");
	SendMessage(ht, CB_ADDSTRING, 0, (LPARAM)"Joy Map 1");
	SendMessage(ht, CB_SETCURSEL, s.joy, 0);

	//set edit boxes
	SetDlgItemText(hwnd,IDC_EMU_EDIT, s.emuPath);
	SetDlgItemText(hwnd,IDC_ROM_EDIT, s.romPath);

	SetDlgItemInt(hwnd,IDC_FSKIP_EDIT, s.fSkip, false);

	sprintf(tstr,"%1.1f",s.bFactor);
	SetDlgItemText(hwnd,IDC_BFACTOR_EDIT, tstr);

	sprintf(tstr,"%1.1f",s.balr);
	SetDlgItemText(hwnd,IDC_BALR_EDIT, tstr);
	sprintf(tstr,"%1.1f",s.balg);
	SetDlgItemText(hwnd,IDC_BALG_EDIT, tstr);
	sprintf(tstr,"%1.1f",s.balb);
	SetDlgItemText(hwnd,IDC_BALB_EDIT, tstr);

	//set check boxes
	SendMessage (GetDlgItem(hwnd,IDC_SWP_CHECK),
			BM_SETCHECK, (WPARAM)s.swap, 0);
	SendMessage (GetDlgItem(hwnd,IDC_HSTRETCH_CHECK),
			BM_SETCHECK, (WPARAM)s.hstretch, 0);
	SendMessage (GetDlgItem(hwnd,IDC_LTHACK_CHECK),
			BM_SETCHECK, (WPARAM)s.timmerHack, 0);
	SendMessage (GetDlgItem(hwnd,IDC_VFHACK_CHECK),
			BM_SETCHECK, (WPARAM)s.vfHack, 0);
	SendMessage (GetDlgItem(hwnd,IDC_MRAM_CHECK),
			BM_SETCHECK, (WPARAM)s.more_ram, 0);
	SendMessage (GetDlgItem(hwnd,IDC_DBG_CHECK),
			BM_SETCHECK, (WPARAM)s.debug, 0);
	SendMessage (GetDlgItem(hwnd,IDC_THR_CHECK),
			BM_SETCHECK, (WPARAM)s.nothrtl, 0);
	SendMessage (GetDlgItem(hwnd,IDC_STS_CHECK),
			BM_SETCHECK, (WPARAM)s.status, 0);
	SendMessage (GetDlgItem(hwnd,IDC_DIS_CHECK),
			BM_SETCHECK, (WPARAM)s.disasm, 0);
	SendMessage (GetDlgItem(hwnd,IDC_CON_CHECK),
			BM_SETCHECK, (WPARAM)s.stdOut, 0);
}

bool launch_app() {
	char arg_str[512];
	char * dspStr[] = {"frame", "320", "640", "800", "1024", "1280", "1400", "1600"};
	char * dsmStr[] = {"normal", "affine", "interlace", "over_under", "side", "cscope"};
    char * palStr[] = {"normal", "red", "rb", "rg", "rc", "yb", "mg", "bg"};

	sprintf(arg_str,"\"%s\" -display %s -dspmode %s -frmskp %d -brite %f -balance %f %f %f " \
		"-sclscr %d -pport %d -joy %d -pallet %s %s %s %s %s %s %s %s %s %s %s %s",
		s.romPath,
		dspStr[s.dspMode],
		dsmStr[s.threedMode],
		s.fSkip,
		s.bFactor,
		s.balr,
		s.balg,
		s.balb,
		s.scale,
		s.pport,
		s.joy,
		palStr[(s.threedMode ==1)?s.pallet+2:s.pallet],
		(s.swap)?"-flip":"",
		(s.hstretch)?"-hstretch":"",
		(s.timmerHack)?"-ltimmer":"",
		(s.vfHack)?"-vfhack":"",
		(s.more_ram)?"-more_ram":"",
		(s.debug)?"-debug":"",
		(s.disasm)?"-disasm":"",
		(s.stdOut)?"-stdout":"",
		(s.keyMap == 1)?"-altkbd":"",
		(s.nothrtl)?"-nothrtl":"",
		(s.status)?"-status":"");
	
	ShellExecute(hwnd, "open",
    s.emuPath,		//exe
    arg_str,		//args
    s.progPath,		//directory
    SW_SHOWNORMAL);

	return true;
}

bool launch_help() {
	//todo, return sucsess or failure
	ShellExecute(hwnd, "open",
    "help\\help.html",
    NULL,//args
    s.progPath, //directory
    SW_SHOWNORMAL);

	return true;
}

