#include "cp_io.h"
#include "..\vb_set.h"
#include "..\vb_vbtD.h"



////////////////////////////////////////////////////////////////////
// Keybd Fn's     had to put it somewhere!
char VBK_DATA[30];


void kbd_init(int map) {

	VBK_DATA[VBK_FSD]  = KEY_MINUS; 
	VBK_DATA[VBK_FSU]  = KEY_EQUALS;
	VBK_DATA[VBK_SWP]  = KEY_CLOSEBRACE;
	VBK_DATA[VBK_PRN]  = KEY_P;
	VBK_DATA[VBK_STS]  = KEY_0;

	if(map!=0) {
		VBK_DATA[VBK_vBATT]= KEY_W;
		VBK_DATA[VBK_vA]   = KEY_M;
		VBK_DATA[VBK_vB]   = KEY_N;
		VBK_DATA[VBK_vR]   = KEY_H;
		VBK_DATA[VBK_vL]   = KEY_G;
		VBK_DATA[VBK_vRR]  = KEY_L;
		VBK_DATA[VBK_vRU]  = KEY_I;
		VBK_DATA[VBK_vLR]  = KEY_F;
		VBK_DATA[VBK_vLL]  = KEY_S;
		VBK_DATA[VBK_vLD]  = KEY_D;
		VBK_DATA[VBK_vLU]  = KEY_E;
		VBK_DATA[VBK_vSTR] = KEY_B;
		VBK_DATA[VBK_VSEL] = KEY_V;
		VBK_DATA[VBK_RL]   = KEY_J;
		VBK_DATA[VBK_RD]   = KEY_K;
	} else {
		VBK_DATA[VBK_vBATT]= KEY_W;
		VBK_DATA[VBK_vA]   = KEY_Z;
		VBK_DATA[VBK_vB]   = KEY_X;
		VBK_DATA[VBK_vR]   = KEY_S;
		VBK_DATA[VBK_vL]   = KEY_A;
		VBK_DATA[VBK_vRU]  = KEY_F;
		VBK_DATA[VBK_vRR]  = KEY_B;
		VBK_DATA[VBK_vLR]  = KEY_RIGHT;
		VBK_DATA[VBK_vLL]  = KEY_LEFT;
		VBK_DATA[VBK_vLD]  = KEY_DOWN;
		VBK_DATA[VBK_vLU]  = KEY_UP;
		VBK_DATA[VBK_vSTR] = KEY_Q;
		VBK_DATA[VBK_VSEL] = KEY_W;
		VBK_DATA[VBK_RL]   = KEY_C;
		VBK_DATA[VBK_RD]   = KEY_V;
	}
}

//Read the Controller, Fix Me....
HWORD V810_RControll() {
	
	//delay so keys don't run away
	static unsigned int FS_DELAY = 0;

	if(!FS_DELAY) {
		if(key[VBK_DATA[VBK_FSD]] || key[VBK_DATA[VBK_FSU]] || key[VBK_DATA[VBK_SWP]] || key[VBK_DATA[VBK_STS]])
			FS_DELAY = 5;

		//Handle Frame Skip
		if(key[VBK_DATA[VBK_FSD]]) 
			tVBOpt.FRMSKIP -= (tVBOpt.FRMSKIP==0)?0:1;
		if(key[VBK_DATA[VBK_FSU]])
			tVBOpt.FRMSKIP += (tVBOpt.FRMSKIP>15)?0:1;

		//Flip 3D display
		if(key[VBK_DATA[VBK_SWP]])
			tVBOpt.DSPSWAP = (tVBOpt.DSPSWAP)?0:1; 

		//Turn on status
		if(key[VBK_DATA[VBK_STS]])
			tVBOpt.STATUS = (tVBOpt.STATUS)?0:1; 
	} else {
		FS_DELAY--;
	}

    int t1 = 0;
    if(key[VBK_DATA[VBK_vBATT]]) t1=t1|0x0001;     // Batery Low
    if(key[VBK_DATA[VBK_vA]])    t1=t1|0x0004;
    if(key[VBK_DATA[VBK_vB]])    t1=t1|0x0008;
    if(key[VBK_DATA[VBK_vR]])    t1=t1|0x0010;
    if(key[VBK_DATA[VBK_vL]])    t1=t1|0x0020;
    if(key[VBK_DATA[VBK_vRU]])   t1=t1|0x0040;
    if(key[VBK_DATA[VBK_vRR]])   t1=t1|0x0080;
    if(key[VBK_DATA[VBK_vLR]])   t1=t1|0x0100;
    if(key[VBK_DATA[VBK_vLL]])   t1=t1|0x0200;
    if(key[VBK_DATA[VBK_vLD]])   t1=t1|0x0400;
    if(key[VBK_DATA[VBK_vLU]])   t1=t1|0x0800;
    if(key[VBK_DATA[VBK_vSTR]])  t1=t1|0x1000;
    if(key[VBK_DATA[VBK_VSEL]])  t1=t1|0x2000;
    if(key[VBK_DATA[VBK_RL]])    t1=t1|0x4000;
    if(key[VBK_DATA[VBK_RD]])    t1=t1|0x8000;
    t1=t1|0x0002;                   // Always set bit1, ctrl ID
    return t1;
}

int init_graphics() {

	int aDspM;

    allegro_init();
    install_keyboard(); 
    clear_keybuf();

	int scr_mode[] = 
		{GFX_AUTODETECT_WINDOWED,
		GFX_AUTODETECT_FULLSCREEN,
		GFX_AUTODETECT_FULLSCREEN,
		GFX_AUTODETECT_FULLSCREEN,
		GFX_AUTODETECT_FULLSCREEN };


    aDspM = scr_mode[tVBOpt.SCR_MODE];

	if(tVBOpt.DEBUG)
		tVBOpt.SCR_X = tVBOpt.SCR_Y = 512;

    if(set_gfx_mode(aDspM, tVBOpt.SCR_X, tVBOpt.SCR_Y, 0, 0)<0) {
        return(false);
    }

	return true;
}

int close_graphics() {

	set_gfx_mode(GFX_TEXT,0,0,0,0);

	clear_keybuf();
    remove_keyboard();
    allegro_exit();

	return true;
}
