////////////////////////////////////////////////////////////////
// Defines for the VB Core
#ifndef V810_VBT_H_
#define V810_VBT_H_

#include <stdio.h>

#define VB_VER_STR_1 "Reality Boy emu v0.81 (02/24/2005),  By the VB-98 Team"
#define VB_VER_STR_2 "Copyright (C) 1997-2005 David Tucker\n  all rights reserved"

//Memory Structure for the VIP Reg 
//packed so we can acess it as an array of HWORDS
typedef struct {
        HWORD INTPND;
        HWORD INTENB;
		HWORD PAD_1[13];//padding for array access
        HWORD INTCLR;
        HWORD DPSTTS;
        HWORD DPCTRL;
        HWORD BRTA;
        HWORD BRTB;
        HWORD BRTC;
        HWORD REST;
		HWORD PAD_2;	//padding for array access
        HWORD FRMCYC;
        HWORD CTA;
		HWORD PAD_3[7];	//padding for array access
        HWORD XPSTTS;
        HWORD XPCTRL;
        HWORD VER;
		HWORD PAD_4;	//padding for array access
        HWORD SPT[4];
		HWORD PAD_5[8];	//padding for array access
        HWORD GPLT[4];
        HWORD JPLT[4];
        HWORD BKCOL;
        HWORD tFrame;	//not publicly visible
} V810_VIPREGDAT;

typedef struct {
        BYTE SCR;       //Serial Controll Reg,  0x02000028
        BYTE WCR;       //Wait Controll Reg,    0x02000024
        BYTE TCR;       //Timer Controll Reg,   0x02000020
        BYTE THB;       //Timer Higher Byte,    0x0200001C
        BYTE TLB;       //Timer Lower Byte,     0x02000018
        HWORD tTHW;		//Timer TempHWord, 	not publicly visible
        WORD tTRC;      //Timer TempResolutionCount, not publicly visible
        HWORD tCount;   //Timer Counter register, not publicly visible
        BYTE tReset;    //Timer Reset register, not publicly visible
        BYTE SHB;       //Serial Higher Byte,   0x02000014  //Read Only
        BYTE SLB;       //Serial Lower Byte,    0x02000010  //Read Only
        BYTE CDRR;      //Com Recv Data Reg,    0x0200000C  //Read Only
        BYTE CDTR;      //Com Trans Data Reg,   0x02000008
        BYTE CCSR;      //Com Cnt Stat Reg,     0x02000004
        BYTE CCR;       //Com Controll Reg,     0x02000000
} V810_HREGDAT;

//Export some data structs...
//extern FILE *ferr;
extern V810_MEMORYFETCH V810_ROM1; // US Games
extern V810_MEMORYFETCH V810_DISPLAY_RAM;
extern V810_MEMORYFETCH V810_SOUND_RAM;
extern V810_MEMORYFETCH V810_VB_RAM; 
extern V810_MEMORYFETCH V810_GAME_RAM; 
extern V810_VIPREGDAT tVIPREG;
extern V810_HREGDAT   tHReg;
extern V810_REGFETCH V810_VIPCREG; 


// Memory read functions
BYTE  mem_rbyte(WORD addr);
HWORD mem_rhword(WORD addr);
WORD  mem_rword(WORD addr);

//Memory Write Func
void mem_wbyte(WORD addr, BYTE data);
void mem_whword(WORD addr, HWORD data);
void mem_wword(WORD addr, WORD data);

// Port read functions
BYTE  port_rbyte(WORD addr);
HWORD port_rhword(WORD addr);
WORD  port_rword(WORD addr);

//Port Write Func
void port_wbyte(WORD addr, BYTE data);
void port_whword(WORD addr, HWORD data);
void port_wword(WORD addr, WORD data);

// Register I/O Func...
BYTE vipcreg_rbyte(WORD addr);
void vipcreg_wbyte(WORD addr, BYTE data);
HWORD vipcreg_rhword(WORD addr);
void vipcreg_whword(WORD addr, HWORD data);
WORD vipcreg_rword(WORD addr);
void vipcreg_wword(WORD addr, WORD data);

// Opens up a VB rom (pased in) and initializes the rom
// space, some day it will initialize ram as well
int v810_init(char * rom_name);

void save_sram(void);

#endif
