#ifdef MSS
#include <mss.h>
#endif


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cp_io.h"
#include "vb_set.h"

#define CL_DISP		"-display"
#define CL_DISP_FRAME	"frame"
#define CL_DISP_320	"320"
#define CL_DISP_640	"640"
#define CL_DISP_800	"800"
#define CL_DISP_1024	"1024"

#define CL_DSPMODE	"-dspmode"
#define CL_DSPMODE_NORM	"normal"
#define CL_DSPMODE_R_B	"red_blue"
#define CL_DSPMODE_INT	"interlace"
#define CL_DSPMODE_OV	"over_under"
#define CL_DSPMODE_SS	"side"
#define CL_DSPMODE_CSCOPE "cscope"

#define CL_FRMSKP		"-frmskp" 

#define CL_PALLET		"-pallet"
#define CL_PALLET_NORM	"normal"
#define CL_PALLET_RED	"red"
#define CL_PALLET_RB	"rb"
#define CL_PALLET_RG	"rg"
#define CL_PALLET_RBG	"rbg"

#define CL_BRTNES		"-brite"
#define CL_FLIP		"-flip"
#define CL_DEBUG		"-debug"
#define CL_STDOUT		"-stdout"
#define CL_LTIMMER		"-ltimmer"
#define CL_VFHACK		"-vfhack"
#define CL_DISASM		"-disasm"

#define CL_ALTKBD		"-altkbd" 
#define CL_NOTHRTL		"-nothrtl" 
#define CL_STATUS		"-status" 

#define CL_SCLSCR		"-sclscr"

#define CL_HELP1		"-?"
#define CL_HELP2		"-help"


VB_OPT         tVBOpt;


int setOptions(int argc, char *argv[]) {
   int tmp=-1;
   int done = 0;
   int vIndex = 2;
   
   //Set up the Defaults
   tVBOpt.FRMSKIP  = 0;
   tVBOpt.SCLSCR   = 1;
   tVBOpt.DSPMODE  = dm_NORMAL;
   tVBOpt.DSPSWAP  = 0;
   tVBOpt.PALMODE  = pal_NORMAL;
   tVBOpt.DEBUG    = 0;
   tVBOpt.STDOUT   = 0;
   tVBOpt.BFACTOR  = 64;
   tVBOpt.SCR_X    = 384;
   tVBOpt.SCR_Y    = 224;
   tVBOpt.SCR_MODE = vbFrame;
   tVBOpt.LTIMMER  = 0;
   tVBOpt.VFHACK   = 0;
   tVBOpt.DISASM   = 0;
   tVBOpt.KBD_MAP  = 0;
   tVBOpt.NO_THRTL = 0;
   tVBOpt.STATUS   = 0;

   if ((argc < 2)||(strcmp(argv[1], CL_HELP1) == 0)||(strcmp(argv[1], CL_HELP2) == 0)) {
      printf(" Usage: reality_boy <rom_name.vb> [-options]\n");
      printf(" Options: \n");
      printf("  -display (frame, 320, 640, 800, 1024) \n");
      printf("  -dspmode (normal, red_blue, interlace, over_under, side, cscope)\n");
      printf("  -frmskp (0-9)\n");
      printf("  -pallet (normal, red, rb, rg, rbg)\n");
      //printf("  -brite (0-127)\n");
	  printf("  -sclscr (1-4)\n");
      printf("  -flip\n");
      printf("  -altkbd\n");
      printf("  -ltimmer\n");
      printf("  -vfhack\n");
	  printf("  -nothrtl\n");
	  printf("  -status\n");
#ifdef DBG_PRINT
      printf("  -debug\n");
      printf("    -disasm\n");
      printf("    -stdout\n");
#endif
      return 0; //fail, quit program
   }

   tVBOpt.PROG_NAME = argv[0];
   tVBOpt.ROM_NAME  = argv[1];

   //Break if we have no optional params...
   //todo, insert tolower() so we are not case sensitive
   if(argc <= 2) done = 1;

   while(!done) {

      if (strcmp(argv[vIndex], CL_DISP) == 0) {
         if (strcmp(argv[vIndex+1], CL_DISP_FRAME) == 0) {
            tVBOpt.SCR_MODE = vbFrame; //Vesa2
            tVBOpt.SCR_X   = 384;
            tVBOpt.SCR_Y   = 224;
         } else if (strcmp(argv[vIndex+1], CL_DISP_320) == 0) {
            tVBOpt.SCR_MODE = vb320; //VGA
            tVBOpt.SCR_X   = 320;
            tVBOpt.SCR_Y   = 200;
         } else if (strcmp(argv[vIndex+1], CL_DISP_640) == 0) {
            tVBOpt.SCR_MODE = vb640; //Vesa1
            tVBOpt.SCR_X   = 640;
            tVBOpt.SCR_Y   = 480;
         } else if (strcmp(argv[vIndex+1], CL_DISP_800) == 0) {
            tVBOpt.SCR_MODE = vb800; //Vesa1
            tVBOpt.SCR_X   = 800;
            tVBOpt.SCR_Y   = 600;
         } else if (strcmp(argv[vIndex+1], CL_DISP_1024) == 0) {
            tVBOpt.SCR_MODE = vb1024; //Vesa1
            tVBOpt.SCR_X   = 1024;
            tVBOpt.SCR_Y   = 768;
         }
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_DSPMODE) == 0){
         if (strcmp(argv[vIndex+1], CL_DSPMODE_NORM) == 0) {
            tVBOpt.DSPMODE = dm_NORMAL;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_R_B) == 0) {
            tVBOpt.DSPMODE = dm_RedBlue;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_INT) == 0) {
            tVBOpt.DSPMODE = dm_INTERLACED;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_OV) == 0) {
            tVBOpt.DSPMODE = dm_OVRUNDR;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_SS) == 0) {
            tVBOpt.DSPMODE = dm_SIDESIDE;
         } else if (strcmp(argv[vIndex+1], CL_DSPMODE_CSCOPE) == 0) {
            tVBOpt.DSPMODE = dm_CYBERSCOPE;
         }
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_PALLET) == 0){
         if (strcmp(argv[vIndex+1], CL_PALLET_NORM) == 0) {
            tVBOpt.PALMODE = pal_NORMAL;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RED) == 0) {
            tVBOpt.PALMODE = pal_RED;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RB) == 0) {
            tVBOpt.PALMODE = pal_RB;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RG) == 0) {
            tVBOpt.PALMODE = pal_RG;
         } else if (strcmp(argv[vIndex+1], CL_PALLET_RBG) == 0) {
            tVBOpt.PALMODE = pal_RBG;
         }
         vIndex+=2;

      }else if (strcmp(argv[vIndex], CL_FRMSKP) == 0){
         tmp=atoi(argv[vIndex+1]);
	     if((tmp>=0)&&(tmp<=9)) 
			 tVBOpt.FRMSKIP = tmp;
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_SCLSCR) == 0){
         tmp=atoi(argv[vIndex+1]);
         if((tmp>=1)&&(tmp<=6)) 
			 tVBOpt.SCLSCR = tmp;
         vIndex+=2;
      }else if (strcmp(argv[vIndex], CL_BRTNES) == 0){
         tmp=atoi(argv[vIndex+1]);
	     if((tmp>=0)&&(tmp<=127)) 
			 tVBOpt.BFACTOR = tmp;
         vIndex+=2;

      }else if (strcmp(argv[vIndex], CL_FLIP) == 0){
         tVBOpt.DSPSWAP = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_LTIMMER) == 0){ 
         tVBOpt.LTIMMER = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_VFHACK) == 0){ 
         tVBOpt.VFHACK = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_ALTKBD) == 0){
         tVBOpt.KBD_MAP = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_NOTHRTL) == 0){
         tVBOpt.NO_THRTL = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_STATUS) == 0){
         tVBOpt.STATUS = 1;
         vIndex++;
		 
#ifdef DBG_PRINT
      }else if (strcmp(argv[vIndex], CL_DISASM) == 0){ 
         tVBOpt.DISASM = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_DEBUG) == 0){
         tVBOpt.DEBUG = 1;
         vIndex++;
      }else if (strcmp(argv[vIndex], CL_STDOUT) == 0){
         tVBOpt.STDOUT = 1;
         vIndex++;
#endif
      } else {
         vIndex++;
      }
      if(vIndex >= argc) done = 1;
   }

   //set screen resolution if selecting windowed mode
   if(tVBOpt.SCR_MODE==0) {
		switch(tVBOpt.DSPMODE) {
		case dm_NORMAL:
		case dm_RedBlue:
			tVBOpt.SCR_X   = 384*tVBOpt.SCLSCR;
			tVBOpt.SCR_Y   = 224*tVBOpt.SCLSCR;
			break;
		case dm_INTERLACED:
		case dm_OVRUNDR:
			tVBOpt.SCR_X   = 384*tVBOpt.SCLSCR;
			tVBOpt.SCR_Y   = 448*tVBOpt.SCLSCR;
			break;

		case dm_SIDESIDE:
			tVBOpt.SCR_X   = 768*tVBOpt.SCLSCR;
			tVBOpt.SCR_Y   = 224*tVBOpt.SCLSCR;
			break;

		case dm_CYBERSCOPE:
			tVBOpt.SCR_X   = 448*tVBOpt.SCLSCR;
			tVBOpt.SCR_Y   = 384*tVBOpt.SCLSCR;
			break;
		default:
			break;
		};
   }

   //initialize keyboard mappings
   kbd_init(tVBOpt.KBD_MAP);
   
   return 1;
}

